/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.Json;
import io.debezium.engine.spi.OffsetCommitPolicy;
import io.debezium.relational.history.FileDatabaseHistory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.extend.DefaultExtendedHandler;
import org.apache.inlong.agent.plugin.sources.file.AbstractSource;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSource.class);
    private static final Integer DEBEZIUM_QUEUE_SIZE = 100;
    private ExecutorService executor;
    public InstanceProfile profile;
    private BlockingQueue<AbstractSource.SourceData> debeziumQueue;
    private Properties props = new Properties();
    private String snapshotMode;
    private String dbName;
    private String tableName;
    private String schema;

    @Override
    protected String getThreadName() {
        return "oracle-source-" + this.taskId + "-" + this.instanceId;
    }

    @Override
    protected void initExtendClass() {
        this.extendClass = DefaultExtendedHandler.class.getCanonicalName();
    }

    @Override
    protected void initSource(InstanceProfile profile) {
        try {
            LOGGER.info("OracleSource init: {}", (Object)profile.toJsonStr());
            this.debeziumQueue = new LinkedBlockingQueue<AbstractSource.SourceData>(DEBEZIUM_QUEUE_SIZE);
            this.dbName = profile.get("task.oracleTask.dbname");
            this.tableName = profile.get("task.oracleTask.tableIncludeList");
            this.schema = profile.get("task.oracleTask.schemaIncludeList");
            this.snapshotMode = profile.get("task.oracleTask.snapshotMode", "initial");
            this.props.setProperty("name", "Oracle-" + this.instanceId);
            this.props.setProperty("connector.class", OracleConnector.class.getName());
            String agentPath = AgentConfiguration.getAgentConf().get("agent.home", AgentConstants.DEFAULT_AGENT_HOME);
            String offsetPath = agentPath + "/data/" + this.getThreadName() + "/offset.dat";
            String historyPath = agentPath + "/data/" + this.getThreadName() + "/history.dat";
            this.props.setProperty("offset.storage", FileOffsetBackingStore.class.getName());
            this.props.setProperty("offset.storage.file.filename", offsetPath);
            this.props.setProperty("database.history", FileDatabaseHistory.class.getCanonicalName());
            this.props.setProperty("database.history.file.filename", historyPath);
            this.props.setProperty(String.valueOf(OracleConnectorConfig.HOSTNAME), profile.get("task.oracleTask.hostname"));
            this.props.setProperty(String.valueOf(OracleConnectorConfig.PORT), profile.get("task.oracleTask.port"));
            this.props.setProperty(String.valueOf(OracleConnectorConfig.USER), profile.get("task.oracleTask.user"));
            this.props.setProperty(String.valueOf(OracleConnectorConfig.PASSWORD), profile.get("task.oracleTask.password"));
            this.props.setProperty(String.valueOf(OracleConnectorConfig.TABLE_INCLUDE_LIST), this.schema + "." + this.tableName);
            this.props.setProperty(String.valueOf(OracleConnectorConfig.SERVER_NAME), this.getThreadName());
            this.props.setProperty(String.valueOf(OracleConnectorConfig.DATABASE_NAME), profile.get("task.oracleTask.dbname"));
            this.props.setProperty(String.valueOf(OracleConnectorConfig.SCHEMA_INCLUDE_LIST), this.schema);
            this.props.setProperty(String.valueOf(OracleConnectorConfig.SNAPSHOT_MODE), this.snapshotMode);
            this.props.setProperty(String.valueOf(OracleConnectorConfig.DECIMAL_HANDLING_MODE), "string");
            this.props.setProperty("key.converter.schemas.enable", "false");
            this.props.setProperty("value.converter.schemas.enable", "false");
            this.executor = Executors.newSingleThreadExecutor();
            this.executor.execute(this.startDebeziumEngine());
        }
        catch (Exception ex) {
            this.stopRunning();
            throw new FileException("error init stream for " + this.instanceId, (Throwable)ex);
        }
    }

    private Runnable startDebeziumEngine() {
        return () -> {
            AgentThreadFactory.nameThread((String)(this.getThreadName() + "debezium"));
            try (DebeziumEngine debeziumEngine = DebeziumEngine.create(Json.class).using(this.props).using(OffsetCommitPolicy.always()).notifying(this::handleConsumerEvent).build();){
                debeziumEngine.run();
            }
            catch (Throwable e) {
                LOGGER.error("do run error in postgres debezium: ", e);
            }
        };
    }

    private void handleConsumerEvent(List<ChangeEvent<String, String>> records, DebeziumEngine.RecordCommitter<ChangeEvent<String, String>> committer) throws InterruptedException {
        for (ChangeEvent<String, String> record : records) {
            boolean offerSuc = false;
            AbstractSource.SourceData sourceData = new AbstractSource.SourceData(this, ((String)record.value()).getBytes(StandardCharsets.UTF_8), "0L");
            while (this.isRunnable() && !offerSuc) {
                offerSuc = this.debeziumQueue.offer(sourceData, 1L, TimeUnit.SECONDS);
            }
            committer.markProcessed(record);
        }
        committer.markBatchFinished();
    }

    @Override
    protected void printCurrentState() {
        LOGGER.info("oracle table is {}", (Object)this.tableName);
    }

    @Override
    protected boolean doPrepareToRead() {
        return true;
    }

    @Override
    protected List<AbstractSource.SourceData> readFromSource() {
        ArrayList<AbstractSource.SourceData> dataList = new ArrayList<AbstractSource.SourceData>();
        try {
            AbstractSource.SourceData sourceData;
            for (int size = 0; size < this.BATCH_READ_LINE_TOTAL_LEN && (sourceData = this.debeziumQueue.poll(1L, TimeUnit.SECONDS)) != null; size += sourceData.getData().length) {
                LOGGER.info("readFromSource: {}", (Object)sourceData.getData());
                dataList.add(sourceData);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("poll {} data from debezium queue interrupted.", (Object)this.instanceId);
        }
        return dataList;
    }

    @Override
    public Message read() {
        return super.read();
    }

    @Override
    protected boolean isRunnable() {
        return this.runnable;
    }

    @Override
    protected void releaseSource() {
        LOGGER.info("release oracle source");
        this.executor.shutdownNow();
    }

    @Override
    public boolean sourceFinish() {
        return super.sourceFinish();
    }

    public boolean sourceExist() {
        return true;
    }
}

