/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.store;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.store.KeyValueEntity;
import org.apache.inlong.agent.store.Store;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBStoreImpl
implements Store {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksDBStoreImpl.class);
    private static final Gson GSON = new Gson();
    public static final String SPLITTER = "_";
    public static final String UNIQUE_KEY = "";
    private final AgentConfiguration conf = AgentConfiguration.getAgentConf();
    private final RocksDB db;
    private final String commandFamilyName = "command";
    private final String defaultFamilyName = "default";
    private ConcurrentHashMap<String, ColumnFamilyHandle> columnHandlesMap;
    private ConcurrentHashMap<String, ColumnFamilyDescriptor> columnDescriptorMap;
    private String storePath;

    public RocksDBStoreImpl(String childPath) {
        this.db = this.initEnv(childPath);
        this.addColumnFamily("command");
    }

    private static ColumnFamilyDescriptor getColumnFamilyDescriptor(byte[] columnFamilyName) {
        return new ColumnFamilyDescriptor(columnFamilyName, new ColumnFamilyOptions());
    }

    private RocksDB initEnv(String childPath) {
        String parentPath = this.conf.get("agent.home", AgentConstants.DEFAULT_AGENT_HOME);
        LOGGER.info("parentPath {} childPath {}", (Object)parentPath, (Object)childPath);
        File finalPath = new File(parentPath, childPath);
        this.storePath = finalPath.getAbsolutePath();
        RocksDB.loadLibrary();
        try {
            boolean result = finalPath.mkdirs();
            LOGGER.info("create directory {}, result is {}", (Object)finalPath, (Object)result);
            this.columnHandlesMap = new ConcurrentHashMap();
            this.columnDescriptorMap = new ConcurrentHashMap();
            DBOptions dbOptions = new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setWalDir(finalPath.getAbsolutePath()).setStatistics(new Statistics());
            List<ColumnFamilyDescriptor> managedColumnFamilies = this.loadManagedColumnFamilies(dbOptions);
            ArrayList managedHandles = new ArrayList();
            RocksDB rocksDB = RocksDB.open((DBOptions)dbOptions, (String)finalPath.getAbsolutePath(), managedColumnFamilies, managedHandles);
            for (int index = 0; index < managedHandles.size(); ++index) {
                ColumnFamilyHandle handle = (ColumnFamilyHandle)managedHandles.get(index);
                ColumnFamilyDescriptor descriptor = managedColumnFamilies.get(index);
                String familyNameFromHandle = new String(handle.getName());
                String familyNameFromDescriptor = new String(descriptor.getName());
                this.columnHandlesMap.put(familyNameFromHandle, handle);
                this.columnDescriptorMap.put(familyNameFromDescriptor, descriptor);
            }
            return rocksDB;
        }
        catch (Exception ex) {
            LOGGER.error("init rocksdb error, please check", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private List<ColumnFamilyDescriptor> loadManagedColumnFamilies(DBOptions dbOptions) throws RocksDBException {
        ArrayList<ColumnFamilyDescriptor> managedColumnFamilies = new ArrayList<ColumnFamilyDescriptor>();
        Options options = new Options(dbOptions, new ColumnFamilyOptions());
        List existing = RocksDB.listColumnFamilies((Options)options, (String)this.storePath);
        if (existing.isEmpty()) {
            LOGGER.info("no previous column family found, use default");
            managedColumnFamilies.add(RocksDBStoreImpl.getColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY));
        } else {
            LOGGER.info("loading column families :" + existing.stream().map(String::new).collect(Collectors.toList()));
            managedColumnFamilies.addAll(existing.stream().map(RocksDBStoreImpl::getColumnFamilyDescriptor).collect(Collectors.toList()));
        }
        return managedColumnFamilies;
    }

    public void addColumnFamily(String columnFamilyName) {
        this.columnDescriptorMap.computeIfAbsent(columnFamilyName, colFamilyName -> {
            try {
                ColumnFamilyDescriptor descriptor = RocksDBStoreImpl.getColumnFamilyDescriptor(colFamilyName.getBytes());
                ColumnFamilyHandle handle = this.db.createColumnFamily(descriptor);
                this.columnHandlesMap.put((String)colFamilyName, handle);
                return descriptor;
            }
            catch (RocksDBException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public KeyValueEntity get(String key) {
        Objects.requireNonNull(key);
        try {
            byte[] bytes = this.db.get(this.columnHandlesMap.get("default"), key.getBytes());
            return bytes == null ? null : (KeyValueEntity)GSON.fromJson(new String(bytes), KeyValueEntity.class);
        }
        catch (Exception e) {
            throw new RuntimeException("get key value entity error", e);
        }
    }

    public void put(KeyValueEntity entity) {
        Objects.requireNonNull(entity);
        try {
            this.db.put(this.columnHandlesMap.get("default"), entity.getKey().getBytes(), GSON.toJson((Object)entity).getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("put value to rocks db error", e);
        }
    }

    public KeyValueEntity remove(String key) {
        Objects.requireNonNull(key);
        KeyValueEntity keyValueEntity = this.get(key);
        if (keyValueEntity == null) {
            LOGGER.warn("no key {} exist in rocksdb", (Object)key);
            return null;
        }
        try {
            this.db.delete(this.columnHandlesMap.get("default"), key.getBytes());
            return keyValueEntity;
        }
        catch (Exception e) {
            throw new RuntimeException("remove value from rocks db error", e);
        }
    }

    public List<KeyValueEntity> findAll(String prefix) {
        LinkedList<KeyValueEntity> results = new LinkedList<KeyValueEntity>();
        try (RocksIterator it = this.db.newIterator(this.columnHandlesMap.get("default"));){
            it.seekToFirst();
            while (it.isValid()) {
                KeyValueEntity keyValue = (KeyValueEntity)GSON.fromJson(new String(it.value()), KeyValueEntity.class);
                if (keyValue.getKey().startsWith(prefix)) {
                    results.add(keyValue);
                }
                it.next();
            }
        }
        return results;
    }

    public String getSplitter() {
        return SPLITTER;
    }

    public String getUniqueKey() {
        return UNIQUE_KEY;
    }

    public String replaceKeywords(String source) {
        return source;
    }

    public void close() throws IOException {
        this.db.close();
        this.columnHandlesMap.values().forEach(AbstractImmutableNativeReference::close);
        this.columnHandlesMap.clear();
        this.columnDescriptorMap.clear();
    }
}

