/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GuidConversions {
    private GuidConversions() {
    }

    @NotNull
    static ByteString guidToByteString(@NotNull UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return ByteString.of((byte[])bb.array());
    }

    @NotNull
    static String guidToString(@NotNull UUID uuid) {
        return uuid.toString();
    }

    @Nullable
    static Object convert(@NotNull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof UUID) {
            UUID uuid = (UUID)o;
            return implicit ? GuidConversions.implicitConversion(uuid, targetType) : GuidConversions.explicitConversion(uuid, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@NotNull UUID uuid, BuiltinDataType targetType) {
        switch (targetType) {
            case ByteString: {
                return GuidConversions.guidToByteString(uuid);
            }
            case String: {
                return GuidConversions.guidToString(uuid);
            }
        }
        return GuidConversions.implicitConversion(uuid, targetType);
    }

    @Nullable
    static Object implicitConversion(@NotNull UUID uuid, BuiltinDataType targetType) {
        return null;
    }
}

