/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.agent.runtime;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.confignode.manager.pipe.extractor.ConfigRegionListeningFilter;
import org.apache.iotdb.confignode.manager.pipe.extractor.ConfigRegionListeningQueue;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class PipeConfigRegionListener {
    private final ConfigRegionListeningQueue listeningQueue = new ConfigRegionListeningQueue();
    private int listeningQueueReferenceCount = 0;
    private final AtomicBoolean isLeaderReady = new AtomicBoolean(false);

    public synchronized ConfigRegionListeningQueue listener() {
        return this.listeningQueue;
    }

    public synchronized void increaseReference(PipeParameters parameters) throws IllegalPathException {
        if (!ConfigRegionListeningFilter.parseListeningPlanTypeSet(parameters).isEmpty()) {
            ++this.listeningQueueReferenceCount;
            if (this.listeningQueueReferenceCount == 1) {
                this.listeningQueue.open();
            }
        }
    }

    public synchronized void decreaseReference(PipeParameters parameters) throws IllegalPathException {
        if (!ConfigRegionListeningFilter.parseListeningPlanTypeSet(parameters).isEmpty()) {
            --this.listeningQueueReferenceCount;
            if (this.listeningQueueReferenceCount == 0) {
                this.listeningQueue.close();
            }
        }
    }

    public synchronized boolean isLeaderReady() {
        return this.isLeaderReady.get();
    }

    public synchronized void notifyLeaderReady() {
        this.isLeaderReady.set(true);
    }

    public synchronized void notifyLeaderUnavailable() {
        this.isLeaderReady.set(false);
    }
}

