/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.BuiltInScalarFunctionHelper;
import org.apache.iotdb.db.queryengine.plan.expression.multi.builtin.BuiltInScalarFunctionHelperFactory;
import org.apache.tsfile.enums.TSDataType;

public class TypeInferenceUtils {
    private static final IoTDBConfig CONF = IoTDBDescriptor.getInstance().getConfig();

    private TypeInferenceUtils() {
    }

    private static boolean isBlob(String s) {
        return s.length() >= 3 && s.startsWith("X'") && s.endsWith("'");
    }

    public static boolean isNumber(String s) {
        if (s == null || s.equals("NaN")) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return !s.endsWith("F") && !s.endsWith("f") && !s.endsWith("D") && !s.endsWith("d");
    }

    private static boolean isBoolean(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    private static boolean isLong(String s) {
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isConvertFloatPrecisionLack(String s) {
        try {
            return Long.parseLong(s) > 0x1000000L;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public static TSDataType getPredictedDataType(Object value, boolean inferType) {
        if (value instanceof Boolean) {
            return TSDataType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return TSDataType.INT32;
        }
        if (value instanceof Long) {
            return TSDataType.INT64;
        }
        if (value instanceof Float) {
            return TSDataType.FLOAT;
        }
        if (value instanceof Double) {
            return TSDataType.DOUBLE;
        }
        if (inferType) {
            String strValue = value.toString();
            if (TypeInferenceUtils.isBoolean(strValue)) {
                return CONF.getBooleanStringInferType();
            }
            if (TypeInferenceUtils.isNumber(strValue)) {
                if (TypeInferenceUtils.isLong(StringUtils.trim((String)strValue))) {
                    return CONF.getIntegerStringInferType();
                }
                return CONF.getFloatingStringInferType();
            }
            if ("null".equals(strValue) || "NULL".equals(strValue)) {
                return null;
            }
            if ("NaN".equals(strValue)) {
                return CONF.getNanStringInferType();
            }
            if (TypeInferenceUtils.isBlob(strValue)) {
                return TSDataType.BLOB;
            }
            return TSDataType.TEXT;
        }
        return TSDataType.TEXT;
    }

    public static TSDataType getBuiltinAggregationDataType(String aggregationFunctionName, TSDataType dataType) {
        if (aggregationFunctionName == null) {
            throw new IllegalArgumentException("AggregateFunction Name must not be null");
        }
        TypeInferenceUtils.verifyIsAggregationDataTypeMatched(aggregationFunctionName, dataType);
        switch (aggregationFunctionName.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": 
            case "count_time": 
            case "count_if": 
            case "time_duration": {
                return TSDataType.INT64;
            }
            case "min_value": 
            case "last_value": 
            case "first_value": 
            case "max_value": 
            case "extreme": 
            case "mode": 
            case "max_by": 
            case "min_by": {
                return dataType;
            }
            case "avg": 
            case "sum": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                return TSDataType.DOUBLE;
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggregationFunctionName);
    }

    private static void verifyIsAggregationDataTypeMatched(String aggrFuncName, TSDataType dataType) {
        if (dataType == null) {
            return;
        }
        switch (aggrFuncName.toLowerCase()) {
            case "min_value": 
            case "max_value": {
                if (dataType.isNumeric() || TSDataType.STRING.equals((Object)dataType) || TSDataType.DATE.equals((Object)dataType) || TSDataType.TIMESTAMP.equals((Object)dataType)) {
                    return;
                }
                throw new SemanticException("Aggregate functions [MIN_VALUE, MAX_VALUE] only support data types [INT32, INT64, FLOAT, DOUBLE, STRING, DATE, TIMESTAMP]");
            }
            case "avg": 
            case "sum": 
            case "extreme": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                if (dataType.isNumeric()) {
                    return;
                }
                throw new SemanticException("Aggregate functions [AVG, SUM, EXTREME, STDDEV, STDDEV_POP, STDDEV_SAMP, VARIANCE, VAR_POP, VAR_SAMP] only support numeric data types [INT32, INT64, FLOAT, DOUBLE]");
            }
            case "count": 
            case "count_time": 
            case "min_time": 
            case "max_time": 
            case "first_value": 
            case "last_value": 
            case "time_duration": 
            case "mode": 
            case "max_by": 
            case "min_by": {
                return;
            }
            case "count_if": {
                if (dataType != TSDataType.BOOLEAN) {
                    throw new SemanticException(String.format("Input series of Aggregation function [%s] only supports data type [BOOLEAN]", aggrFuncName));
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggrFuncName);
    }

    public static void bindTypeForBuiltinAggregationNonSeriesInputExpressions(String functionName, List<Expression> inputExpressions, List<List<Expression>> outputExpressionLists) {
        switch (functionName.toLowerCase()) {
            case "avg": 
            case "sum": 
            case "extreme": 
            case "min_value": 
            case "max_value": 
            case "count": 
            case "count_time": 
            case "min_time": 
            case "max_time": 
            case "first_value": 
            case "last_value": 
            case "time_duration": 
            case "mode": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": 
            case "max_by": 
            case "min_by": {
                return;
            }
            case "count_if": {
                Expression keepExpression = inputExpressions.get(1);
                if (keepExpression instanceof ConstantOperand) {
                    outputExpressionLists.add(Collections.singletonList(keepExpression));
                    return;
                }
                if (keepExpression instanceof CompareBinaryExpression) {
                    Expression leftExpression = ((CompareBinaryExpression)keepExpression).getLeftExpression();
                    Expression rightExpression = ((CompareBinaryExpression)keepExpression).getRightExpression();
                    if (leftExpression instanceof TimeSeriesOperand && leftExpression.getExpressionString().equalsIgnoreCase("keep") && rightExpression.isConstantOperand()) {
                        outputExpressionLists.add(Collections.singletonList(ExpressionUtils.reconstructBinaryExpression((Expression)keepExpression, (Expression)new TimeSeriesOperand((PartialPath)new MeasurementPath(((TimeSeriesOperand)leftExpression).getPath(), TSDataType.INT64)), (Expression)rightExpression)));
                        return;
                    }
                    throw new SemanticException(String.format("Please check input keep condition of Aggregation function [%s]", functionName));
                }
                throw new SemanticException(String.format("Keep condition of Aggregation function [%s] need to be constant or compare expression constructed by keep and a long number", functionName));
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + functionName);
    }

    public static TSDataType getBuiltInScalarFunctionDataType(FunctionExpression functionExpression, TSDataType dataType) {
        String functionName = functionExpression.getFunctionName();
        if (functionName == null) {
            throw new IllegalArgumentException("ScalarFunction Name must not be null.");
        }
        BuiltInScalarFunctionHelper helper = BuiltInScalarFunctionHelperFactory.createHelper((String)functionName);
        if (dataType != null) {
            helper.checkBuiltInScalarFunctionInputDataType(dataType);
        }
        return helper.getBuiltInScalarFunctionReturnType(functionExpression);
    }

    public static boolean canAutoCast(TSDataType fromType, TSDataType toType) {
        if (fromType.equals((Object)toType)) {
            return true;
        }
        switch (fromType) {
            case INT32: {
                switch (toType) {
                    case INT64: 
                    case FLOAT: 
                    case DOUBLE: {
                        return true;
                    }
                }
                return false;
            }
            case INT64: 
            case FLOAT: {
                return toType.equals((Object)TSDataType.DOUBLE);
            }
            case DOUBLE: 
            case BOOLEAN: 
            case TEXT: 
            case DATE: 
            case TIMESTAMP: 
            case BLOB: 
            case STRING: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + fromType);
    }
}

