/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.MemChunkHandleImpl;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.BitMap;

public class MemAlignedChunkHandleImpl
extends MemChunkHandleImpl {
    private final int column;
    private final List<BitMap> bitMapOfValue;
    private final long[] startEndTime;

    public MemAlignedChunkHandleImpl(IDeviceID deviceID, String measurement, long[] dataOfTimestamp, List<BitMap> bitMapOfValue, int column, long[] startEndTime) {
        super(deviceID, measurement, dataOfTimestamp);
        this.bitMapOfValue = bitMapOfValue;
        this.column = column;
        this.startEndTime = startEndTime;
    }

    @Override
    public long[] getPageStatisticsTime() {
        return this.startEndTime;
    }

    @Override
    public long[] getDataTime() throws IOException {
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 0; i < this.dataOfTimestamp.length; ++i) {
            if (this.bitMapOfValue != null && this.bitMapOfValue.get(i).isMarked(this.column) || i != this.dataOfTimestamp.length - 1 && this.dataOfTimestamp[i] == this.dataOfTimestamp[i + 1]) continue;
            timeList.add(this.dataOfTimestamp[i]);
        }
        this.hasRead = true;
        return timeList.stream().mapToLong(Long::longValue).toArray();
    }
}

