/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.adapter;

import java.io.IOException;
import org.apache.iotdb.commons.udf.utils.UDFBinaryTransformer;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.type.Binary;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.utils.BytesUtils;

public class PointCollectorAdaptor
implements PointCollector {
    private final ColumnBuilder timeColumnBuilder;
    private final ColumnBuilder valueColumnBuilder;

    public PointCollectorAdaptor(ColumnBuilder timeColumnBuilder, ColumnBuilder valueColumnBuilder) {
        this.timeColumnBuilder = timeColumnBuilder;
        this.valueColumnBuilder = valueColumnBuilder;
    }

    public void putInt(long timestamp, int value) throws IOException {
        this.timeColumnBuilder.writeLong(timestamp);
        this.valueColumnBuilder.writeInt(value);
    }

    public void putLong(long timestamp, long value) throws IOException {
        this.timeColumnBuilder.writeLong(timestamp);
        this.valueColumnBuilder.writeLong(value);
    }

    public void putFloat(long timestamp, float value) throws IOException {
        this.timeColumnBuilder.writeLong(timestamp);
        this.valueColumnBuilder.writeFloat(value);
    }

    public void putDouble(long timestamp, double value) throws IOException {
        this.timeColumnBuilder.writeLong(timestamp);
        this.valueColumnBuilder.writeDouble(value);
    }

    public void putBoolean(long timestamp, boolean value) throws IOException {
        this.timeColumnBuilder.writeLong(timestamp);
        this.valueColumnBuilder.writeBoolean(value);
    }

    public void putBinary(long timestamp, Binary value) throws IOException {
        this.timeColumnBuilder.writeLong(timestamp);
        this.valueColumnBuilder.writeBinary(UDFBinaryTransformer.transformToBinary((Binary)value));
    }

    public void putString(long timestamp, String value) throws IOException {
        this.timeColumnBuilder.writeLong(timestamp);
        this.valueColumnBuilder.writeBinary(BytesUtils.valueOf((String)value));
    }

    public void putNull(long timestamp) {
        this.timeColumnBuilder.writeLong(timestamp);
        this.valueColumnBuilder.appendNull();
    }

    public TimeColumn buildTimeColumn() {
        return (TimeColumn)this.timeColumnBuilder.build();
    }

    public Column buildValueColumn() {
        return this.valueColumnBuilder.build();
    }
}

