/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.store;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.confignode.consensus.request.write.procedure.DeleteProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProcedureStore
implements IProcedureStore<ConfigNodeProcedureEnv> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigProcedureStore.class);
    private volatile boolean isRunning = false;
    private final ProcedureInfo procedureInfo;
    private final String procedureWalDir = CommonDescriptor.getInstance().getConfig().getProcedureWalFolder();
    private final ConfigManager configManager;

    public ConfigProcedureStore(ConfigManager configManager, ProcedureInfo procedureInfo) {
        this.configManager = configManager;
        this.procedureInfo = procedureInfo;
        try {
            this.checkProcWalDir(this.procedureWalDir);
        }
        catch (IOException e) {
            LOG.error("ConfigProcedureStore start failed ", (Throwable)e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setRunning(boolean running) {
        this.isRunning = running;
    }

    @Override
    public List<Procedure<ConfigNodeProcedureEnv>> load() {
        return this.procedureInfo.oldLoad();
    }

    @Override
    public List<Procedure<ConfigNodeProcedureEnv>> getProcedures() {
        return this.procedureInfo.getProcedures();
    }

    @Override
    public ProcedureInfo getProcedureInfo() {
        return this.procedureInfo;
    }

    @Override
    public long getNextProcId() {
        return this.procedureInfo.getNextProcId();
    }

    @Override
    public void update(Procedure<ConfigNodeProcedureEnv> procedure) {
        Objects.requireNonNull(ProcedureFactory.getProcedureType(procedure), "Procedure type is null");
        UpdateProcedurePlan updateProcedurePlan = new UpdateProcedurePlan(procedure);
        try {
            this.configManager.getConsensusManager().write(updateProcedurePlan);
        }
        catch (ConsensusException e) {
            LOG.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
        }
    }

    @Override
    public void update(Procedure[] subprocs) {
        for (Procedure subproc : subprocs) {
            this.update(subproc);
        }
    }

    @Override
    public void delete(long procId) {
        DeleteProcedurePlan deleteProcedurePlan = new DeleteProcedurePlan();
        deleteProcedurePlan.setProcId(procId);
        try {
            this.configManager.getConsensusManager().write(deleteProcedurePlan);
        }
        catch (ConsensusException e) {
            LOG.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
        }
    }

    @Override
    public void delete(long[] childProcIds) {
        for (long childProcId : childProcIds) {
            this.delete(childProcId);
        }
    }

    @Override
    public void delete(long[] batchIds, int startIndex, int batchCount) {
        for (int i = startIndex; i < batchCount; ++i) {
            this.delete(batchIds[i]);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void start() {
        if (!this.isRunning) {
            this.isRunning = true;
        }
    }

    private void checkProcWalDir(String procedureWalDir) throws IOException {
        File dir = new File(procedureWalDir);
        this.checkOldProcWalDir(dir);
    }

    public static void createOldProcWalDir() throws IOException {
        File dir = new File(CommonDescriptor.getInstance().getConfig().getProcedureWalFolder());
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                LOG.info("Make procedure wal dir: {}", (Object)dir);
            } else {
                throw new IOException(String.format("Start ConfigNode failed, because couldn't make system dirs: %s.", dir.getAbsolutePath()));
            }
        }
    }

    private void checkOldProcWalDir(File newDir) {
        File oldDir = new File(CommonDescriptor.getInstance().getConfig().getOldProcedureWalFolder());
        if (oldDir.exists()) {
            FileUtils.moveFileSafe((File)oldDir, (File)newDir);
        }
    }

    @Override
    public boolean isOldVersionProcedureStore() {
        return this.procedureInfo.isOldVersion();
    }
}

