/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.internal.StringUtils;

public class BasicCsvArrayHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private List<String> parsed;

    public static BasicCsvArrayHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicCsvArrayHeader(name, value);
    }

    public static BasicCsvArrayHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicCsvArrayHeader(name, value);
    }

    public BasicCsvArrayHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.getParsedValue();
        }
    }

    @Override
    public String getValue() {
        Object o = this.getRawValue();
        if (o instanceof String) {
            return (String)o;
        }
        return StringUtils.joine(this.getParsedValue(), ',');
    }

    public boolean contains(String val) {
        List<String> vv = this.getParsedValue();
        if (val != null && vv != null) {
            for (String v : vv) {
                if (!StringUtils.isEquals(v, val)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsIc(String val) {
        List<String> vv = this.getParsedValue();
        if (val != null && vv != null) {
            for (String v : vv) {
                if (!StringUtils.isEqualsIc(v, val)) continue;
                return true;
            }
        }
        return false;
    }

    public FluentListAssertion<BasicCsvArrayHeader> assertList() {
        return new FluentListAssertion<BasicCsvArrayHeader>(this.asList(), this);
    }

    public List<String> asList() {
        List<String> l = this.getParsedValue();
        return l == null ? null : Collections.unmodifiableList(l);
    }

    private List<String> getParsedValue() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        AList l = AList.of();
        if (o instanceof Collection) {
            for (Object o2 : (Collection)o) {
                l.add(StringUtils.stringify(o2));
            }
        } else if (o.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                l.add(StringUtils.stringify(Array.get(o, i)));
            }
        } else {
            for (String s : StringUtils.split(o.toString())) {
                l.add(s);
            }
        }
        return l.unmodifiable();
    }
}

