/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.mstat;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.juneau.mstat.ExceptionHasher;
import org.apache.juneau.mstat.ExceptionInfo;
import org.apache.juneau.mstat.ExceptionStats;

public class ExceptionStore {
    private final ConcurrentHashMap<Integer, ExceptionStats> sdb = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, ExceptionInfo> idb = new ConcurrentHashMap();
    private final ExceptionHasher hasher;
    private final long cacheTimeout;

    public ExceptionStore() {
        this(-1L, null);
    }

    public ExceptionStore(long cacheTimeout, Class<?> stopClass) {
        this.hasher = new ExceptionHasher(stopClass);
        this.cacheTimeout = cacheTimeout;
    }

    public ExceptionStore add(Throwable e) {
        this.find(e).increment();
        return this;
    }

    public ExceptionStats getStackTraceInfo(Throwable e) {
        return this.find(e).clone();
    }

    public void reset() {
        this.sdb.clear();
    }

    public List<ExceptionStats> getClonedStats() {
        return this.sdb.values().stream().map(x -> x.clone()).sorted().collect(Collectors.toList());
    }

    private ExceptionStats find(Throwable e) {
        if (e == null) {
            return null;
        }
        int hash = this.hasher.hash(e);
        ExceptionStats stc = this.sdb.get(hash);
        if (stc != null && !stc.isExpired()) {
            return stc;
        }
        stc = ((ExceptionStats)ExceptionStats.create().hash(Integer.toHexString(hash)).timeout(this.cacheTimeout == -1L ? Long.MAX_VALUE : System.currentTimeMillis() + this.cacheTimeout).message(e.getMessage()).exceptionClass(e.getClass().getName()).stackTrace((List)this.hasher.getStackTrace(e))).causedBy(e.getCause() == null ? null : this.findInfo(e.getCause()));
        this.sdb.put(hash, stc);
        return this.sdb.get(hash);
    }

    private ExceptionInfo findInfo(Throwable e) {
        int hash = this.hasher.hash(e);
        ExceptionInfo ei = this.sdb.get(hash);
        if (ei == null) {
            ei = ExceptionInfo.create().hash(Integer.toHexString(hash)).message(e.getMessage()).exceptionClass(e.getClass().getName()).stackTrace(this.hasher.getStackTrace(e)).causedBy(e.getCause() == null ? null : this.findInfo(e.getCause()));
            this.idb.put(hash, ei);
        }
        return ei;
    }
}

