/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.rest.Inherit;
import org.apache.juneau.rest.None;
import org.apache.juneau.uon.UonReader;

public final class RestUtils {
    private static Map<Integer, String> httpMsgs = AMap.of().a(100, "Continue").a(101, "Switching Protocols").a(102, "Processing").a(103, "Early Hints").a(200, "OK").a(201, "Created").a(202, "Accepted").a(203, "Non-Authoritative Information").a(204, "No Content").a(205, "Reset Content").a(206, "Partial Content").a(300, "Multiple Choices").a(301, "Moved Permanently").a(302, "Temporary Redirect").a(303, "See Other").a(304, "Not Modified").a(305, "Use Proxy").a(307, "Temporary Redirect").a(400, "Bad Request").a(401, "Unauthorized").a(402, "Payment Required").a(403, "Forbidden").a(404, "Not Found").a(405, "Method Not Allowed").a(406, "Not Acceptable").a(407, "Proxy Authentication Required").a(408, "Request Time-Out").a(409, "Conflict").a(410, "Gone").a(411, "Length Required").a(412, "Precondition Failed").a(413, "Request Entity Too Large").a(414, "Request-URI Too Large").a(415, "Unsupported Media Type").a(500, "Internal Server Error").a(501, "Not Implemented").a(502, "Bad Gateway").a(503, "Service Unavailable").a(504, "Gateway Timeout").a(505, "HTTP Version Not Supported");
    private static final Pattern INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");

    public static String getHttpResponseText(int rc) {
        return httpMsgs.get(rc);
    }

    public static String getPathInfoUndecoded(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        String contextPath = req.getContextPath();
        String servletPath = req.getServletPath();
        int l = contextPath.length() + servletPath.length();
        if (requestURI.length() == l) {
            return null;
        }
        return requestURI.substring(l);
    }

    public static StringBuffer trimPathInfo(StringBuffer requestURI, String contextPath, String servletPath) {
        if (servletPath.equals("/")) {
            servletPath = "";
        }
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        try {
            int sc = 0;
            for (int i = 0; i < requestURI.length(); ++i) {
                int c = requestURI.charAt(i);
                if (c == 47) {
                    int j;
                    if (++sc != 3) continue;
                    if (servletPath.isEmpty()) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    for (j = 0; j < contextPath.length(); ++j) {
                        if (requestURI.charAt(i) != contextPath.charAt(j)) {
                            throw new Exception("case=1");
                        }
                        ++i;
                    }
                    for (j = 0; j < servletPath.length(); ++j) {
                        if (requestURI.charAt(i) != servletPath.charAt(j)) {
                            throw new Exception("case=2");
                        }
                        ++i;
                    }
                    int n = c = requestURI.length() == i ? 47 : (int)requestURI.charAt(i);
                    if (c == 47 || c == 63) {
                        requestURI.setLength(i);
                        return requestURI;
                    }
                    throw new Exception("case=3");
                }
                if (c != 63) continue;
                if (sc != 2) {
                    throw new Exception("case=4");
                }
                if (servletPath.isEmpty()) {
                    requestURI.setLength(i);
                    return requestURI;
                }
                throw new Exception("case=5");
            }
            if (servletPath.isEmpty()) {
                return requestURI;
            }
            throw new Exception("case=6");
        }
        catch (Exception e) {
            throw new BasicRuntimeException(e, "Could not find servlet path in request URI.  URI=''{0}'', servletPath=''{1}''", requestURI, servletPath);
        }
    }

    public static String[] parseHeader(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            i = s.indexOf(61);
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim().toLowerCase(Locale.ENGLISH);
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    public static String[] parseKeyValuePair(String s) {
        int i = -1;
        for (int j = 0; j < s.length() && i < 0; ++j) {
            char c = s.charAt(j);
            if (c != '=' && c != ':') continue;
            i = j;
        }
        if (i == -1) {
            return null;
        }
        String name = s.substring(0, i).trim();
        String val = s.substring(i + 1).trim();
        return new String[]{name, val};
    }

    static String resolveNewlineSeparatedAnnotation(String[] value, String fromParent) {
        if (value.length == 0) {
            return fromParent;
        }
        AList<String> l = AList.of();
        for (String v : value) {
            if (!"INHERIT".equals(v)) {
                l.add(v);
                continue;
            }
            if (fromParent == null) continue;
            l.a(fromParent);
        }
        return StringUtils.join(l, '\n');
    }

    static String[] resolveLinks(String[] links, String[] parentLinks) {
        if (links.length == 0) {
            return parentLinks;
        }
        AList<String> list = AList.of();
        for (String l : links) {
            if ("INHERIT".equals(l)) {
                list.a(parentLinks);
                continue;
            }
            if (l.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(l).matches()) {
                Matcher lm = INDEXED_LINK_PATTERN.matcher(l);
                lm.matches();
                String key = lm.group(1);
                int index = Math.min(list.size(), Integer.parseInt(lm.group(2)));
                String remainder = lm.group(3);
                list.add(index, key.isEmpty() ? remainder : key + ":" + remainder);
                continue;
            }
            list.add(l);
        }
        return list.asArrayOf(String.class);
    }

    static String[] resolveContent(String[] content, String[] parentContent) {
        if (content.length == 0) {
            return parentContent;
        }
        AList<String> list = AList.of();
        for (String l : content) {
            if ("INHERIT".equals(l)) {
                list.a(parentContent);
                continue;
            }
            if ("NONE".equals(l)) {
                return new String[0];
            }
            list.add(l);
        }
        return list.asArrayOf(String.class);
    }

    public static Map<String, String[]> parseQuery(Object qs) {
        return RestUtils.parseQuery(qs, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String[]> parseQuery(Object qs, Map<String, String[]> map) {
        try {
            Map<String, String[]> m = map;
            if (m == null) {
                m = new LinkedHashMap<String, String[]>();
            }
            if (qs == null) return m;
            if (qs instanceof CharSequence && StringUtils.isEmpty(qs)) {
                return m;
            }
            try (ParserPipe p = new ParserPipe(qs);){
                boolean S1 = true;
                int S2 = 2;
                int S3 = 3;
                int S4 = 4;
                try (UonReader r = new UonReader(p, true);){
                    int c = r.peekSkipWs();
                    if (c == 63) {
                        r.read();
                    }
                    int state = 1;
                    String currAttr = null;
                    while (c != -1) {
                        c = r.read();
                        if (state == 1) {
                            if (c == -1) continue;
                            r.unread();
                            r.mark();
                            state = 2;
                            continue;
                        }
                        if (state == 2) {
                            if (c == -1) {
                                RestUtils.add(m, r.getMarked(), null);
                                continue;
                            }
                            if (c == 1) {
                                m.put(r.getMarked(0, -1), null);
                                state = 1;
                                continue;
                            }
                            if (c != 2) continue;
                            currAttr = r.getMarked(0, -1);
                            state = 3;
                            continue;
                        }
                        if (state == 3) {
                            if (c == -1 || c == 1) {
                                RestUtils.add(m, currAttr, "");
                                state = 1;
                                continue;
                            }
                            if (c == 2) {
                                r.replace('=');
                            }
                            r.unread();
                            r.mark();
                            state = 4;
                            continue;
                        }
                        if (state != 4) continue;
                        if (c == -1) {
                            RestUtils.add(m, currAttr, r.getMarked());
                            continue;
                        }
                        if (c == 1) {
                            RestUtils.add(m, currAttr, r.getMarked(0, -1));
                            state = 1;
                            continue;
                        }
                        if (c != 2) continue;
                        r.replace('=');
                    }
                }
                Map<String, String[]> map2 = m;
                return map2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void add(Map<String, String[]> m, String key, String val) {
        boolean b = m.containsKey(key);
        if (val == null) {
            if (!b) {
                m.put(key, null);
            }
        } else if (b && m.get(key) != null) {
            m.put(key, ArrayUtils.append((Object[])m.get(key), val));
        } else {
            m.put(key, new String[]{val});
        }
    }

    public static Object parseAnything(String s) throws ParseException {
        if (StringUtils.isJson(s)) {
            return JsonParser.DEFAULT.parse(s, Object.class);
        }
        return s;
    }

    public static Object[] merge(Object[] fromParent, Object[] fromChild) {
        if (fromParent == null) {
            fromParent = new Object[]{};
        }
        if (ArrayUtils.contains(None.class, fromChild)) {
            return new Object[0];
        }
        if (fromChild.length == 0) {
            return fromParent;
        }
        if (!ArrayUtils.contains(Inherit.class, fromChild)) {
            return fromChild;
        }
        AList<Object> l = AList.of();
        for (Object o : fromChild) {
            if (o == Inherit.class) {
                l.a(fromParent);
                continue;
            }
            l.add(o);
        }
        return l.asArrayOf(Object.class);
    }

    public static String trimContextPath(String contextPath, String path) {
        if (path == null) {
            return null;
        }
        if (path.length() == 0 || path.equals("/") || contextPath.length() == 0 || contextPath.equals("/")) {
            return path;
        }
        String op = path;
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (contextPath.charAt(0) == '/') {
            contextPath = contextPath.substring(1);
        }
        if (path.startsWith(contextPath)) {
            if (path.length() == contextPath.length()) {
                return "/";
            }
            if ((path = path.substring(contextPath.length())).isEmpty() || path.charAt(0) == '/') {
                return path;
            }
        }
        return op;
    }

    public static String fixMethodPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals("/")) {
            return path;
        }
        return StringUtils.trimTrailingSlashes(path);
    }

    public static boolean isValidContextPath(String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        if (value.charAt(value.length() - 1) == '/') {
            return false;
        }
        return value.charAt(0) == '/';
    }

    public static String toValidContextPath(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        if ((s = StringUtils.trimTrailingSlashes(s)).isEmpty()) {
            return s;
        }
        if (s.charAt(0) != '/') {
            s = '/' + s;
        }
        return s;
    }

    public static void validateContextPath(String value) {
        if (!RestUtils.isValidContextPath(value)) {
            throw new RuntimeException("Value is not a valid context path: [" + value + "]");
        }
    }

    public static boolean isValidServletPath(String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        if (value.equals("/")) {
            return false;
        }
        if (value.charAt(value.length() - 1) == '/') {
            return false;
        }
        return value.charAt(0) == '/';
    }

    public static void validateServletPath(String value) {
        if (!RestUtils.isValidServletPath(value)) {
            throw new RuntimeException("Value is not a valid servlet path: [" + value + "]");
        }
    }

    public static boolean isValidPathInfo(String value) {
        if (value == null) {
            return true;
        }
        if (value.isEmpty()) {
            return false;
        }
        return value.charAt(0) == '/';
    }

    public static void validatePathInfo(String value) {
        if (!RestUtils.isValidPathInfo(value)) {
            throw new RuntimeException("Value is not a valid path-info path: [" + value + "]");
        }
    }
}

