/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.uon.UonBeanPropertyMeta;
import org.apache.juneau.uon.UonClassMeta;
import org.apache.juneau.uon.UonCommon;
import org.apache.juneau.uon.UonMetaProvider;
import org.apache.juneau.uon.UonSerializerBuilder;
import org.apache.juneau.uon.UonSerializerSession;

@ConfigurableContext
public class UonSerializer
extends WriterSerializer
implements HttpPartSerializer,
UonMetaProvider,
UonCommon {
    static final String PREFIX = "UonSerializer";
    public static final String UON_addBeanTypes = "UonSerializer.addBeanTypes.b";
    public static final String UON_encoding = "UonSerializer.encoding.b";
    public static final String UON_paramFormat = "UonSerializer.paramFormat.s";
    public static final UonSerializer DEFAULT = new UonSerializer(PropertyStore.DEFAULT);
    public static final UonSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    public static final UonSerializer DEFAULT_ENCODING = new Encoding(PropertyStore.DEFAULT);
    private final boolean encoding;
    private final boolean addBeanTypes;
    private final char quoteChar;
    private final ParamFormat paramFormat;
    private final Map<ClassMeta<?>, UonClassMeta> uonClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, UonBeanPropertyMeta> uonBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, UonBeanPropertyMeta>();

    public String serialize(HttpPartType partType, HttpPartSchema schema, Object value) throws SchemaValidationException, SerializeException {
        return this.createPartSession(null).serialize(partType, schema, value);
    }

    public UonSerializer(PropertyStore ps) {
        this(ps, "text/uon", null);
    }

    public UonSerializer() {
        this(PropertyStore.DEFAULT, "text/uon", null);
    }

    public UonSerializer(PropertyStore ps, String produces, String accept) {
        super(ps, produces, accept);
        this.encoding = this.getBooleanProperty(UON_encoding, false);
        this.addBeanTypes = this.getBooleanProperty(UON_addBeanTypes, this.getBooleanProperty("Serializer.addBeanTypes.b", false));
        this.paramFormat = this.getProperty(UON_paramFormat, ParamFormat.class, ParamFormat.UON);
        this.quoteChar = this.getStringProperty("WriterSerializer.quoteChar.s", "'").charAt(0);
    }

    @Override
    public UonSerializerBuilder builder() {
        return new UonSerializerBuilder(this.getPropertyStore());
    }

    public static UonSerializerBuilder create() {
        return new UonSerializerBuilder();
    }

    @Override
    public UonSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public UonSerializerSession createSession(SerializerSessionArgs args) {
        return new UonSerializerSession(this, null, args);
    }

    @Override
    public UonSerializerSession createPartSession(SerializerSessionArgs args) {
        return new UonSerializerSession(this, null, args);
    }

    @Override
    public UonClassMeta getUonClassMeta(ClassMeta<?> cm) {
        UonClassMeta m = this.uonClassMetas.get(cm);
        if (m == null) {
            m = new UonClassMeta(cm, this);
            this.uonClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public UonBeanPropertyMeta getUonBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return UonBeanPropertyMeta.DEFAULT;
        }
        UonBeanPropertyMeta m = this.uonBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new UonBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.uonBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.addBeanTypes;
    }

    protected final boolean isEncoding() {
        return this.encoding;
    }

    protected final ParamFormat getParamFormat() {
        return this.paramFormat;
    }

    @Override
    protected final char getQuoteChar() {
        return this.quoteChar;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("encoding", this.encoding).a("addBeanTypes", this.addBeanTypes).a("paramFormat", (Object)this.paramFormat));
    }

    public static class Encoding
    extends UonSerializer {
        public Encoding(PropertyStore ps) {
            super(ps.builder().setDefault(UonSerializer.UON_encoding, true).build());
        }
    }

    public static class Readable
    extends UonSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().setDefault("WriterSerializer.useWhitespace.b", true).build());
        }
    }
}

