/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.Type;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.arg.RestOpArg;

public class ContentArg
implements RestOpArg {
    private final HttpPartSchema schema;
    private final Type type;

    public static ContentArg create(ParamInfo paramInfo) {
        if (paramInfo.hasAnnotation(Content.class) || paramInfo.getParameterType().hasAnnotation(Content.class)) {
            return new ContentArg(paramInfo);
        }
        return null;
    }

    protected ContentArg(ParamInfo paramInfo) {
        this.type = paramInfo.getParameterType().innerType();
        this.schema = HttpPartSchema.create(Content.class, (ParamInfo)paramInfo);
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        return opSession.getRequest().getContent().setSchema(this.schema).as(this.type, new Type[0]);
    }
}

