/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.html5;

import java.util.LinkedHashMap;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

@Html(format=HtmlFormat.XML)
@FluentSetters
public abstract class HtmlElement {
    private LinkedHashMap<String, Object> attrs;

    @Xml(format=XmlFormat.ATTRS)
    @Beanp(value="a")
    public LinkedHashMap<String, Object> getAttrs() {
        return this.attrs;
    }

    @Beanp(value="a")
    public HtmlElement setAttrs(LinkedHashMap<String, Object> attrs) {
        if (attrs != null) {
            attrs.entrySet().forEach(x -> {
                String key = (String)x.getKey();
                if ("url".equals(key) || "href".equals(key) || key.endsWith("action")) {
                    x.setValue(StringUtils.toURI(x.getValue()));
                }
            });
        }
        this.attrs = attrs;
        return this;
    }

    public HtmlElement attr(String key, Object val) {
        if (this.attrs == null) {
            this.attrs = CollectionUtils.map();
        }
        if (val == null) {
            this.attrs.remove(key);
        } else {
            if ("url".equals(key) || "href".equals(key) || key.endsWith("action")) {
                val = StringUtils.toURI(val);
            }
            this.attrs.put(key, val);
        }
        return this;
    }

    public HtmlElement attrUri(String key, Object val) {
        if (this.attrs == null) {
            this.attrs = CollectionUtils.map();
        }
        this.attrs.put(key, StringUtils.toURI(val));
        return this;
    }

    public String getAttr(String key) {
        return this.getAttr(String.class, key);
    }

    public <T> T getAttr(Class<T> type, String key) {
        return this.attrs == null ? null : (T)ConverterUtils.toType(this.attrs.get(key), type);
    }

    @FluentSetter
    public HtmlElement accesskey(String accesskey) {
        this.attr("accesskey", accesskey);
        return this;
    }

    @FluentSetter
    public HtmlElement _class(String _class) {
        this.attr("class", _class);
        return this;
    }

    @FluentSetter
    public HtmlElement contenteditable(Object contenteditable) {
        this.attr("contenteditable", contenteditable);
        return this;
    }

    @FluentSetter
    public HtmlElement dir(String dir) {
        this.attr("dir", dir);
        return this;
    }

    @FluentSetter
    public HtmlElement hidden(Object hidden) {
        this.attr("hidden", this.deminimize(hidden, "hidden"));
        return this;
    }

    @FluentSetter
    public HtmlElement id(String id) {
        this.attr("id", id);
        return this;
    }

    @FluentSetter
    public HtmlElement lang(String lang) {
        this.attr("lang", lang);
        return this;
    }

    @FluentSetter
    public HtmlElement onabort(String onabort) {
        this.attr("onabort", onabort);
        return this;
    }

    @FluentSetter
    public HtmlElement onblur(String onblur) {
        this.attr("onblur", onblur);
        return this;
    }

    @FluentSetter
    public HtmlElement oncancel(String oncancel) {
        this.attr("oncancel", oncancel);
        return this;
    }

    @FluentSetter
    public HtmlElement oncanplay(String oncanplay) {
        this.attr("oncanplay", oncanplay);
        return this;
    }

    @FluentSetter
    public HtmlElement oncanplaythrough(String oncanplaythrough) {
        this.attr("oncanplaythrough", oncanplaythrough);
        return this;
    }

    @FluentSetter
    public HtmlElement onchange(String onchange) {
        this.attr("onchange", onchange);
        return this;
    }

    @FluentSetter
    public HtmlElement onclick(String onclick) {
        this.attr("onclick", onclick);
        return this;
    }

    @FluentSetter
    public HtmlElement oncuechange(String oncuechange) {
        this.attr("oncuechange", oncuechange);
        return this;
    }

    @FluentSetter
    public HtmlElement ondblclick(String ondblclick) {
        this.attr("ondblclick", ondblclick);
        return this;
    }

    @FluentSetter
    public HtmlElement ondurationchange(String ondurationchange) {
        this.attr("ondurationchange", ondurationchange);
        return this;
    }

    @FluentSetter
    public HtmlElement onemptied(String onemptied) {
        this.attr("onemptied", onemptied);
        return this;
    }

    @FluentSetter
    public HtmlElement onended(String onended) {
        this.attr("onended", onended);
        return this;
    }

    @FluentSetter
    public HtmlElement onerror(String onerror) {
        this.attr("onerror", onerror);
        return this;
    }

    @FluentSetter
    public HtmlElement onfocus(String onfocus) {
        this.attr("onfocus", onfocus);
        return this;
    }

    @FluentSetter
    public HtmlElement oninput(String oninput) {
        this.attr("oninput", oninput);
        return this;
    }

    @FluentSetter
    public HtmlElement oninvalid(String oninvalid) {
        this.attr("oninvalid", oninvalid);
        return this;
    }

    @FluentSetter
    public HtmlElement onkeydown(String onkeydown) {
        this.attr("onkeydown", onkeydown);
        return this;
    }

    @FluentSetter
    public HtmlElement onkeypress(String onkeypress) {
        this.attr("onkeypress", onkeypress);
        return this;
    }

    @FluentSetter
    public HtmlElement onkeyup(String onkeyup) {
        this.attr("onkeyup", onkeyup);
        return this;
    }

    @FluentSetter
    public HtmlElement onload(String onload) {
        this.attr("onload", onload);
        return this;
    }

    @FluentSetter
    public HtmlElement onloadeddata(String onloadeddata) {
        this.attr("onloadeddata", onloadeddata);
        return this;
    }

    @FluentSetter
    public HtmlElement onloadedmetadata(String onloadedmetadata) {
        this.attr("onloadedmetadata", onloadedmetadata);
        return this;
    }

    @FluentSetter
    public HtmlElement onloadstart(String onloadstart) {
        this.attr("onloadstart", onloadstart);
        return this;
    }

    @FluentSetter
    public HtmlElement onmousedown(String onmousedown) {
        this.attr("onmousedown", onmousedown);
        return this;
    }

    @FluentSetter
    public HtmlElement onmouseenter(String onmouseenter) {
        this.attr("onmouseenter", onmouseenter);
        return this;
    }

    @FluentSetter
    public HtmlElement onmouseleave(String onmouseleave) {
        this.attr("onmouseleave", onmouseleave);
        return this;
    }

    @FluentSetter
    public HtmlElement onmousemove(String onmousemove) {
        this.attr("onmousemove", onmousemove);
        return this;
    }

    @FluentSetter
    public HtmlElement onmouseout(String onmouseout) {
        this.attr("onmouseout", onmouseout);
        return this;
    }

    @FluentSetter
    public HtmlElement onmouseover(String onmouseover) {
        this.attr("onmouseover", onmouseover);
        return this;
    }

    @FluentSetter
    public HtmlElement onmouseup(String onmouseup) {
        this.attr("onmouseup", onmouseup);
        return this;
    }

    @FluentSetter
    public HtmlElement onmousewheel(String onmousewheel) {
        this.attr("onmousewheel", onmousewheel);
        return this;
    }

    @FluentSetter
    public HtmlElement onpause(String onpause) {
        this.attr("onpause", onpause);
        return this;
    }

    @FluentSetter
    public HtmlElement onplay(String onplay) {
        this.attr("onplay", onplay);
        return this;
    }

    @FluentSetter
    public HtmlElement onplaying(String onplaying) {
        this.attr("onplaying", onplaying);
        return this;
    }

    @FluentSetter
    public HtmlElement onprogress(String onprogress) {
        this.attr("onprogress", onprogress);
        return this;
    }

    @FluentSetter
    public HtmlElement onratechange(String onratechange) {
        this.attr("onratechange", onratechange);
        return this;
    }

    @FluentSetter
    public HtmlElement onreset(String onreset) {
        this.attr("onreset", onreset);
        return this;
    }

    @FluentSetter
    public HtmlElement onresize(String onresize) {
        this.attr("onresize", onresize);
        return this;
    }

    @FluentSetter
    public HtmlElement onscroll(String onscroll) {
        this.attr("onscroll", onscroll);
        return this;
    }

    @FluentSetter
    public HtmlElement onseeked(String onseeked) {
        this.attr("onseeked", onseeked);
        return this;
    }

    @FluentSetter
    public HtmlElement onseeking(String onseeking) {
        this.attr("onseeking", onseeking);
        return this;
    }

    @FluentSetter
    public HtmlElement onselect(String onselect) {
        this.attr("onselect", onselect);
        return this;
    }

    @FluentSetter
    public HtmlElement onshow(String onshow) {
        this.attr("onshow", onshow);
        return this;
    }

    @FluentSetter
    public HtmlElement onstalled(String onstalled) {
        this.attr("onstalled", onstalled);
        return this;
    }

    @FluentSetter
    public HtmlElement onsubmit(String onsubmit) {
        this.attr("onsubmit", onsubmit);
        return this;
    }

    @FluentSetter
    public HtmlElement onsuspend(String onsuspend) {
        this.attr("onsuspend", onsuspend);
        return this;
    }

    @FluentSetter
    public HtmlElement ontimeupdate(String ontimeupdate) {
        this.attr("ontimeupdate", ontimeupdate);
        return this;
    }

    @FluentSetter
    public HtmlElement ontoggle(String ontoggle) {
        this.attr("ontoggle", ontoggle);
        return this;
    }

    @FluentSetter
    public HtmlElement onvolumechange(String onvolumechange) {
        this.attr("onvolumechange", onvolumechange);
        return this;
    }

    @FluentSetter
    public HtmlElement onwaiting(String onwaiting) {
        this.attr("onwaiting", onwaiting);
        return this;
    }

    @FluentSetter
    public HtmlElement spellcheck(Object spellcheck) {
        this.attr("spellcheck", spellcheck);
        return this;
    }

    @FluentSetter
    public HtmlElement style(String style) {
        this.attr("style", style);
        return this;
    }

    @FluentSetter
    public HtmlElement tabindex(Object tabindex) {
        this.attr("tabindex", tabindex);
        return this;
    }

    @FluentSetter
    public HtmlElement title(String title) {
        this.attr("title", title);
        return this;
    }

    @FluentSetter
    public HtmlElement translate(Object translate) {
        this.attr("translate", translate);
        return this;
    }

    protected Object deminimize(Object value, String attr) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return attr;
            }
            return null;
        }
        return value;
    }

    public String toString() {
        return HtmlSerializer.DEFAULT_SQ.toString(this);
    }
}

