/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.beans.Introspector;
import java.lang.reflect.Method;

public class HttpUtils {
    private static final String[] LC_METHODS = new String[]{"get", "put", "post", "delete", "options", "head", "connect", "trace", "patch"};
    private static final String[] UC_METHODS = new String[]{"GET", "PUT", "POST", "DELETE", "OPTIONS", "HEAD", "CONNECT", "TRACE", "PATCH"};

    public static String detectHttpMethod(Method m, boolean detectMethod, String def) {
        String n = m.getName();
        if (detectMethod) {
            if (n.startsWith("do") && n.length() > 2) {
                String n2 = n.substring(2).toUpperCase();
                String[] stringArray = UC_METHODS;
                int n3 = stringArray.length;
                for (int i = 0; i < n3; ++i) {
                    String t = stringArray[i];
                    if (!n2.equals(t)) continue;
                    return n2;
                }
            }
            for (String t : LC_METHODS) {
                if (!n.startsWith(t) || n.length() != t.length() && !Character.isUpperCase(n.charAt(t.length()))) continue;
                return t.toUpperCase();
            }
        }
        return def;
    }

    public static String detectHttpPath(Method m, String method) {
        String n = m.getName();
        if (method == null) {
            if (n.startsWith("do") && n.length() > 2) {
                String n2 = n.substring(2).toUpperCase();
                String[] stringArray = UC_METHODS;
                int n3 = stringArray.length;
                for (int i = 0; i < n3; ++i) {
                    String t = stringArray[i];
                    if (!n2.equals(t)) continue;
                    return "/";
                }
            }
            for (String t : LC_METHODS) {
                if (!n.startsWith(t) || n.length() != t.length() && !Character.isUpperCase(n.charAt(t.length()))) continue;
                return '/' + Introspector.decapitalize(n.substring(t.length()));
            }
        } else {
            if (n.equalsIgnoreCase(method) || n.equals("do") || n.equals("_")) {
                return "/";
            }
            if (n.startsWith(method) && (n.length() == method.length() || Character.isUpperCase(n.charAt(method.length())))) {
                return '/' + Introspector.decapitalize(n.substring(method.length()));
            }
        }
        return '/' + n;
    }
}

