/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.juneau.BeanContext;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderMatch;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.BasicUriHeader;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.http.header.StringRange;
import org.apache.juneau.http.header.StringRanges;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.NotAcceptable;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.httppart.RequestAttributes;
import org.apache.juneau.rest.util.CachingHttpServletResponse;
import org.apache.juneau.rest.util.FinishablePrintWriter;
import org.apache.juneau.rest.util.FinishableServletOutputStream;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerMatch;

public final class RestResponse {
    private HttpServletResponse inner;
    private final RestRequest request;
    private Optional<Object> content;
    private ServletOutputStream sos;
    private FinishableServletOutputStream os;
    private FinishablePrintWriter w;
    private ResponseBeanMeta responseBeanMeta;
    private RestOpContext opContext;
    private Optional<HttpPartSchema> contentSchema;
    private Serializer serializer;
    private Optional<SerializerMatch> serializerMatch;
    private boolean safeHeaders;
    private int maxHeaderLength = 8096;

    RestResponse(RestOpContext opContext, RestSession session, RestRequest req) throws Exception {
        this.inner = session.getResponse();
        this.request = req;
        this.opContext = opContext;
        this.responseBeanMeta = opContext.getResponseMeta();
        RestContext context = session.getContext();
        try {
            String passThroughHeaders = this.request.getHeader("x-response-headers").orElse(null);
            if (passThroughHeaders != null) {
                JsonMap m = context.getPartParser().getPartSession().parse(HttpPartType.HEADER, null, passThroughHeaders, BeanContext.DEFAULT.getClassMeta(JsonMap.class));
                for (Map.Entry entry : m.entrySet()) {
                    this.addHeader((String)entry.getKey(), this.resolveUris(entry.getValue()));
                }
            }
        }
        catch (Exception e1) {
            throw new BadRequest(e1, "Invalid format for header 'x-response-headers'.  Must be in URL-encoded format.", new Object[0]);
        }
        String h = this.request.getHeader("accept-charset").orElse(null);
        Charset charset = null;
        if (h == null) {
            charset = opContext.getDefaultCharset();
        } else {
            for (StringRange stringRange : StringRanges.of(h).toList()) {
                if (!(stringRange.getQValue().floatValue() > 0.0f)) continue;
                if (stringRange.getName().equals("*")) {
                    charset = opContext.getDefaultCharset();
                } else if (Charset.isSupported(stringRange.getName())) {
                    charset = Charset.forName(stringRange.getName());
                }
                if (charset == null) continue;
                break;
            }
        }
        this.request.getContext().getDefaultResponseHeaders().forEach(x -> this.addHeader(x.getValue(), this.resolveUris(x.getValue())));
        opContext.getDefaultResponseHeaders().forEach(x -> this.addHeader(x.getName(), this.resolveUris(x.getValue())));
        if (charset == null) {
            throw new NotAcceptable("No supported charsets in header ''Accept-Charset'': ''{0}''", this.request.getHeader("Accept-Charset").orElse(null));
        }
        this.inner.setCharacterEncoding(charset.name());
    }

    public RestContext getContext() {
        return this.request.getContext();
    }

    public RestOpContext getOpContext() {
        return this.request.getOpContext();
    }

    public RestResponse setContent(Object output) {
        this.content = CollectionUtils.optional(output);
        return this;
    }

    public RequestAttributes getAttributes() {
        return this.request.getAttributes();
    }

    public RestResponse setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
        return this;
    }

    public Optional<Object> getContent() {
        return this.content;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public RestResponse sendPlainText(String text) throws IOException {
        this.setContentType("text/plain");
        this.getNegotiatedWriter().write(text);
        return this;
    }

    public RestResponse setContentType(String value) {
        this.inner.setContentType(value);
        return this;
    }

    public FinishableServletOutputStream getNegotiatedOutputStream() throws NotAcceptable, IOException {
        if (this.os == null) {
            Encoder encoder = null;
            EncoderSet encoders = this.request.getOpContext().getEncoders();
            String ae = this.request.getHeader("Accept-Encoding").orElse(null);
            if (ae != null && !ae.isEmpty()) {
                EncoderMatch match = encoders.getEncoderMatch(ae);
                if (match == null) {
                    if (ae.matches(".*(identity|\\*)\\s*;\\s*q\\s*=\\s*(0(?!\\.)|0\\.0).*")) {
                        throw new NotAcceptable("Unsupported encoding in request header ''Accept-Encoding'': ''{0}''\n\tSupported codings: {1}", ae, StringUtils.json(encoders.getSupportedEncodings()));
                    }
                } else {
                    encoder = match.getEncoder();
                    String encoding = match.getEncoding().toString();
                    if (!encoding.equals("identity")) {
                        this.setHeader("content-encoding", encoding);
                    }
                }
            }
            ServletOutputStream sos = this.getOutputStream();
            this.os = new FinishableServletOutputStream((OutputStream)(encoder == null ? sos : encoder.getOutputStream((OutputStream)sos)));
        }
        return this.os;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.sos == null) {
            this.sos = this.inner.getOutputStream();
        }
        return this.sos;
    }

    public boolean getOutputStreamCalled() {
        return this.sos != null;
    }

    public PrintWriter getWriter() throws IOException {
        return this.getWriter(true, false);
    }

    public PrintWriter getDirectWriter(String contentType) throws IOException {
        this.setContentType(contentType);
        this.setHeader("X-Content-Type-Options", "nosniff");
        this.setHeader("Content-Encoding", "identity");
        return this.getWriter(true, true);
    }

    public FinishablePrintWriter getNegotiatedWriter() throws NotAcceptable, IOException {
        return this.getWriter(false, false);
    }

    private FinishablePrintWriter getWriter(boolean raw, boolean autoflush) throws NotAcceptable, IOException {
        if (this.w != null) {
            return this.w;
        }
        if (this.request.isPlainText()) {
            this.setHeader("Content-Type", "text/plain");
        }
        try {
            ServletOutputStream out = raw ? this.getOutputStream() : this.getNegotiatedOutputStream();
            this.w = new FinishablePrintWriter((OutputStream)out, this.getCharacterEncoding(), autoflush);
            return this.w;
        }
        catch (UnsupportedEncodingException e) {
            String ce = this.getCharacterEncoding();
            this.setCharacterEncoding("UTF-8");
            throw new NotAcceptable("Unsupported charset in request header ''Accept-Charset'': ''{0}''", ce);
        }
    }

    public RestResponse setCharacterEncoding(String value) {
        this.inner.setCharacterEncoding(value);
        return this;
    }

    public String getCharacterEncoding() {
        return this.inner.getCharacterEncoding();
    }

    public MediaType getMediaType() {
        return MediaType.of(this.getContentType());
    }

    public String getContentType() {
        return this.inner.getContentType();
    }

    public Charset getCharset() {
        String s = this.getCharacterEncoding();
        return s == null ? null : Charset.forName(s);
    }

    public void sendRedirect(String uri) throws IOException {
        char c;
        char c2 = c = uri.length() > 0 ? uri.charAt(0) : (char)'\u0000';
        if (c != '/' && uri.indexOf("://") == -1) {
            uri = this.request.getContextPath() + '/' + uri;
        }
        this.inner.sendRedirect(uri);
    }

    public void setHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.inner.setContentType(value);
            ContentType ct = HttpHeaders.contentType(value);
            if (ct != null && ct.getParameter("charset") != null) {
                this.inner.setCharacterEncoding(ct.getParameter("charset"));
            }
        } else {
            if (this.safeHeaders) {
                value = StringUtils.stripInvalidHttpHeaderChars(value);
            }
            value = StringUtils.abbreviate(value, this.maxHeaderLength);
            this.inner.setHeader(name, value);
        }
    }

    public boolean containsHeader(String name) {
        return this.inner.containsHeader(name);
    }

    public RestResponse setHeader(String name, Object value) throws SchemaValidationException, SerializeException {
        this.setHeader(name, this.request.getPartSerializerSession().serialize(HttpPartType.HEADER, null, value));
        return this;
    }

    public RestResponse setHeader(HttpPartSchema schema, String name, Object value) throws SchemaValidationException, SerializeException {
        this.setHeader(name, this.request.getPartSerializerSession().serialize(HttpPartType.HEADER, schema, value));
        return this;
    }

    public RestResponse setContentSchema(HttpPartSchema schema) {
        this.contentSchema = CollectionUtils.optional(schema);
        return this;
    }

    public RestResponse setException(Throwable t) {
        this.request.setException(t);
        return this;
    }

    public RestResponse setNoTrace(Boolean b) {
        this.request.setNoTrace(b);
        return this;
    }

    public RestResponse setNoTrace() {
        return this.setNoTrace(true);
    }

    public RestResponse setDebug(Boolean b) throws IOException {
        this.request.setDebug(b);
        if (b.booleanValue()) {
            this.inner = CachingHttpServletResponse.wrap(this.inner);
        }
        return this;
    }

    public RestResponse setDebug() throws IOException {
        return this.setDebug(true);
    }

    public ResponseBeanMeta getResponseBeanMeta() {
        return this.responseBeanMeta;
    }

    public RestResponse setResponseBeanMeta(ResponseBeanMeta rbm) {
        this.responseBeanMeta = rbm;
        return this;
    }

    public boolean isContentOfType(Class<?> c) {
        return c.isInstance(this.getRawOutput());
    }

    public <T> T getContent(Class<T> c) {
        if (this.isContentOfType(c)) {
            return (T)this.getRawOutput();
        }
        return null;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.inner;
    }

    public void flushBuffer() throws IOException {
        if (this.w != null) {
            this.w.flush();
        }
        if (this.os != null) {
            this.os.flush();
        }
        this.inner.flushBuffer();
    }

    private Object getRawOutput() {
        return this.content == null ? null : this.content.orElse(null);
    }

    public int getStatus() {
        return this.inner.getStatus();
    }

    public RestResponse setStatus(int value) {
        this.inner.setStatus(value);
        return this;
    }

    public RestResponse setSafeHeaders() {
        this.safeHeaders = true;
        return this;
    }

    public RestResponse setMaxHeaderLength(int value) {
        this.maxHeaderLength = value;
        return this;
    }

    public RestResponse addHeader(String name, String value) {
        if (name != null && value != null) {
            if (name.equalsIgnoreCase("Content-Type")) {
                this.setHeader(name, value);
            } else {
                if (this.safeHeaders) {
                    value = StringUtils.stripInvalidHttpHeaderChars(value);
                }
                value = StringUtils.abbreviate(value, this.maxHeaderLength);
                this.inner.addHeader(name, value);
            }
        }
        return this;
    }

    public RestResponse setHeader(Header header) {
        if (header != null) {
            if (header instanceof BasicUriHeader) {
                BasicUriHeader x = (BasicUriHeader)header;
                this.setHeader(x.getName(), this.resolveUris(x.getValue()));
            } else if (header instanceof SerializedHeader) {
                SerializedHeader x = ((SerializedHeader)header).copyWith(this.request.getPartSerializerSession(), null);
                String v = x.getValue();
                if (v != null && v.indexOf("://") != -1) {
                    v = this.resolveUris(v);
                }
                this.setHeader(x.getName(), v);
            } else {
                this.setHeader(header.getName(), header.getValue());
            }
        }
        return this;
    }

    public RestResponse addHeader(Header header) {
        if (header != null) {
            if (header instanceof BasicUriHeader) {
                BasicUriHeader x = (BasicUriHeader)header;
                this.addHeader(x.getName(), this.resolveUris(x.getValue()));
            } else if (header instanceof SerializedHeader) {
                SerializedHeader x = ((SerializedHeader)header).copyWith(this.request.getPartSerializerSession(), null);
                this.addHeader(x.getName(), this.resolveUris(x.getValue()));
            } else {
                this.addHeader(header.getName(), header.getValue());
            }
        }
        return this;
    }

    private String resolveUris(Object value) {
        String s = StringUtils.stringify(value);
        return this.request.getUriResolver().resolve(s);
    }

    public String getHeader(String name) {
        return this.inner.getHeader(name);
    }

    public Optional<SerializerMatch> getSerializerMatch() {
        if (this.serializerMatch != null) {
            return this.serializerMatch;
        }
        this.serializerMatch = this.serializer != null ? CollectionUtils.optional(new SerializerMatch(this.getMediaType(), this.serializer)) : CollectionUtils.optional(this.opContext.getSerializers().getSerializerMatch(this.request.getHeader("Accept").orElse("*/*")));
        return this.serializerMatch;
    }

    public Optional<HttpPartSchema> getContentSchema() {
        ResponseBeanMeta rbm;
        if (this.contentSchema != null) {
            return this.contentSchema;
        }
        this.contentSchema = this.responseBeanMeta != null ? CollectionUtils.optional(this.responseBeanMeta.getSchema()) : ((rbm = this.opContext.getResponseBeanMeta(this.getContent(Object.class))) != null ? CollectionUtils.optional(rbm.getSchema()) : CollectionUtils.empty());
        return this.contentSchema;
    }
}

