/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.guard;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StateMachineState;
import org.apache.juneau.internal.StringUtils;

public class RoleMatcher {
    private final Exp exp;
    private static final AsciiSet WS = AsciiSet.create((String)" \t");
    private static final AsciiSet OP = AsciiSet.create((String)",|&");
    private static final AsciiSet META = AsciiSet.create((String)"*?");

    public RoleMatcher(String expression) throws ParseException {
        this.exp = this.parse(expression);
    }

    public boolean matches(Set<String> roles) {
        return roles != null && this.exp.matches(roles);
    }

    public String toString() {
        return this.exp.toString();
    }

    public Set<String> getRolesInExpression() {
        TreeSet<String> set = new TreeSet<String>();
        this.exp.appendTokens(set);
        return set;
    }

    private Exp parse(String expression) throws ParseException {
        if (StringUtils.isEmptyOrBlank((String)expression)) {
            return new Never();
        }
        expression = expression.trim();
        ArrayList ors = CollectionUtils.list((Object[])new Exp[0]);
        ArrayList ands = CollectionUtils.list((Object[])new Exp[0]);
        StateMachineState state = StateMachineState.S01;
        int i = 0;
        int mark = -1;
        int pDepth = 0;
        boolean error = false;
        for (i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (state == StateMachineState.S01) {
                if (WS.contains(c)) continue;
                if (c == '(') {
                    state = StateMachineState.S02;
                    pDepth = 0;
                    mark = i + 1;
                    continue;
                }
                if (OP.contains(c)) {
                    error = true;
                    break;
                }
                state = StateMachineState.S03;
                mark = i;
                continue;
            }
            if (state == StateMachineState.S02) {
                if (c == '(') {
                    ++pDepth;
                }
                if (c != ')') continue;
                if (pDepth > 0) {
                    --pDepth;
                    continue;
                }
                ands.add(this.parse(expression.substring(mark, i)));
                mark = -1;
                state = StateMachineState.S04;
                continue;
            }
            if (state == StateMachineState.S03) {
                if (!WS.contains(c) && !OP.contains(c)) continue;
                ands.add(RoleMatcher.parseOperand(expression.substring(mark, i)));
                mark = -1;
                if (WS.contains(c)) {
                    state = StateMachineState.S04;
                    continue;
                }
                --i;
                state = StateMachineState.S05;
                continue;
            }
            if (state == StateMachineState.S04) {
                if (WS.contains(c)) continue;
                if (OP.contains(c)) {
                    --i;
                    state = StateMachineState.S05;
                    continue;
                }
                error = true;
                break;
            }
            if (state == StateMachineState.S05) {
                if (c == '&') {
                    state = StateMachineState.S06;
                    continue;
                }
                if (ands.size() == 1) {
                    ors.add(ands.get(0));
                } else {
                    ors.add(new And(ands));
                }
                ands.clear();
                if (c == '|') {
                    state = StateMachineState.S07;
                    continue;
                }
                state = StateMachineState.S01;
                continue;
            }
            if (state == StateMachineState.S06) {
                if (WS.contains(c)) continue;
                if (c != '&') {
                    --i;
                }
                state = StateMachineState.S01;
                continue;
            }
            if (WS.contains(c)) continue;
            if (c != '|') {
                --i;
            }
            state = StateMachineState.S01;
        }
        if (error) {
            throw new ParseException("Invalid character in expression '" + expression + "' at position " + i + ". state=" + state, i);
        }
        if (state == StateMachineState.S01) {
            throw new ParseException("Could not find beginning of clause in '" + expression + "'", i);
        }
        if (state == StateMachineState.S02) {
            throw new ParseException("Could not find matching parenthesis in expression '" + expression + "'", i);
        }
        if (state == StateMachineState.S05 || state == StateMachineState.S06 || state == StateMachineState.S07) {
            throw new ParseException("Dangling clause in expression '" + expression + "'", i);
        }
        if (mark != -1) {
            ands.add(RoleMatcher.parseOperand(expression.substring(mark, expression.length())));
        }
        if (ands.size() == 1) {
            ors.add(ands.get(0));
        } else {
            ors.add(new And(ands));
        }
        if (ors.size() == 1) {
            return (Exp)ors.get(0);
        }
        return new Or(ors);
    }

    private static Exp parseOperand(String operand) {
        char c;
        boolean hasMeta = false;
        for (int i = 0; i < operand.length() && !hasMeta; hasMeta |= META.contains(c), ++i) {
            c = operand.charAt(i);
        }
        return hasMeta ? new Match(operand) : new Eq(operand);
    }

    static class Match
    extends Exp {
        final Pattern p;
        final String operand;

        Match(String operand) {
            this.operand = operand;
            this.p = StringUtils.getMatchPattern((String)operand);
        }

        @Override
        boolean matches(Set<String> roles) {
            for (String role : roles) {
                if (!this.p.matcher(role).matches()) continue;
                return true;
            }
            return false;
        }

        @Override
        void appendTokens(Set<String> set) {
            set.add(this.operand);
        }

        public String toString() {
            return "[* " + this.p.pattern().replaceAll("\\\\[QE]", "") + "]";
        }
    }

    static class Eq
    extends Exp {
        final String operand;

        Eq(String operand) {
            this.operand = operand;
        }

        @Override
        boolean matches(Set<String> roles) {
            for (String role : roles) {
                if (!this.operand.equals(role)) continue;
                return true;
            }
            return false;
        }

        @Override
        void appendTokens(Set<String> set) {
            set.add(this.operand);
        }

        public String toString() {
            return "[= " + this.operand + "]";
        }
    }

    static class Or
    extends Exp {
        Exp[] clauses;

        Or(List<Exp> clauses) {
            this.clauses = clauses.toArray(new Exp[clauses.size()]);
        }

        @Override
        boolean matches(Set<String> roles) {
            for (Exp e : this.clauses) {
                if (!e.matches(roles)) continue;
                return true;
            }
            return false;
        }

        @Override
        void appendTokens(Set<String> set) {
            for (Exp clause : this.clauses) {
                clause.appendTokens(set);
            }
        }

        public String toString() {
            return "(| " + StringUtils.join((Object[])this.clauses, (String)" ") + ')';
        }
    }

    static class And
    extends Exp {
        Exp[] clauses;

        And(List<Exp> clauses) {
            this.clauses = clauses.toArray(new Exp[clauses.size()]);
        }

        @Override
        boolean matches(Set<String> roles) {
            for (Exp e : this.clauses) {
                if (e.matches(roles)) continue;
                return false;
            }
            return true;
        }

        @Override
        void appendTokens(Set<String> set) {
            for (Exp clause : this.clauses) {
                clause.appendTokens(set);
            }
        }

        public String toString() {
            return "(& " + StringUtils.join((Object[])this.clauses, (String)" ") + ')';
        }
    }

    static class Never
    extends Exp {
        Never() {
        }

        @Override
        boolean matches(Set<String> roles) {
            return false;
        }

        public String toString() {
            return "(NEVER)";
        }
    }

    static abstract class Exp {
        Exp() {
        }

        abstract boolean matches(Set<String> var1);

        void appendTokens(Set<String> set) {
        }
    }
}

