/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.reflect;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.Mutater;

public class Mutaters {
    private static final ConcurrentHashMap<Class<?>, Map<Class<?>, Mutater<?, ?>>> CACHE = new ConcurrentHashMap();
    public static final Mutater<Object, Object> NULL = new Mutater<Object, Object>(){

        @Override
        public Object mutate(Object outer, Object in) {
            return null;
        }
    };

    public static synchronized void add(Class<?> ic, Class<?> oc, Mutater<?, ?> t) {
        Map<Class<?>, Mutater<?, ?>> m = CACHE.get(oc);
        if (m == null) {
            m = new ConcurrentHashMap();
            CACHE.put(oc, m);
        }
        m.put(ic, t);
    }

    public static <I, O> Mutater<I, O> get(Class<I> ic, Class<O> oc) {
        Mutater t;
        if (ic == null || oc == null) {
            return null;
        }
        Map<Class<?>, Mutater<?, ?>> m = CACHE.get(oc);
        if (m == null) {
            m = new ConcurrentHashMap();
            CACHE.putIfAbsent(oc, m);
            m = CACHE.get(oc);
        }
        if ((t = m.get(ic)) == null) {
            t = Mutaters.find(ic, oc, m);
            m.put(ic, t);
        }
        return t == NULL ? null : t;
    }

    public static <I, O> boolean hasMutate(Class<I> ic, Class<O> oc) {
        return Mutaters.get(ic, oc) != NULL;
    }

    private static Mutater find(Class<?> ic, Class<?> oc, Map<Class<?>, Mutater<?, ?>> m) {
        ConstructorInfo c;
        if (ic == oc) {
            return new Mutater(){

                public Object mutate(Object outer, Object in) {
                    return in;
                }
            };
        }
        ClassInfo ici = ClassInfo.of(ic);
        ClassInfo oci = ClassInfo.of(oc);
        ClassInfo pic = ici.getAnyParent(x -> m.get(x.inner()) != null);
        if (pic != null) {
            return m.get(pic.inner());
        }
        if (ic == String.class) {
            final Class<?> oc2 = oci.hasPrimitiveWrapper() ? oci.getPrimitiveWrapper() : oc;
            ClassInfo oc2i = ClassInfo.of(oc2);
            final MethodInfo createMethod = oc2i.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasReturnType(oc2) && x.hasParamTypes(ic) && (x.hasName("forName") || Mutaters.isStaticCreateMethodName(x, ic)));
            if (oc2.isEnum() && createMethod == null) {
                return new Mutater<String, Object>(){

                    @Override
                    public Object mutate(Object outer, String in) {
                        return Enum.valueOf(oc2, in);
                    }
                };
            }
            if (createMethod != null) {
                return new Mutater<String, Object>(){

                    @Override
                    public Object mutate(Object outer, String in) {
                        try {
                            return createMethod.invoke(null, in);
                        }
                        catch (Exception e) {
                            throw ThrowableUtils.asRuntimeException(e);
                        }
                    }
                };
            }
        } else {
            MethodInfo createMethod = oci.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasReturnType(oc) && x.hasParamTypes(ic) && Mutaters.isStaticCreateMethodName(x, ic));
            if (createMethod != null) {
                final Method cm = createMethod.inner();
                return new Mutater(){

                    public Object mutate(Object context, Object in) {
                        try {
                            return cm.invoke(null, in);
                        }
                        catch (Exception e) {
                            throw ThrowableUtils.asRuntimeException(e);
                        }
                    }
                };
            }
        }
        if ((c = oci.getPublicConstructor(x -> x.hasParamTypes(ic))) != null && c.isNotDeprecated()) {
            final boolean isMemberClass = oci.isNonStaticMemberClass();
            return new Mutater(){

                public Object mutate(Object outer, Object in) {
                    try {
                        if (isMemberClass) {
                            return c.invoke(outer, in);
                        }
                        return c.invoke(in);
                    }
                    catch (Exception e) {
                        throw ThrowableUtils.asRuntimeException(e);
                    }
                }
            };
        }
        final MethodInfo toXMethod = Mutaters.findToXMethod(ici, oci);
        if (toXMethod != null) {
            return new Mutater(){

                public Object mutate(Object outer, Object in) {
                    try {
                        return toXMethod.invoke(in, new Object[0]);
                    }
                    catch (Exception e) {
                        throw ThrowableUtils.asRuntimeException(e);
                    }
                }
            };
        }
        return NULL;
    }

    private static boolean isStaticCreateMethodName(MethodInfo mi, Class<?> ic) {
        String n = mi.getSimpleName();
        String cn = ic.getSimpleName();
        return StringUtils.isOneOf(n, "create", "from", "fromValue", "parse", "valueOf") || n.startsWith("from") && n.substring(4).equals(cn) || n.startsWith("for") && n.substring(3).equals(cn) || n.startsWith("parse") && n.substring(5).equals(cn);
    }

    public static <T> T fromString(Class<T> c, String s) {
        Mutater<String, T> t = Mutaters.get(String.class, c);
        return t == null ? null : (T)t.mutate(s);
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        Mutater<?, String> t = Mutaters.get(o.getClass(), String.class);
        return t == null ? o.toString() : t.mutate(o);
    }

    private static MethodInfo findToXMethod(ClassInfo ic, ClassInfo oc) {
        String tn = oc.getReadableName();
        return ic.getPublicMethod(x -> x.isNotStatic() && x.hasNoParams() && x.getSimpleName().startsWith("to") && x.getSimpleName().substring(2).equalsIgnoreCase(tn));
    }

    static {
        Mutaters.add(String.class, TimeZone.class, new Mutater<String, TimeZone>(){

            @Override
            public TimeZone mutate(Object outer, String in) {
                return TimeZone.getTimeZone(in);
            }
        });
        Mutaters.add(TimeZone.class, String.class, new Mutater<TimeZone, String>(){

            @Override
            public String mutate(Object outer, TimeZone in) {
                return in.getID();
            }
        });
        Mutaters.add(String.class, Locale.class, new Mutater<String, Locale>(){

            @Override
            public Locale mutate(Object outer, String in) {
                return Locale.forLanguageTag(in.replace('_', '-'));
            }
        });
        Mutaters.add(String.class, Boolean.class, new Mutater<String, Boolean>(){

            @Override
            public Boolean mutate(Object outer, String in) {
                if (in == null || "null".equals(in) || in.isEmpty()) {
                    return null;
                }
                return Boolean.valueOf(in);
            }
        });
    }
}

