/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanContextable;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.swap.BeanInterceptor;

public class Parser
extends BeanContextable {
    protected final boolean autoCloseStreams;
    protected final boolean strict;
    protected final boolean trimStrings;
    protected final boolean unbuffered;
    protected final int debugOutputLines;
    protected final Class<? extends ParserListener> listener;
    protected final String consumes;
    private final List<MediaType> consumesArray;

    public static Builder create() {
        return new Builder();
    }

    public static Builder createParserBuilder(Class<? extends Parser> c) {
        return (Builder)Context.createBuilder(c);
    }

    protected Parser(Builder builder) {
        super(builder);
        this.autoCloseStreams = builder.autoCloseStreams;
        this.consumes = builder.consumes;
        this.debugOutputLines = builder.debugOutputLines;
        this.listener = builder.listener;
        this.strict = builder.strict;
        this.trimStrings = builder.trimStrings;
        this.unbuffered = builder.unbuffered;
        String[] _consumes = StringUtils.splita((String)(Utils.nn((Object)this.consumes) ? this.consumes : ""));
        ArrayList<MediaType> _consumesList = new ArrayList<MediaType>();
        for (String consume : _consumes) {
            _consumesList.add(MediaType.of(consume));
        }
        this.consumesArray = CollectionUtils.u(_consumesList);
    }

    public boolean canHandle(String contentType) {
        if (Utils.nn((Object)contentType)) {
            for (MediaType mt : this.getMediaTypes()) {
                if (!contentType.equals(mt.toString())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public ParserSession.Builder createSession() {
        return ParserSession.create(this);
    }

    public <T> T doParse(ParserSession session, ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException {
        throw ThrowableUtils.unsupportedOp();
    }

    public final List<MediaType> getMediaTypes() {
        return this.consumesArray;
    }

    public final MediaType getPrimaryMediaType() {
        return this.consumesArray.isEmpty() ? null : this.consumesArray.get(0);
    }

    @Override
    public ParserSession getSession() {
        return this.createSession().build();
    }

    public boolean isReaderParser() {
        return true;
    }

    public final <T> T parse(Object input, Class<T> type) throws ParseException, IOException {
        return this.getSession().parse(input, type);
    }

    public final <T> T parse(Object input, ClassMeta<T> type) throws ParseException, IOException {
        return this.getSession().parse(input, type);
    }

    public final <T> T parse(Object input, Type type, Type ... args) throws ParseException, IOException {
        return this.getSession().parse(input, type, args);
    }

    public final <T> T parse(String input, Class<T> type) throws ParseException {
        return this.getSession().parse(input, type);
    }

    public final <T> T parse(String input, ClassMeta<T> type) throws ParseException {
        return this.getSession().parse(input, type);
    }

    public final <T> T parse(String input, Type type, Type ... args) throws ParseException {
        return this.getSession().parse(input, type, args);
    }

    public final Object[] parseArgs(Object input, Type[] argTypes) throws ParseException {
        if (argTypes == null || argTypes.length == 0) {
            return new Object[0];
        }
        return this.getSession().parseArgs(input, argTypes);
    }

    public final <E> Collection<E> parseIntoCollection(Object input, Collection<E> c, Type elementType) throws ParseException {
        return this.getSession().parseIntoCollection(input, c, elementType);
    }

    public final <K, V> Map<K, V> parseIntoMap(Object input, Map<K, V> m, Type keyType, Type valueType) throws ParseException {
        return this.getSession().parseIntoMap(input, m, keyType, valueType);
    }

    protected final int getDebugOutputLines() {
        return this.debugOutputLines;
    }

    protected final Class<? extends ParserListener> getListener() {
        return this.listener;
    }

    protected final boolean isAutoCloseStreams() {
        return this.autoCloseStreams;
    }

    protected final boolean isStrict() {
        return this.strict;
    }

    protected final boolean isTrimStrings() {
        return this.trimStrings;
    }

    protected final boolean isUnbuffered() {
        return this.unbuffered;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"autoCloseStreams", (Object)this.autoCloseStreams).a((Object)"debugOutputLines", (Object)this.debugOutputLines).a((Object)"listener", this.listener).a((Object)"strict", (Object)this.strict).a((Object)"trimStrings", (Object)this.trimStrings).a((Object)"unbuffered", (Object)this.unbuffered);
    }

    public static class Builder
    extends BeanContextable.Builder {
        private boolean autoCloseStreams;
        private boolean strict;
        private boolean trimStrings;
        private boolean unbuffered;
        private Class<? extends ParserListener> listener;
        private int debugOutputLines;
        private String consumes;

        protected Builder() {
            this.autoCloseStreams = (Boolean)Utils.env((String)"Parser.autoCloseStreams", (Object)false);
            this.strict = (Boolean)Utils.env((String)"Parser.strict", (Object)false);
            this.trimStrings = (Boolean)Utils.env((String)"Parser.trimStrings", (Object)false);
            this.unbuffered = (Boolean)Utils.env((String)"Parser.unbuffered", (Object)false);
            this.debugOutputLines = (Integer)Utils.env((String)"Parser.debugOutputLines", (Object)5);
            this.listener = null;
            this.consumes = null;
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.autoCloseStreams = copyFrom.autoCloseStreams;
            this.strict = copyFrom.strict;
            this.trimStrings = copyFrom.trimStrings;
            this.unbuffered = copyFrom.unbuffered;
            this.debugOutputLines = copyFrom.debugOutputLines;
            this.listener = copyFrom.listener;
            this.consumes = copyFrom.consumes;
        }

        protected Builder(Parser copyFrom) {
            super(copyFrom);
            this.autoCloseStreams = copyFrom.autoCloseStreams;
            this.strict = copyFrom.strict;
            this.trimStrings = copyFrom.trimStrings;
            this.unbuffered = copyFrom.unbuffered;
            this.debugOutputLines = copyFrom.debugOutputLines;
            this.listener = copyFrom.listener;
            this.consumes = copyFrom.consumes;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations((Class[])from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        public Builder autoCloseStreams() {
            return this.autoCloseStreams(true);
        }

        public Builder autoCloseStreams(boolean value) {
            this.autoCloseStreams = value;
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary(values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor(on, value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties(beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties(values);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes(beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes(values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly(beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly(values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly(beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly(values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Parser build() {
            return this.build(Parser.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        public Builder consumes(String value) {
            this.consumes = value;
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder debugOutputLines(int value) {
            this.debugOutputLines = value;
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn(on, values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example(pojoClass, json);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example(pojoClass, o);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters(on);
            return this;
        }

        public String getConsumes() {
            return this.consumes;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{super.hashKey(), this.autoCloseStreams, this.strict, this.trimStrings, this.unbuffered, this.debugOutputLines, this.listener, this.consumes});
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass(interfaceClass, implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses(values);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass(on, value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces(value);
            return this;
        }

        public Builder listener(Class<? extends ParserListener> value) {
            this.listener = value;
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses(values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer(on, value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer(value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties(on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass(on, value);
            return this;
        }

        public Builder strict() {
            return this.strict(true);
        }

        public Builder strict(boolean value) {
            this.strict = value;
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap(normalClass, swappedClass, swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap(normalClass, swappedClass, swapFunction, unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder swaps(Object ... values) {
            super.swaps(values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        public Builder trimStrings() {
            return this.trimStrings(true);
        }

        public Builder trimStrings(boolean value) {
            this.trimStrings = value;
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName(on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName(on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        public Builder unbuffered() {
            return this.unbuffered(true);
        }

        public Builder unbuffered(boolean value) {
            this.unbuffered = value;
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }
    }

    public static abstract class Null
    extends Parser {
        private Null(Builder builder) {
            super(builder);
        }
    }
}

