/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.serialization.Deserializer;

public class FetchConfig<K, V> {
    final int minBytes;
    final int maxBytes;
    final int maxWaitMs;
    final int fetchSize;
    final int maxPollRecords;
    final boolean checkCrcs;
    final String clientRackId;
    final Deserializer<K> keyDeserializer;
    final Deserializer<V> valueDeserializer;
    final IsolationLevel isolationLevel;

    public FetchConfig(int minBytes, int maxBytes, int maxWaitMs, int fetchSize, int maxPollRecords, boolean checkCrcs, String clientRackId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, IsolationLevel isolationLevel) {
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
        this.maxWaitMs = maxWaitMs;
        this.fetchSize = fetchSize;
        this.maxPollRecords = maxPollRecords;
        this.checkCrcs = checkCrcs;
        this.clientRackId = clientRackId;
        this.keyDeserializer = Objects.requireNonNull(keyDeserializer, "Message key deserializer provided to FetchConfig should not be null");
        this.valueDeserializer = Objects.requireNonNull(valueDeserializer, "Message value deserializer provided to FetchConfig should not be null");
        this.isolationLevel = isolationLevel;
    }

    public FetchConfig(ConsumerConfig config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, IsolationLevel isolationLevel) {
        this.minBytes = config.getInt("fetch.min.bytes");
        this.maxBytes = config.getInt("fetch.max.bytes");
        this.maxWaitMs = config.getInt("fetch.max.wait.ms");
        this.fetchSize = config.getInt("max.partition.fetch.bytes");
        this.maxPollRecords = config.getInt("max.poll.records");
        this.checkCrcs = config.getBoolean("check.crcs");
        this.clientRackId = config.getString("client.rack");
        this.keyDeserializer = Objects.requireNonNull(keyDeserializer, "Message key deserializer provided to FetchConfig should not be null");
        this.valueDeserializer = Objects.requireNonNull(valueDeserializer, "Message value deserializer provided to FetchConfig should not be null");
        this.isolationLevel = isolationLevel;
    }

    public String toString() {
        return "FetchConfig{minBytes=" + this.minBytes + ", maxBytes=" + this.maxBytes + ", maxWaitMs=" + this.maxWaitMs + ", fetchSize=" + this.fetchSize + ", maxPollRecords=" + this.maxPollRecords + ", checkCrcs=" + this.checkCrcs + ", clientRackId='" + this.clientRackId + '\'' + ", keyDeserializer=" + this.keyDeserializer + ", valueDeserializer=" + this.valueDeserializer + ", isolationLevel=" + (Object)((Object)this.isolationLevel) + '}';
    }
}

