/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.api;

import org.apache.kyuubi.shade.io.etcd.jetcd.api.CompactionRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.CompactionResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.DeleteRangeRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.DeleteRangeResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.KVGrpc;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.PutRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.PutResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.RangeRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.RangeResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.TxnRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.TxnResponse;
import org.apache.kyuubi.shade.io.grpc.BindableService;
import org.apache.kyuubi.shade.io.grpc.CallOptions;
import org.apache.kyuubi.shade.io.grpc.Channel;
import org.apache.kyuubi.shade.io.grpc.ServerServiceDefinition;
import org.apache.kyuubi.shade.io.grpc.Status;
import org.apache.kyuubi.shade.io.grpc.StatusRuntimeException;
import org.apache.kyuubi.shade.io.grpc.stub.AbstractStub;
import org.apache.kyuubi.shade.io.grpc.stub.ServerCalls;
import org.apache.kyuubi.shade.io.grpc.stub.StreamObserver;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Vertx;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.grpc.stub.ClientCalls;
import org.apache.kyuubi.shade.io.vertx.grpc.stub.ServerCalls;

public final class VertxKVGrpc {
    private static final int METHODID_RANGE = 0;
    private static final int METHODID_PUT = 1;
    private static final int METHODID_DELETE_RANGE = 2;
    private static final int METHODID_TXN = 3;
    private static final int METHODID_COMPACT = 4;

    private VertxKVGrpc() {
    }

    public static KVVertxStub newVertxStub(Channel channel) {
        return new KVVertxStub(channel);
    }

    public static final class KVVertxStub
    extends AbstractStub<KVVertxStub> {
        private final ContextInternal ctx;
        private KVGrpc.KVStub delegateStub;

        private KVVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = KVGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private KVVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = KVGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        @Override
        protected KVVertxStub build(Channel channel, CallOptions callOptions) {
            return new KVVertxStub(channel, callOptions);
        }

        public Future<RangeResponse> range(RangeRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::range);
        }

        public Future<PutResponse> put(PutRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::put);
        }

        public Future<DeleteRangeResponse> deleteRange(DeleteRangeRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::deleteRange);
        }

        public Future<TxnResponse> txn(TxnRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::txn);
        }

        public Future<CompactionResponse> compact(CompactionRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::compact);
        }
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final KVVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(KVVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    ServerCalls.oneToOne((RangeRequest)request, responseObserver, this.compression, this.serviceImpl::range);
                    break;
                }
                case 1: {
                    ServerCalls.oneToOne((PutRequest)request, responseObserver, this.compression, this.serviceImpl::put);
                    break;
                }
                case 2: {
                    ServerCalls.oneToOne((DeleteRangeRequest)request, responseObserver, this.compression, this.serviceImpl::deleteRange);
                    break;
                }
                case 3: {
                    ServerCalls.oneToOne((TxnRequest)request, responseObserver, this.compression, this.serviceImpl::txn);
                    break;
                }
                case 4: {
                    ServerCalls.oneToOne((CompactionRequest)request, responseObserver, this.compression, this.serviceImpl::compact);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class KVVertxImplBase
    implements BindableService {
        private String compression;

        public KVVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<RangeResponse> range(RangeRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<PutResponse> put(PutRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<DeleteRangeResponse> deleteRange(DeleteRangeRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<TxnResponse> txn(TxnRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Future<CompactionResponse> compact(CompactionRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(KVGrpc.getServiceDescriptor()).addMethod(KVGrpc.getRangeMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(KVGrpc.getPutMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1, this.compression))).addMethod(KVGrpc.getDeleteRangeMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2, this.compression))).addMethod(KVGrpc.getTxnMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3, this.compression))).addMethod(KVGrpc.getCompactMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 4, this.compression))).build();
        }
    }
}

