/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import javax.security.auth.Subject;
import org.apache.kyuubi.jdbc.hive.auth.KerberosUtils;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class HttpAuthUtils {
    public static final String AUTHORIZATION = "Authorization";
    public static final String NEGOTIATE = "Negotiate";
    public static final String BEARER = "Bearer";

    public static String getKerberosServiceTicket(String serverPrinciple, String host, Subject loggedInSubject) throws Exception {
        String spn = KerberosUtils.canonicalPrincipal(serverPrinciple, host);
        return Subject.doAs(loggedInSubject, new HttpKerberosClientAction(spn));
    }

    private HttpAuthUtils() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static class HttpKerberosClientAction
    implements PrivilegedExceptionAction<String> {
        private final String serverPrincipal;

        public HttpKerberosClientAction(String serverPrincipal) {
            this.serverPrincipal = serverPrincipal;
        }

        @Override
        public String run() throws Exception {
            Oid mechOid = new Oid("1.2.840.113554.1.2.2");
            Oid krb5PrincipalOid = new Oid("1.2.840.113554.1.2.2.1");
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName(this.serverPrincipal, krb5PrincipalOid);
            GSSContext gssContext = manager.createContext(serverName, mechOid, null, 0);
            gssContext.requestMutualAuth(false);
            byte[] inToken = new byte[]{};
            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
            gssContext.dispose();
            return Base64.getEncoder().encodeToString(outToken);
        }
    }
}

