/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.metadata.jdbc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.server.metadata.MetadataStore;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.jdbc.DatabaseType$;
import org.apache.kyuubi.server.metadata.jdbc.GenericDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStore$;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStoreConf$;
import org.apache.kyuubi.server.metadata.jdbc.MySQLDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.PostgreSQLDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.SQLiteDatabaseDialect;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.util.JdbcUtils$;
import org.apache.kyuubi.util.reflect.ReflectUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\r5d\u0001\u0002\u001e<\u0001!C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006A\u0002!\t!\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0011\u0019\t\b\u0001)A\u0005O\"9!\u000f\u0001b\u0001\n\u0013\u0019\bbBA\u0004\u0001\u0001\u0006I\u0001\u001e\u0005\u000b\u0003\u0013\u0001\u0001R1A\u0005\n\u0005-\u0001\"CA\t\u0001\t\u0007I\u0011BA\n\u0011\u001d\t)\u0002\u0001Q\u0001\naD\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037A\u0011\"a\t\u0001\u0005\u0004%I!!\n\t\u0011\u00055\u0002\u0001)A\u0005\u0003OA\u0011\"a\f\u0001\u0005\u0004%I!!\r\t\u0011\u0005}\u0002\u0001)A\u0005\u0003gA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u000bB!\"a\u0017\u0001\u0005\u0004%\u0019!QA/\u0011!\t)\u0007\u0001Q\u0001\n\u0005}\u0003\"CA?\u0001\t\u0007I\u0011BA@\u0011!\t)\n\u0001Q\u0001\n\u0005\u0005\u0005\"CAL\u0001\t\u0007I\u0011BA\n\u0011\u001d\tI\n\u0001Q\u0001\naDq!a'\u0001\t\u0013\ti\n\u0003\u0005\u0002&\u0002!\taOAT\u0011\u001d\ti\r\u0001C\u0001\u0003\u001fDq!!9\u0001\t\u0003\t\u0019\u000fC\u0004\u0002|\u0002!\t%!(\t\u000f\u0005u\b\u0001\"\u0011\u0002\u0000\"9!q\u0002\u0001\u0005B\tE\u0001b\u0002B\r\u0001\u0011\u0005#1\u0004\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0011\u001d\u0011y\u0003\u0001C!\u0005cA\u0011Ba\u0014\u0001#\u0003%\tA!\u0015\t\u0013\t\u001d\u0004!%A\u0005\u0002\t%\u0004b\u0002B7\u0001\u0011\u0005#q\u000e\u0005\b\u0005g\u0002A\u0011\u0002B;\u0011\u001d\u0011\u0019\n\u0001C!\u0005+CqA!'\u0001\t\u0003\u0012Y\nC\u0004\u0003 \u0002!\tE!)\t\u000f\t5\u0006\u0001\"\u0003\u00030\"9!\u0011\u0019\u0001\u0005\n\t\r\u0007b\u0002Bm\u0001\u0011%!1\u001c\u0005\b\u0007\u0003\u0001A\u0011BB\u0002\u0011\u001d\u00199\u0002\u0001C\u0005\u00073Aqaa\n\u0001\t\u0013\u0019I\u0003C\u0004\u00040\u0001!Ia!\r\t\u000f\ru\u0002\u0001\"\u0003\u0004@\u001d911I\u001e\t\u0002\r\u0015cA\u0002\u001e<\u0011\u0003\u00199\u0005\u0003\u0004ae\u0011\u00051q\n\u0005\n\u0007#\u0012$\u0019!C\u0005\u0007'B\u0001ba\u00193A\u0003%1Q\u000b\u0005\n\u0007K\u0012$\u0019!C\u0005\u0003\u0017A\u0001ba\u001a3A\u0003%\u0011Q\u0002\u0005\n\u0007S\u0012$\u0019!C\u0005\u0003'Aqaa\u001b3A\u0003%\u0001PA\tK\t\n\u001bU*\u001a;bI\u0006$\u0018m\u0015;pe\u0016T!\u0001P\u001f\u0002\t)$'m\u0019\u0006\u0003}}\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u0001\u0006\u000baa]3sm\u0016\u0014(B\u0001\"D\u0003\u0019Y\u00170^;cS*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A%R+B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0005Y\u0006twMC\u0001O\u0003\u0011Q\u0017M^1\n\u0005A[%AB(cU\u0016\u001cG\u000f\u0005\u0002S'6\tQ(\u0003\u0002U{\tiQ*\u001a;bI\u0006$\u0018m\u0015;pe\u0016\u0004\"AV,\u000e\u0003\u0005K!\u0001W!\u0003\u000f1{wmZ5oO\u0006!1m\u001c8g!\tYf,D\u0001]\u0015\ti\u0016)\u0001\u0004d_:4\u0017nZ\u0005\u0003?r\u0013!bS=vk\nL7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011!\r\u001a\t\u0003G\u0002i\u0011a\u000f\u0005\u00063\n\u0001\rAW\u0001\u0007I\n$\u0016\u0010]3\u0016\u0003\u001d\u0004\"\u0001[6\u000f\u0005\rL\u0017B\u00016<\u00031!\u0015\r^1cCN,G+\u001f9f\u0013\taWNA\u0003WC2,X-\u0003\u0002o_\nYQI\\;nKJ\fG/[8o\u0015\u0005\u0001\u0018!B:dC2\f\u0017a\u00023c)f\u0004X\rI\u0001\u000fIJLg/\u001a:DY\u0006\u001c8o\u00149u+\u0005!\bcA;wq6\tq.\u0003\u0002x_\n1q\n\u001d;j_:\u00042!_A\u0001\u001d\tQh\u0010\u0005\u0002|_6\tAP\u0003\u0002~\u000f\u00061AH]8pizJ!a`8\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\tyx.A\bee&4XM]\"mCN\u001cx\n\u001d;!\u0003Ai\u0017p]9m\tJLg/\u001a:DY\u0006\u001c8/\u0006\u0002\u0002\u000eA\u0019!*a\u0004\n\u0007\u0005\r1*A\u0006ee&4XM]\"mCN\u001cX#\u0001=\u0002\u0019\u0011\u0014\u0018N^3s\u00072\f7o\u001d\u0011\u0002\u000f\u0011L\u0017\r\\3diV\u0011\u00111\u0004\t\u0004G\u0006u\u0011bAA\u0010w\t1r)\u001a8fe&\u001cG)\u0019;bE\u0006\u001cX\rR5bY\u0016\u001cG/\u0001\u0005eS\u0006dWm\u0019;!\u0003=\u0001(/[8sSRLXI\\1cY\u0016$WCAA\u0014!\r)\u0018\u0011F\u0005\u0004\u0003Wy'a\u0002\"p_2,\u0017M\\\u0001\u0011aJLwN]5us\u0016s\u0017M\u00197fI\u0002\nA\u0003Z1uCN|WO]2f!J|\u0007/\u001a:uS\u0016\u001cXCAA\u001a!\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d\u001b\u0006!Q\u000f^5m\u0013\u0011\ti$a\u000e\u0003\u0015A\u0013x\u000e]3si&,7/A\u000beCR\f7o\\;sG\u0016\u0004&o\u001c9feRLWm\u001d\u0011\u0002\u0019!L7.\u0019:j\u0007>tg-[4\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003+j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0007Q&\\\u0017M]5\u000b\t\u0005=\u0013\u0011K\u0001\u0007u\u0006D\b0\u001a:\u000b\u0005\u0005M\u0013aA2p[&!\u0011qKA%\u00051A\u0015n[1sS\u000e{gNZ5h\u00035A\u0017n[1sS\u000e{gNZ5hA\u0005\u0001\u0002.[6be&$\u0015\r^1T_V\u00148-Z\u000b\u0003\u0003?\u0002B!a\u0012\u0002b%!\u00111MA%\u0005AA\u0015n[1sS\u0012\u000bG/Y*pkJ\u001cW-A\tiS.\f'/\u001b#bi\u0006\u001cv.\u001e:dK\u0002B3aEA5!\u0011\tY'!\u001f\u000e\u0005\u00055$\u0002BA8\u0003c\n1\"\u00198o_R\fG/[8og*!\u00111OA;\u0003\u0019\u0019w.\\7p]*!\u0011qOA)\u0003\u00199wn\\4mK&!\u00111PA7\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgnZ\u0001\u0007[\u0006\u0004\b/\u001a:\u0016\u0005\u0005\u0005\u0005\u0003BAB\u0003#k!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\tI\u0006$\u0018MY5oI*!\u00111RAG\u0003\u001dQ\u0017mY6t_:TA!a$\u0002R\u0005Ia-Y:uKJDX\u000e\\\u0005\u0005\u0003'\u000b)I\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0002\u001dQ,'/\\5oC2\u001cF/\u0019;fg\u0006yA/\u001a:nS:\fGn\u0015;bi\u0016\u001c\b%\u0001\u0006j]&$8k\u00195f[\u0006$\"!a(\u0011\u0007U\f\t+C\u0002\u0002$>\u0014A!\u00168ji\u0006iq-\u001a;J]&$8k\u00195f[\u0006$2\u0001^AU\u0011\u0019)\u0017\u00041\u0001\u0002,B!\u0011QVAd\u001d\r\ty+\u001b\b\u0005\u0003c\u000b)M\u0004\u0003\u00024\u0006\rg\u0002BA[\u0003\u0003tA!a.\u0002@:!\u0011\u0011XA_\u001d\rY\u00181X\u0005\u0002\r&\u0011A)R\u0005\u0003\u0005\u000eK!\u0001Q!\n\u0005yz\u0014B\u0001\u001f>\u0013\u0011\tI-a3\u0003\u0019\u0011\u000bG/\u00192bg\u0016$\u0016\u0010]3\u000b\u0005)\\\u0014\u0001E4fiN\u001b\u0007.Z7b-\u0016\u00148/[8o)\u0011\t\t.!8\u0011\u0013U\f\u0019.a6\u0002X\u0006]\u0017bAAk_\n1A+\u001e9mKN\u00022!^Am\u0013\r\tYn\u001c\u0002\u0004\u0013:$\bBBAp5\u0001\u0007\u00010A\u0005tG\",W.Y+sY\u0006\u0011r-\u001a;MCR,7\u000f^*dQ\u0016l\u0017-\u0016:m)\r!\u0018Q\u001d\u0005\b\u0003O\\\u0002\u0019AAu\u0003)\u00198\r[3nCV\u0013Hn\u001d\t\u0006\u0003W\f)\u0010\u001f\b\u0005\u0003[\f\tPD\u0002|\u0003_L\u0011\u0001]\u0005\u0004\u0003g|\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003o\fIPA\u0002TKFT1!a=p\u0003\u0015\u0019Gn\\:f\u00039Ign]3si6+G/\u00193bi\u0006$B!a(\u0003\u0002!1a(\ba\u0001\u0005\u0007\u0001BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0004\u0005\u0013i\u0014aA1qS&!!Q\u0002B\u0004\u0005!iU\r^1eCR\f\u0017\u0001\u00049jG.lU\r^1eCR\fG\u0003\u0002B\n\u0005+\u0001B!\u001e<\u0003\u0004!1!q\u0003\u0010A\u0002a\fab[=vk\nL\u0017J\\:uC:\u001cW-\u0001\fue\u0006t7OZ8s[6+G/\u00193bi\u0006\u001cF/\u0019;f)!\t9C!\b\u0003\"\t\u0015\u0002B\u0002B\u0010?\u0001\u0007\u00010\u0001\u0006jI\u0016tG/\u001b4jKJDaAa\t \u0001\u0004A\u0018!\u00034s_6\u001cF/\u0019;f\u0011\u0019\u00119c\ba\u0001q\u0006YA/\u0019:hKR\u001cF/\u0019;f\u0003-9W\r^'fi\u0006$\u0017\r^1\u0015\t\t\r!Q\u0006\u0005\u0007\u0005?\u0001\u0003\u0019\u0001=\u0002\u001f\u001d,G/T3uC\u0012\fG/\u0019'jgR$BBa\r\u00036\t}\"1\tB$\u0005\u0017\u0002b!a;\u0002v\n\r\u0001b\u0002B\u001cC\u0001\u0007!\u0011H\u0001\u0007M&dG/\u001a:\u0011\t\t\u0015!1H\u0005\u0005\u0005{\u00119A\u0001\bNKR\fG-\u0019;b\r&dG/\u001a:\t\u000f\t\u0005\u0013\u00051\u0001\u0002X\u0006!aM]8n\u0011\u001d\u0011)%\ta\u0001\u0003/\fAa]5{K\"A!\u0011J\u0011\u0011\u0002\u0003\u0007A/A\u0004pe\u0012,'OQ=\t\u0011\t5\u0013\u0005%AA\u0002a\f\u0011\u0002Z5sK\u000e$\u0018n\u001c8\u00023\u001d,G/T3uC\u0012\fG/\u0019'jgR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005'R3\u0001\u001eB+W\t\u00119\u0006\u0005\u0003\u0003Z\t\rTB\u0001B.\u0015\u0011\u0011iFa\u0018\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B1_\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015$1\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!G4fi6+G/\u00193bi\u0006d\u0015n\u001d;%I\u00164\u0017-\u001e7uIU*\"Aa\u001b+\u0007a\u0014)&A\u0007d_VtG/T3uC\u0012\fG/\u0019\u000b\u0005\u0003/\u0014\t\bC\u0004\u00038\u0011\u0002\rA!\u000f\u0002'\u0005\u001c8/Z7cY\u0016<\u0006.\u001a:f\u00072\fWo]3\u0015\u000ba\u00149H!\u001f\t\u000f\t]R\u00051\u0001\u0003:!9!1P\u0013A\u0002\tu\u0014A\u00029be\u0006l7\u000f\u0005\u0004\u0003\u0000\t%%QR\u0007\u0003\u0005\u0003SAAa!\u0003\u0006\u00069Q.\u001e;bE2,'b\u0001BD_\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t-%\u0011\u0011\u0002\u000b\u0019&\u001cHOQ;gM\u0016\u0014\bcA;\u0003\u0010&\u0019!\u0011S8\u0003\u0007\u0005s\u00170\u0001\bva\u0012\fG/Z'fi\u0006$\u0017\r^1\u0015\t\u0005}%q\u0013\u0005\u0007}\u0019\u0002\rAa\u0001\u00027\rdW-\u00198va6+G/\u00193bi\u0006\u0014\u00150\u00133f]RLg-[3s)\u0011\tyJ!(\t\r\t}q\u00051\u0001y\u0003Q\u0019G.Z1okBlU\r^1eCR\f')_!hKR!\u0011q\u0014BR\u0011\u001d\u0011)\u000b\u000ba\u0001\u0005O\u000ba!\\1y\u0003\u001e,\u0007cA;\u0003*&\u0019!1V8\u0003\t1{gnZ\u0001\u000eEVLG\u000eZ'fi\u0006$\u0017\r^1\u0015\t\tM\"\u0011\u0017\u0005\b\u0005gK\u0003\u0019\u0001B[\u0003%\u0011Xm];miN+G\u000f\u0005\u0003\u00038\nuVB\u0001B]\u0015\r\u0011Y,T\u0001\u0004gFd\u0017\u0002\u0002B`\u0005s\u0013\u0011BU3tk2$8+\u001a;\u0002\u000f\u0015DXmY;uKRA\u0011q\u0014Bc\u0005\u001f\u0014\t\u000eC\u0004\u0003H*\u0002\rA!3\u0002\t\r|gN\u001c\t\u0005\u0005o\u0013Y-\u0003\u0003\u0003N\ne&AC\"p]:,7\r^5p]\"1!1\u0018\u0016A\u0002aDqAa\u001f+\u0001\u0004\u0011\u0019\u000eE\u0003v\u0005+\u0014i)C\u0002\u0003X>\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?\u000359\u0018\u000e\u001e5SKN,H\u000e^*fiV!!Q\u001cBs)!\u0011yNa?\u0003~\n}H\u0003\u0002Bq\u0005c\u0004BAa9\u0003f2\u0001Aa\u0002BtW\t\u0007!\u0011\u001e\u0002\u0002)F!!1\u001eBG!\r)(Q^\u0005\u0004\u0005_|'a\u0002(pi\"Lgn\u001a\u0005\b\u0005g\\\u0003\u0019\u0001B{\u0003\u00051\u0007cB;\u0003x\nU&\u0011]\u0005\u0004\u0005s|'!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\u00119m\u000ba\u0001\u0005\u0013DaAa/,\u0001\u0004A\bb\u0002B>W\u0001\u0007!1[\u0001\u0010o&$\b.\u00169eCR,7i\\;oiV!1QAB\u0006)!\u00199a!\u0005\u0004\u0014\rUA\u0003BB\u0005\u0007\u001b\u0001BAa9\u0004\f\u00119!q\u001d\u0017C\u0002\t%\bb\u0002BzY\u0001\u00071q\u0002\t\bk\n]\u0018q[B\u0005\u0011\u001d\u00119\r\fa\u0001\u0005\u0013DaAa/-\u0001\u0004A\bb\u0002B>Y\u0001\u0007!1[\u0001\u0013g\u0016$8\u000b^1uK6,g\u000e\u001e)be\u0006l7\u000f\u0006\u0004\u0002 \u000em1Q\u0005\u0005\b\u0007;i\u0003\u0019AB\u0010\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0005\u0003\u00038\u000e\u0005\u0012\u0002BB\u0012\u0005s\u0013\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u0011\u001d\u0011Y(\fa\u0001\u0005'\fQB^1mk\u0016\f5o\u0015;sS:<Gc\u0001=\u0004,!91Q\u0006\u0018A\u0002\t5\u0015aA8cU\u0006Q1\u000f\u001e:j]\u001e\u0014T*\u00199\u0015\t\rM2\u0011\b\t\u0006s\u000eU\u0002\u0010_\u0005\u0005\u0007o\t)AA\u0002NCBDaaa\u000f0\u0001\u0004A\u0018aA:ue\u0006Q1\u000f\u001e:j]\u001e\u00144+Z9\u0015\t\u0005%8\u0011\t\u0005\u0007\u0007w\u0001\u0004\u0019\u0001=\u0002#)#%iQ'fi\u0006$\u0017\r^1Ti>\u0014X\r\u0005\u0002deM\u0019!g!\u0013\u0011\u0007U\u001cY%C\u0002\u0004N=\u0014a!\u00118z%\u00164GCAB#\u0003I\u00196\tS#N\u0003~+&\u000bT0Q\u0003R#VI\u0015(\u0016\u0005\rU\u0003\u0003BB,\u0007?j!a!\u0017\u000b\t\rm3QL\u0001\t[\u0006$8\r[5oO*\u0019\u0011\u0011H8\n\t\r\u00054\u0011\f\u0002\u0006%\u0016<W\r_\u0001\u0014'\u000eCU)T!`+Jcu\fU!U)\u0016\u0013f\nI\u0001\u000f\u001b\u0016#\u0016\tR!U\u0003~#\u0016I\u0011'F\u0003=iU\tV!E\u0003R\u000bu\fV!C\u0019\u0016\u0003\u0013\u0001E'F)\u0006#\u0015\tV!`\u0007>cU+\u0014(T\u0003EiU\tV!E\u0003R\u000bulQ(M+6s5\u000b\t")
public class JDBCMetadataStore
implements MetadataStore,
Logging {
    private String mysqlDriverClass;
    private final Enumeration.Value dbType;
    private final Option<String> driverClassOpt;
    private final String driverClass;
    private final GenericDatabaseDialect dialect;
    private final boolean priorityEnabled;
    private final Properties datasourceProperties;
    private final HikariConfig hikariConfig;
    @VisibleForTesting
    private final HikariDataSource hikariDataSource;
    private final ObjectMapper mapper;
    private final String terminalStates;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Enumeration.Value dbType() {
        return this.dbType;
    }

    private Option<String> driverClassOpt() {
        return this.driverClassOpt;
    }

    private String mysqlDriverClass$lzycompute() {
        JDBCMetadataStore jDBCMetadataStore = this;
        synchronized (jDBCMetadataStore) {
            if (!this.bitmap$0) {
                this.mysqlDriverClass = ReflectUtils$.MODULE$.isClassLoadable("com.mysql.cj.jdbc.Driver", ReflectUtils$.MODULE$.isClassLoadable$default$2()) ? "com.mysql.cj.jdbc.Driver" : "com.mysql.jdbc.Driver";
                this.bitmap$0 = true;
            }
        }
        return this.mysqlDriverClass;
    }

    private String mysqlDriverClass() {
        if (!this.bitmap$0) {
            return this.mysqlDriverClass$lzycompute();
        }
        return this.mysqlDriverClass;
    }

    private String driverClass() {
        return this.driverClass;
    }

    private GenericDatabaseDialect dialect() {
        return this.dialect;
    }

    private boolean priorityEnabled() {
        return this.priorityEnabled;
    }

    private Properties datasourceProperties() {
        return this.datasourceProperties;
    }

    private HikariConfig hikariConfig() {
        return this.hikariConfig;
    }

    public HikariDataSource hikariDataSource() {
        return this.hikariDataSource;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private String terminalStates() {
        return this.terminalStates;
    }

    private void initSchema() {
        this.getInitSchema(this.dbType()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
            JDBCMetadataStore.$anonfun$initSchema$1(this, schema);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> getInitSchema(Enumeration.Value dbType) {
        ClassLoader classLoader = Utils$.MODULE$.getContextOrKyuubiClassLoader();
        String schemaPackage = new java.lang.StringBuilder(4).append("sql/").append(dbType.toString().toLowerCase()).toString();
        return Option$.MODULE$.apply((Object)classLoader.getResource(schemaPackage)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toURI()).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            String[] stringArray;
            String string = uri.getScheme();
            String string2 = "jar";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try (FileSystem fs = FileSystems.newFileSystem(uri, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());){
                    stringArray = (String[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(fs.getPath(schemaPackage, new String[0]), 1, new FileVisitOption[0]).iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> ((Object)x$3.getFileName()).toString()).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getInitSchema$4(name))).toArray(ClassTag$.MODULE$.apply(String.class));
                }
            } else {
                stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Paths.get(uri).toFile().listFiles((x$4, name) -> JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            }
            String[] pathNames = stringArray;
            return this.getLatestSchemaUrl((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])pathNames)).map((Function1 & Serializable & scala.Serializable)name -> new java.lang.StringBuilder(1).append(schemaPackage).append("/").append((String)name).toString()).map((Function1 & Serializable & scala.Serializable)schemaUrl -> {
                String string;
                try (InputStream inputStream = classLoader.getResourceAsStream((String)schemaUrl);){
                    string = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
                }
                return string;
            });
        });
    }

    public Tuple3<Object, Object, Object> getSchemaVersion(String schemaUrl) {
        Option option = JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)schemaUrl);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return new Tuple3((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(m.group(3))).toInt()));
        }
        throw new KyuubiException(new java.lang.StringBuilder(20).append("Invalid schema url: ").append(schemaUrl).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
    }

    public Option<String> getLatestSchemaUrl(Seq<String> schemaUrls) {
        return ((TraversableLike)schemaUrls.sortWith((Function2 & Serializable & scala.Serializable)(u1, u2) -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getLatestSchemaUrl$1(this, u1, u2)))).headOption();
    }

    @Override
    public void close() {
        this.hikariDataSource().close();
    }

    @Override
    public void insertMetadata(Metadata metadata) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(472).append("\n         |INSERT INTO ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("(\n         |identifier,\n         |session_type,\n         |real_user,\n         |user_name,\n         |ip_address,\n         |kyuubi_instance,\n         |state,\n         |resource,\n         |class_name,\n         |request_name,\n         |request_conf,\n         |request_args,\n         |create_time,\n         |engine_type,\n         |cluster_manager,\n         |priority\n         |)\n         |VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n         |").toString())).stripMargin();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.identifier(), metadata.sessionType().toString(), metadata.realUser(), metadata.username(), metadata.ipAddress(), metadata.kyuubiInstance(), metadata.state(), metadata.resource(), metadata.className(), metadata.requestName(), this.valueAsString(metadata.requestConf()), this.valueAsString(metadata.requestArgs()), BoxesRunTime.boxToLong((long)metadata.createTime()), Option$.MODULE$.apply((Object)metadata.engineType()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toUpperCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms()), metadata.clusterManager().orNull(Predef$.MODULE$.$conforms()), BoxesRunTime.boxToInteger((int)metadata.priority())}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public synchronized Option<Metadata> pickMetadata(String kyuubiInstance) {
        return JdbcUtils$.MODULE$.executeQueryWithRowMapper(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(101).append("SELECT identifier FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("\n         |WHERE state=?\n         |ORDER BY ").append((Object)(this.priorityEnabled() ? "priority DESC, " : "")).append("create_time ASC LIMIT 1\n         |").toString())).stripMargin(), (Function1 & Serializable & scala.Serializable)stmt -> {
            stmt.setString(1, OperationState$.MODULE$.INITIALIZED().toString());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)resultSet -> resultSet.getString(1), (DataSource)this.hikariDataSource()).headOption().filter((Function1 & Serializable & scala.Serializable)preSelectedBatchId -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$pickMetadata$3(this, kyuubiInstance, preSelectedBatchId))).map((Function1 & Serializable & scala.Serializable)pickedBatchId -> this.getMetadata((String)pickedBatchId));
    }

    @Override
    public boolean transformMetadataState(String identifier, String fromState, String targetState) {
        String query = new java.lang.StringBuilder(56).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" SET state = ? WHERE identifier = ? AND state = ?").toString();
        return BoxesRunTime.unboxToBoolean((Object)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$transformMetadataState$1(this, query, fromState, identifier, targetState, connection)), (DataSource)this.hikariDataSource()));
    }

    @Override
    public Metadata getMetadata(String identifier) {
        String query = new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        return (Metadata)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Metadata)this.withResultSet((Connection)connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}), (Function1 & Serializable & scala.Serializable)rs -> (Metadata)this.buildMetadata((ResultSet)rs).headOption().orNull(Predef$.MODULE$.$conforms())), (DataSource)this.hikariDataSource());
    }

    @Override
    public Seq<Metadata> getMetadataList(MetadataFilter filter, int from, int size, Option<String> orderBy, String direction) {
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append("SELECT ");
        queryBuilder.append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_COLUMNS());
        queryBuilder.append(new java.lang.StringBuilder(6).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        queryBuilder.append(new java.lang.StringBuilder(1).append(" ").append(this.assembleWhereClause(filter, (ListBuffer<Object>)params)).toString());
        orderBy.foreach((Function1 & Serializable & scala.Serializable)o -> queryBuilder.append(new java.lang.StringBuilder(12).append(" ORDER BY ").append((String)o).append(" ").append(direction).append(" ").toString()));
        queryBuilder.append(this.dialect().limitClause(size, from));
        String query = queryBuilder.toString();
        return (Seq)JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> (Seq)this.withResultSet((Connection)connection, query, (Seq<Object>)params.toSeq(), (Function1 & Serializable & scala.Serializable)rs -> this.buildMetadata((ResultSet)rs)), (DataSource)this.hikariDataSource());
    }

    @Override
    public Option<String> getMetadataList$default$4() {
        return new Some((Object)"key_id");
    }

    @Override
    public String getMetadataList$default$5() {
        return "ASC";
    }

    @Override
    public int countMetadata(MetadataFilter filter) {
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(21).append("SELECT COUNT(1) FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        queryBuilder.append(new java.lang.StringBuilder(1).append(" ").append(this.assembleWhereClause(filter, (ListBuffer<Object>)params)).toString());
        String query = queryBuilder.toString();
        return BoxesRunTime.unboxToInt((Object)JdbcUtils$.MODULE$.executeQueryWithRowMapper(query, (Function1 & Serializable & scala.Serializable)stmt -> {
            this.setStatementParams(stmt, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params}));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)resultSet -> BoxesRunTime.boxToInteger((int)resultSet.getInt(1)), (DataSource)this.hikariDataSource()).head());
    }

    private String assembleWhereClause(MetadataFilter filter, ListBuffer<Object> params) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        ListBuffer whereConditions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 = 1"}));
        Option$.MODULE$.apply((Object)filter.sessionType()).foreach((Function1 & Serializable & scala.Serializable)sessionType -> {
            whereConditions.$plus$eq((Object)"session_type = ?");
            return params.$plus$eq((Object)sessionType.toString());
        });
        Option$.MODULE$.apply((Object)filter.engineType()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$2(x$7))).foreach((Function1 & Serializable & scala.Serializable)engineType -> {
            whereConditions.$plus$eq((Object)"UPPER(engine_type) = ?");
            return params.$plus$eq((Object)engineType.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.username()).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$4(x$8))).foreach((Function1 & Serializable & scala.Serializable)username -> {
            whereConditions.$plus$eq((Object)"user_name = ?");
            return params.$plus$eq(username);
        });
        Option$.MODULE$.apply((Object)filter.state()).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$6(x$9))).foreach((Function1 & Serializable & scala.Serializable)state -> {
            whereConditions.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)state.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.requestName()).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$8(x$10))).foreach((Function1 & Serializable & scala.Serializable)requestName -> {
            whereConditions.$plus$eq((Object)"request_name = ?");
            return params.$plus$eq(requestName);
        });
        Option$.MODULE$.apply((Object)filter.kyuubiInstance()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$assembleWhereClause$10(x$11))).foreach((Function1 & Serializable & scala.Serializable)kyuubiInstance -> {
            whereConditions.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq(kyuubiInstance);
        });
        if (filter.createTime() > 0L) {
            whereConditions.$plus$eq((Object)"create_time >= ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.createTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (filter.endTime() > 0L) {
            whereConditions.$plus$eq((Object)"end_time > 0");
            whereConditions.$plus$eq((Object)"end_time <= ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.endTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (filter.peerInstanceClosed()) {
            whereConditions.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)filter.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return whereConditions.mkString("WHERE ", " AND ", "");
    }

    @Override
    public void updateMetadata(Metadata metadata) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(7).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer setClauses = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)metadata.kyuubiInstance()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            setClauses.$plus$eq((Object)"kyuubi_instance = ?");
            return params.$plus$eq((Object)metadata.kyuubiInstance());
        });
        Option$.MODULE$.apply((Object)metadata.state()).foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            setClauses.$plus$eq((Object)"state = ?");
            return params.$plus$eq((Object)metadata.state());
        });
        Option$.MODULE$.apply(metadata.requestConf()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.nonEmpty())).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            setClauses.$plus$eq((Object)"request_conf =?");
            return params.$plus$eq((Object)this.valueAsString(metadata.requestConf()));
        });
        metadata.clusterManager().foreach((Function1 & Serializable & scala.Serializable)cm -> {
            setClauses.$plus$eq((Object)"cluster_manager = ?");
            return params.$plus$eq(cm);
        });
        if (metadata.endTime() > 0L) {
            setClauses.$plus$eq((Object)"end_time = ?");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.endTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (metadata.engineOpenTime() > 0L) {
            setClauses.$plus$eq((Object)"engine_open_time = ?");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.engineOpenTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply((Object)metadata.engineId()).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            setClauses.$plus$eq((Object)"engine_id = ?");
            return params.$plus$eq((Object)metadata.engineId());
        });
        Option$.MODULE$.apply((Object)metadata.engineName()).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            setClauses.$plus$eq((Object)"engine_name = ?");
            return params.$plus$eq((Object)metadata.engineName());
        });
        Option$.MODULE$.apply((Object)metadata.engineUrl()).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            setClauses.$plus$eq((Object)"engine_url = ?");
            return params.$plus$eq((Object)metadata.engineUrl());
        });
        Option$.MODULE$.apply((Object)metadata.engineState()).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            setClauses.$plus$eq((Object)"engine_state = ?");
            return params.$plus$eq((Object)metadata.engineState());
        });
        metadata.engineError().foreach((Function1 & Serializable & scala.Serializable)error -> {
            setClauses.$plus$eq((Object)"engine_error = ?");
            return params.$plus$eq(error);
        });
        if (metadata.peerInstanceClosed()) {
            setClauses.$plus$eq((Object)"peer_instance_closed = ?");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)metadata.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = setClauses.nonEmpty() ? queryBuilder.append(setClauses.mkString(" SET ", ", ", "")) : BoxedUnit.UNIT;
        queryBuilder.append(" WHERE identifier = ?");
        params.$plus$eq((Object)metadata.identifier());
        String query = queryBuilder.toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.withUpdateCount(connection, query, (Seq<Object>)params.toSeq(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)updateCount -> {
                if (updateCount == 0) {
                    throw new KyuubiException(new java.lang.StringBuilder(52).append("Error updating metadata for ").append(metadata$2.identifier()).append(" by SQL: ").append(query$5).append(", ").append("with params: ").append(params$4.mkString(", ")).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByIdentifier(String identifier) {
        String query = new java.lang.StringBuilder(33).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    @Override
    public void cleanupMetadataByAge(long maxAge) {
        long minEndTime = System.currentTimeMillis() - maxAge;
        String query = new java.lang.StringBuilder(47).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE state IN (").append(this.terminalStates()).append(") AND end_time < ?").toString();
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minEndTime)}));
            return BoxedUnit.UNIT;
        }, (DataSource)this.hikariDataSource());
    }

    private Seq<Metadata> buildMetadata(ResultSet resultSet) {
        Seq seq;
        try {
            ListBuffer metadataList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (resultSet.next()) {
                String identifier = resultSet.getString("identifier");
                Enumeration.Value sessionType = SessionType$.MODULE$.withName(resultSet.getString("session_type"));
                String realUser = resultSet.getString("real_user");
                String userName = resultSet.getString("user_name");
                String ipAddress = resultSet.getString("ip_address");
                String kyuubiInstance = resultSet.getString("kyuubi_instance");
                String state = resultSet.getString("state");
                String resource = resultSet.getString("resource");
                String className = resultSet.getString("class_name");
                String requestName = resultSet.getString("request_name");
                scala.collection.immutable.Map<String, String> requestConf = this.string2Map(resultSet.getString("request_conf"));
                Seq<String> requestArgs = this.string2Seq(resultSet.getString("request_args"));
                long createTime = resultSet.getLong("create_time");
                String engineType = resultSet.getString("engine_type");
                Option clusterManager = Option$.MODULE$.apply((Object)resultSet.getString("cluster_manager"));
                long engineOpenTime = resultSet.getLong("engine_open_time");
                String engineId = resultSet.getString("engine_id");
                String engineName = resultSet.getString("engine_name");
                String engineUrl = resultSet.getString("engine_url");
                String engineState = resultSet.getString("engine_state");
                Option engineError = Option$.MODULE$.apply((Object)resultSet.getString("engine_error"));
                long endTime = resultSet.getLong("end_time");
                boolean peerInstanceClosed = resultSet.getBoolean("peer_instance_closed");
                String x$1 = identifier;
                Enumeration.Value x$2 = sessionType;
                String x$3 = realUser;
                String x$4 = userName;
                String x$5 = ipAddress;
                String x$6 = kyuubiInstance;
                String x$7 = state;
                String x$8 = resource;
                String x$9 = className;
                String x$10 = requestName;
                scala.collection.immutable.Map<String, String> x$11 = requestConf;
                Seq<String> x$12 = requestArgs;
                long x$13 = createTime;
                String x$14 = engineType;
                Option x$15 = clusterManager;
                long x$16 = engineOpenTime;
                String x$17 = engineId;
                String x$18 = engineName;
                String x$19 = engineUrl;
                String x$20 = engineState;
                Option x$21 = engineError;
                long x$22 = endTime;
                boolean x$23 = peerInstanceClosed;
                int x$24 = Metadata$.MODULE$.apply$default$23();
                Metadata metadata = new Metadata(x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Option<String>)x$15, x$16, x$17, x$18, x$19, x$20, (Option<String>)x$21, x$22, x$24, x$23);
                metadataList.$plus$eq((Object)metadata);
            }
            seq = metadataList.toSeq();
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resultSet.close());
        }
        return seq;
    }

    private void execute(Connection conn, String sql, Seq<Object> params) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(28).append("execute sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                ((PreparedStatement)statement.elem).execute();
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$1.elem).close());
            }
        }
    }

    private <T> T withResultSet(Connection conn, String sql, Seq<Object> params, Function1<ResultSet, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("executeQuery sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        ObjectRef resultSet = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                resultSet.elem = ((PreparedStatement)statement.elem).executeQuery();
                object = f.apply((Object)((ResultSet)resultSet.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((ResultSet)resultSet.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$2.elem).close());
            }
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> T withUpdateCount(Connection conn, String sql, Seq<Object> params, Function1<Object, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(34).append("executeUpdate sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                object = f.apply((Object)BoxesRunTime.boxToInteger((int)((PreparedStatement)statement.elem).executeUpdate()));
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(38).append("Error executing sql: ").append(sql).append(", with params: ").append(params.mkString(", ")).append(". ").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$3.elem).close());
            }
        }
        return (T)object;
    }

    private void setStatementParams(PreparedStatement statement, Seq<Object> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCMetadataStore.$anonfun$setStatementParams$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private String valueAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    private scala.collection.immutable.Map<String, String> string2Map(String str) {
        if (str == null || str.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        return (scala.collection.immutable.Map)this.mapper().readValue(str, scala.collection.immutable.Map.class);
    }

    private Seq<String> string2Seq(String str) {
        if (str == null || str.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)this.mapper().readValue(str, Seq.class);
    }

    public static final /* synthetic */ void $anonfun$initSchema$5(JDBCMetadataStore $this, Connection connection$1, String ddlStatement) {
        $this.execute(connection$1, ddlStatement, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(81).append("Execute init schema ddl successfully.\n                    |").append(ddlStatement).append("\n                    |").toString())).stripMargin());
    }

    public static final /* synthetic */ void $anonfun$initSchema$1(JDBCMetadataStore $this, String schema) {
        String[] ddlStatements = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.trim().split(";"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        JdbcUtils$.MODULE$.withConnection((Function1 & Serializable & scala.Serializable)connection -> {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ddlStatements)).foreach((Function1 & Serializable & scala.Serializable)ddlStatement -> {
                JDBCMetadataStore.$anonfun$initSchema$5($this, connection, ddlStatement);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource());
    }

    public static final /* synthetic */ boolean $anonfun$getInitSchema$4(String name) {
        return JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$SCHEMA_URL_PATTERN().findFirstMatchIn((CharSequence)name).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getLatestSchemaUrl$1(JDBCMetadataStore $this, String u1, String u2) {
        Tuple3<Object, Object, Object> v1 = $this.getSchemaVersion(u1);
        Tuple3<Object, Object, Object> v2 = $this.getSchemaVersion(u2);
        return BoxesRunTime.unboxToInt((Object)v1._1()) > BoxesRunTime.unboxToInt((Object)v2._1()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) > BoxesRunTime.unboxToInt((Object)v2._2()) || BoxesRunTime.unboxToInt((Object)v1._1()) == BoxesRunTime.unboxToInt((Object)v2._1()) && BoxesRunTime.unboxToInt((Object)v1._2()) == BoxesRunTime.unboxToInt((Object)v2._2()) && BoxesRunTime.unboxToInt((Object)v1._3()) > BoxesRunTime.unboxToInt((Object)v2._3());
    }

    public static final /* synthetic */ void $anonfun$pickMetadata$4(String kyuubiInstance$1, String preSelectedBatchId$1, PreparedStatement stmt) {
        stmt.setString(1, kyuubiInstance$1);
        stmt.setString(2, OperationState$.MODULE$.PENDING().toString());
        stmt.setString(3, preSelectedBatchId$1);
        stmt.setString(4, OperationState$.MODULE$.INITIALIZED().toString());
    }

    public static final /* synthetic */ boolean $anonfun$pickMetadata$3(JDBCMetadataStore $this, String kyuubiInstance$1, String preSelectedBatchId) {
        return JdbcUtils$.MODULE$.executeUpdate(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(106).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("\n           |SET kyuubi_instance=?, state=?\n           |WHERE identifier=? AND state=?\n           |").toString())).stripMargin(), (Function1 & Serializable & scala.Serializable)stmt -> {
            JDBCMetadataStore.$anonfun$pickMetadata$4(kyuubiInstance$1, preSelectedBatchId, stmt);
            return BoxedUnit.UNIT;
        }, (DataSource)$this.hikariDataSource()) == 1;
    }

    public static final /* synthetic */ boolean $anonfun$transformMetadataState$1(JDBCMetadataStore $this, String query$2, String fromState$1, String identifier$1, String targetState$1, Connection connection) {
        return BoxesRunTime.unboxToBoolean($this.withUpdateCount(connection, query$2, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fromState$1, identifier$1, targetState$1}), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)updateCount -> updateCount == 1));
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$2(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$4(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$6(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$8(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$assembleWhereClause$10(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$setStatementParams$1(PreparedStatement statement$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object param = tuple2._1();
            int index = tuple2._2$mcI$sp();
            Object object = param;
            if (object == null) {
                statement$4.setObject(index + 1, null);
            } else if (object instanceof String) {
                String string = (String)object;
                statement$4.setString(index + 1, string);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                statement$4.setInt(index + 1, n);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                statement$4.setLong(index + 1, l);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                statement$4.setDouble(index + 1, d);
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                statement$4.setFloat(index + 1, f);
            } else if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                statement$4.setBoolean(index + 1, bl);
            } else {
                throw new KyuubiException(new java.lang.StringBuilder(23).append("Unsupported param type ").append(param.getClass().getName()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public JDBCMetadataStore(KyuubiConf conf) {
        block16: {
            GenericDatabaseDialect genericDatabaseDialect;
            String string;
            Logging.$init$((Logging)this);
            this.dbType = DatabaseType$.MODULE$.withName((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_TYPE()));
            this.driverClassOpt = (Option)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DRIVER());
            Enumeration.Value value = this.dbType();
            Enumeration.Value value2 = DatabaseType$.MODULE$.SQLITE();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.sqlite.JDBC");
            } else {
                Enumeration.Value value4 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.mysqlDriverClass());
                } else {
                    Enumeration.Value value6 = DatabaseType$.MODULE$.POSTGRESQL();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.postgresql.Driver");
                    } else {
                        Enumeration.Value value8 = DatabaseType$.MODULE$.CUSTOM();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                throw new IllegalArgumentException("No jdbc driver defined");
                            });
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
            this.driverClass = string;
            Enumeration.Value value10 = this.dbType();
            Enumeration.Value value11 = DatabaseType$.MODULE$.SQLITE();
            Enumeration.Value value12 = value10;
            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                genericDatabaseDialect = new SQLiteDatabaseDialect();
            } else {
                Enumeration.Value value13 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value14 = value10;
                if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                    genericDatabaseDialect = new MySQLDatabaseDialect();
                } else {
                    Enumeration.Value value15 = DatabaseType$.MODULE$.POSTGRESQL();
                    Enumeration.Value value16 = value10;
                    if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                        genericDatabaseDialect = new PostgreSQLDatabaseDialect();
                    } else {
                        Enumeration.Value value17 = DatabaseType$.MODULE$.CUSTOM();
                        Enumeration.Value value18 = value10;
                        if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                            genericDatabaseDialect = new GenericDatabaseDialect();
                        } else {
                            throw new MatchError((Object)value10);
                        }
                    }
                }
            }
            this.dialect = genericDatabaseDialect;
            this.priorityEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PRIORITY_ENABLED()));
            this.datasourceProperties = JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJDBCDataSourceProperties(conf);
            this.hikariConfig = new HikariConfig(this.datasourceProperties());
            this.hikariConfig().setDriverClassName(this.driverClass());
            this.hikariConfig().setJdbcUrl(JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJdbcUrl(conf));
            this.hikariConfig().setUsername((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_USER()));
            this.hikariConfig().setPassword((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PASSWORD()));
            this.hikariConfig().setPoolName("jdbc-metadata-store-pool");
            this.hikariDataSource = new HikariDataSource(this.hikariConfig());
            this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            this.terminalStates = ((TraversableOnce)OperationState$.MODULE$.terminalStates().map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(2).append("'").append(x).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_SCHEMA_INIT()))) break block16;
            this.initSchema();
        }
    }
}

