/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import org.apache.hive.beeline.AbstractOutputFormat;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.Rows;

public class JSONOutputFormat
extends AbstractOutputFormat {
    protected final BeeLine beeLine;
    protected JsonGenerator generator;

    JSONOutputFormat(BeeLine beeLine) {
        this.beeLine = beeLine;
        try {
            this.generator = new JsonFactory().createGenerator((OutputStream)new ByteArrayOutputStream(), JsonEncoding.UTF8);
        }
        catch (IOException e) {
            beeLine.handleException(e);
        }
    }

    @Override
    void printHeader(Rows.Row header) {
        try {
            this.generator.writeStartObject();
            this.generator.writeArrayFieldStart("resultset");
        }
        catch (IOException e) {
            this.beeLine.handleException(e);
        }
    }

    @Override
    void printFooter(Rows.Row header) {
        ByteArrayOutputStream buf = (ByteArrayOutputStream)this.generator.getOutputTarget();
        try {
            this.generator.writeEndArray();
            this.generator.writeEndObject();
            this.generator.flush();
            String out = buf.toString(StandardCharsets.UTF_8.name());
            this.beeLine.output(out);
        }
        catch (IOException e) {
            this.beeLine.handleException(e);
        }
        buf.reset();
    }

    @Override
    void printRow(Rows rows, Rows.Row header, Rows.Row row) {
        String[] head = header.values;
        String[] vals = row.values;
        try {
            this.generator.writeStartObject();
            block9: for (int i = 0; i < head.length && i < vals.length; ++i) {
                this.generator.writeFieldName(head[i]);
                switch (rows.rsMeta.getColumnType(i + 1)) {
                    case -8: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.generator.writeNumber(vals[i]);
                        continue block9;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        this.generator.writeString(vals[i]);
                        continue block9;
                    }
                    case 0: {
                        this.generator.writeNull();
                        continue block9;
                    }
                    case 16: {
                        this.generator.writeBoolean(Boolean.parseBoolean(vals[i]));
                        continue block9;
                    }
                    default: {
                        this.generator.writeString(vals[i]);
                    }
                }
            }
            this.generator.writeEndObject();
        }
        catch (IOException e) {
            this.beeLine.handleException(e);
        }
        catch (SQLException e) {
            this.beeLine.handleSQLException(e);
        }
    }
}

