/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.hive.metastore.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.kyuubi.shaded.hive.metastore.api.MetaException;
import org.apache.kyuubi.shaded.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.kyuubi.shaded.hive.metastore.security.DelegationTokenSelector;
import org.apache.kyuubi.shaded.thrift.transport.THttpClient;
import org.apache.kyuubi.shaded.thrift.transport.TSSLTransportFactory;
import org.apache.kyuubi.shaded.thrift.transport.TServerSocket;
import org.apache.kyuubi.shaded.thrift.transport.TSocket;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);

    public static UserGroupInformation getUGI() throws LoginException, IOException {
        String doAs = System.getenv("HADOOP_USER_NAME");
        if (doAs != null && doAs.length() > 0) {
            return UserGroupInformation.createProxyUser((String)doAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        return UserGroupInformation.getCurrentUser();
    }

    public static void setZookeeperClientKerberosJaasConfig(String principal, String keyTabFile) throws IOException {
        String SASL_LOGIN_CONTEXT_NAME = "HiveZooKeeperClient";
        System.setProperty("zookeeper.sasl.clientconfig", "HiveZooKeeperClient");
        principal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        JaasConfiguration jaasConf = new JaasConfiguration("HiveZooKeeperClient", principal, keyTabFile);
        Configuration.setConfiguration(jaasConf);
    }

    public static String getTokenStrForm(String tokenSignature) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        DelegationTokenSelector tokenSelector = new DelegationTokenSelector();
        Token token = tokenSelector.selectToken(tokenSignature == null ? new Text() : new Text(tokenSignature), ugi.getTokens());
        return token != null ? token.encodeToUrlString() : null;
    }

    public static void setTokenStr(UserGroupInformation ugi, String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = SecurityUtils.createToken(tokenStr, tokenService);
        ugi.addToken(delegationToken);
    }

    private static Token<DelegationTokenIdentifier> createToken(String tokenStr, String tokenService) throws IOException {
        Token delegationToken = new Token();
        delegationToken.decodeFromUrlString(tokenStr);
        delegationToken.setService(new Text(tokenService));
        return delegationToken;
    }

    public static String getUser() throws IOException {
        try {
            UserGroupInformation ugi = SecurityUtils.getUGI();
            return ugi.getUserName();
        }
        catch (LoginException le) {
            throw new IOException(le);
        }
    }

    public static TServerSocket getServerSocket(String hiveHost, int portNum) throws TTransportException {
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        return new TServerSocket(serverAddress);
    }

    public static TServerSocket getServerSSLSocket(String hiveHost, int portNum, String keyStorePath, String keyStorePassWord, String keyStoreType, String keyStoreAlgorithm, List<String> sslVersionBlacklist) throws TTransportException, UnknownHostException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        String kStoreType = keyStoreType.isEmpty() ? KeyStore.getDefaultType() : keyStoreType;
        String kStoreAlgorithm = keyStoreAlgorithm.isEmpty() ? KeyManagerFactory.getDefaultAlgorithm() : keyStoreAlgorithm;
        params.setKeyStore(keyStorePath, keyStorePassWord, kStoreAlgorithm, kStoreType);
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        TServerSocket thriftServerSocket = TSSLTransportFactory.getServerSocket((int)portNum, (int)0, (InetAddress)serverAddress.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)params);
        if (thriftServerSocket.getServerSocket() instanceof SSLServerSocket) {
            ArrayList<String> sslVersionBlacklistLocal = new ArrayList<String>();
            for (String sslVersion : sslVersionBlacklist) {
                sslVersionBlacklistLocal.add(sslVersion.trim().toLowerCase());
            }
            SSLServerSocket sslServerSocket = (SSLServerSocket)thriftServerSocket.getServerSocket();
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            for (String protocol : sslServerSocket.getEnabledProtocols()) {
                if (sslVersionBlacklistLocal.contains(protocol.toLowerCase())) {
                    LOG.debug("Disabling SSL Protocol: " + protocol);
                    continue;
                }
                enabledProtocols.add(protocol);
            }
            sslServerSocket.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            LOG.info("SSL Server Socket Enabled Protocols: " + Arrays.toString(sslServerSocket.getEnabledProtocols()));
        }
        return thriftServerSocket;
    }

    public static TTransport getSSLSocket(String host, int port, int socketTimeout, int connectionTimeout, String trustStorePath, String trustStorePassWord, String trustStoreType, String trustStoreAlgorithm) throws TTransportException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters();
        String tStoreType = trustStoreType.isEmpty() ? KeyStore.getDefaultType() : trustStoreType;
        String tStoreAlgorithm = trustStoreAlgorithm.isEmpty() ? TrustManagerFactory.getDefaultAlgorithm() : trustStoreAlgorithm;
        params.setTrustStore(trustStorePath, trustStorePassWord, tStoreAlgorithm, tStoreType);
        params.requireClientAuth(true);
        TSocket tSSLSocket = TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)socketTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
        tSSLSocket.setConnectTimeout(connectionTimeout);
        return SecurityUtils.getSSLSocketWithHttps(tSSLSocket);
    }

    public static THttpClient getThriftHttpsClient(String httpsUrl, String trustStorePath, String trustStorePasswd, String trustStoreAlgorithm, String trustStoreType, HttpClientBuilder underlyingHttpClientBuilder) throws TTransportException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, KeyManagementException {
        Objects.requireNonNull(underlyingHttpClientBuilder, "httpClientBuilder should not be null");
        if (trustStoreType == null || trustStoreType.isEmpty()) {
            trustStoreType = KeyStore.getDefaultType();
        }
        KeyStore sslTrustStore = KeyStore.getInstance(trustStoreType);
        try (FileInputStream fis = new FileInputStream(trustStorePath);){
            sslTrustStore.load(fis, trustStorePasswd.toCharArray());
        }
        SSLContext sslContext = SSLContexts.custom().setTrustManagerFactoryAlgorithm(trustStoreAlgorithm).loadTrustMaterial(sslTrustStore, null).build();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier(null));
        Registry registry = RegistryBuilder.create().register("https", (Object)socketFactory).build();
        underlyingHttpClientBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry));
        return new THttpClient(httpsUrl, (HttpClient)underlyingHttpClientBuilder.build());
    }

    private static TSocket getSSLSocketWithHttps(TSocket tSSLSocket) throws TTransportException {
        SSLSocket sslSocket = (SSLSocket)tSSLSocket.getSocket();
        SSLParameters sslParams = sslSocket.getSSLParameters();
        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
        sslSocket.setSSLParameters(sslParams);
        return new TSocket((Socket)sslSocket);
    }

    public static void reloginExpiringKeytabUser() throws MetaException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        try {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            if (ugi.isFromKeytab()) {
                ugi.checkTGTAndReloginFromKeytab();
            }
        }
        catch (IOException e) {
            String msg = "Error doing relogin using keytab " + e.getMessage();
            LOG.error(msg, (Throwable)e);
            throw new MetaException(msg);
        }
    }

    private static class JaasConfiguration
    extends Configuration {
        private static final boolean IBM_JAVA = System.getProperty("java.vendor").contains("IBM");
        private final Configuration baseConfig = Configuration.getConfiguration();
        private final String loginContextName;
        private final String principal;
        private final String keyTabFile;

        public JaasConfiguration(String hiveLoginContextName, String principal, String keyTabFile) {
            this.loginContextName = hiveLoginContextName;
            this.principal = principal;
            this.keyTabFile = keyTabFile;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.loginContextName.equals(appName)) {
                HashMap<String, String> krbOptions = new HashMap<String, String>();
                if (IBM_JAVA) {
                    krbOptions.put("credsType", "both");
                    krbOptions.put("useKeytab", this.keyTabFile);
                } else {
                    krbOptions.put("doNotPrompt", "true");
                    krbOptions.put("storeKey", "true");
                    krbOptions.put("useKeyTab", "true");
                    krbOptions.put("keyTab", this.keyTabFile);
                }
                krbOptions.put("principal", this.principal);
                krbOptions.put("refreshKrb5Config", "true");
                AppConfigurationEntry hiveZooKeeperClientEntry = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, krbOptions);
                return new AppConfigurationEntry[]{hiveZooKeeperClientEntry};
            }
            if (this.baseConfig != null) {
                return this.baseConfig.getAppConfigurationEntry(appName);
            }
            return null;
        }
    }
}

