/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.common;

import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Service
implements AutoCloseable {
    private final AtomicBoolean running = new AtomicBoolean();

    protected Service() {
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.doStart();
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.doStop();
        }
    }

    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public void close() {
        this.stop();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected abstract void doStart();

    protected abstract void doStop();
}

