/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.factory.providers.RpcFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class HadoopYarnProtoRPC
extends YarnRPC {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopYarnProtoRPC.class);

    @Override
    public Object getProxy(Class protocol, InetSocketAddress addr, Configuration conf) {
        LOG.debug("Creating a HadoopYarnProtoRpc proxy for protocol {}", (Object)protocol);
        return RpcFactoryProvider.getClientFactory(conf).getClient(protocol, 1L, addr, conf);
    }

    @Override
    public void stopProxy(Object proxy, Configuration conf) {
        RpcFactoryProvider.getClientFactory(conf).stopClient(proxy);
    }

    @Override
    public Server getServer(Class protocol, Object instance, InetSocketAddress addr, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager, int numHandlers, String portRangeConfig) {
        LOG.debug("Creating a HadoopYarnProtoRpc server for protocol {} with {} handlers", (Object)protocol, (Object)numHandlers);
        return RpcFactoryProvider.getServerFactory(conf).getServer(protocol, instance, addr, conf, secretManager, numHandlers, portRangeConfig);
    }
}

