/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc;

import java.util.List;
import org.apache.kyuubi.shade.io.grpc.Configurator;
import org.apache.kyuubi.shade.io.grpc.ConfiguratorRegistry;
import org.apache.kyuubi.shade.io.grpc.Internal;
import org.apache.kyuubi.shade.io.grpc.InternalConfigurator;
import org.apache.kyuubi.shade.io.grpc.ManagedChannelBuilder;
import org.apache.kyuubi.shade.io.grpc.ServerBuilder;

@Internal
public final class InternalConfiguratorRegistry {
    private InternalConfiguratorRegistry() {
    }

    public static void setConfigurators(List<InternalConfigurator> configurators) {
        ConfiguratorRegistry.getDefaultRegistry().setConfigurators(configurators);
    }

    public static List<?> getConfigurators() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfigurators();
    }

    public static void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureChannelBuilder(channelBuilder);
        }
    }

    public static void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureServerBuilder(serverBuilder);
        }
    }

    public static boolean wasSetConfiguratorsCalled() {
        return ConfiguratorRegistry.getDefaultRegistry().wasSetConfiguratorsCalled();
    }

    public static int getConfiguratorsCallCountBeforeSet() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfiguratorsCallCountBeforeSet();
    }
}

