/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.http.authentication;

import java.io.IOException;
import java.io.Serializable;
import javax.security.sasl.AuthenticationException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.server.http.authentication.AuthenticationAuditLogger$;
import org.apache.kyuubi.server.http.authentication.AuthenticationFilter$;
import org.apache.kyuubi.server.http.authentication.AuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.BasicAuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.BearerAuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.KerberosAuthenticationHandler;
import org.apache.kyuubi.server.http.authentication.KyuubiInternalAuthenticationHandler;
import org.apache.kyuubi.server.http.util.HttpAuthUtils$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0011#\u0001=B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\t!\u0002\u0011\r\u0011\"\u0001##\"1a\r\u0001Q\u0001\nICaa\u001a\u0001\u0005\u0002\tB\u0007BB8\u0001\t\u0003A\u0003\u000fC\u0003r\u0001\u0011\u0005#\u000f\u0003\u0004y\u0001\u0011\u0005\u0001&\u001f\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\t)\u0002\u0001C\t\u0003oAa!!,\u0001\t\u0003\u0002xaBAXE!\u0005\u0011\u0011\u0017\u0004\u0007C\tB\t!a-\t\r-kA\u0011AA^\u0011%\ti,\u0004b\u0001\n\u000b\ty\f\u0003\u0005\u0002H6\u0001\u000bQBAa\u0011%\tI-\u0004b\u0001\n\u000b\ty\f\u0003\u0005\u0002L6\u0001\u000bQBAa\u0011%\ti-\u0004b\u0001\n\u000b\ty\f\u0003\u0005\u0002P6\u0001\u000bQBAa\u0011%\t\t.\u0004b\u0001\n\u000b\ty\f\u0003\u0005\u0002T6\u0001\u000bQBAa\u0011%\t).\u0004b\u0001\n\u000b\ty\f\u0003\u0005\u0002X6\u0001\u000bQBAa\u0011%\tI.\u0004b\u0001\n\u000b\tY\u000e\u0003\u0005\u0002l6\u0001\u000bQBAo\u0011\u001d\ti/\u0004C\u0001\u0003GBq!a<\u000e\t\u0003\t\u0019\u0007C\u0004\u0002r6!\t!a=\t\u000f\u0005UX\u0002\"\u0001\u0002d!9\u0011q_\u0007\u0005\u0002\u0005\r\u0004bBA}\u001b\u0011\u0005\u00111\r\u0002\u0015\u0003V$\b.\u001a8uS\u000e\fG/[8o\r&dG/\u001a:\u000b\u0005\r\"\u0013AD1vi\",g\u000e^5dCRLwN\u001c\u0006\u0003K\u0019\nA\u0001\u001b;ua*\u0011q\u0005K\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005%R\u0013AB6zkV\u0014\u0017N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\u0005\u0001AB\u0004\t\u0005\u00022m5\t!G\u0003\u00024i\u0005!A.\u00198h\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\r=\u0013'.Z2u!\tId(D\u0001;\u0015\tYD(A\u0004tKJ4H.\u001a;\u000b\u0003u\nQA[1wCbL!a\u0010\u001e\u0003\r\u0019KG\u000e^3s!\t\t%)D\u0001)\u0013\t\u0019\u0005FA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gN\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\"\naaY8oM&<\u0017B\u0001&H\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055{\u0005C\u0001(\u0001\u001b\u0005\u0011\u0003\"\u0002#\u0003\u0001\u0004)\u0015AE1vi\"\u001c6\r[3nK\"\u000bg\u000e\u001a7feN,\u0012A\u0015\t\u0005'jc6-D\u0001U\u0015\t)f+A\u0004nkR\f'\r\\3\u000b\u0005]C\u0016AC2pY2,7\r^5p]*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\)\n9\u0001*Y:i\u001b\u0006\u0004\bCA/a\u001d\tqe,\u0003\u0002`E\u0005Y\u0011)\u001e;i'\u000eDW-\\3t\u0013\t\t'M\u0001\u0006BkRD7k\u00195f[\u0016T!a\u0018\u0012\u0011\u00059#\u0017BA3#\u0005U\tU\u000f\u001e5f]RL7-\u0019;j_:D\u0015M\u001c3mKJ\f1#Y;uQN\u001b\u0007.Z7f\u0011\u0006tG\r\\3sg\u0002\na\"\u00193e\u0003V$\b\u000eS1oI2,'\u000f\u0006\u0002j[B\u0011!n[\u0007\u00021&\u0011A\u000e\u0017\u0002\u0005+:LG\u000fC\u0003o\u000b\u0001\u00071-A\u0006bkRD\u0007*\u00198eY\u0016\u0014\u0018\u0001E5oSR\fU\u000f\u001e5IC:$G.\u001a:t)\u0005I\u0017\u0001B5oSR$\"![:\t\u000bQ<\u0001\u0019A;\u0002\u0019\u0019LG\u000e^3s\u0007>tg-[4\u0011\u0005e2\u0018BA<;\u000511\u0015\u000e\u001c;fe\u000e{gNZ5h\u0003E9W\r^'bi\u000eDW\r\u001a%b]\u0012dWM\u001d\u000b\u0003uv\u00042A[>d\u0013\ta\bL\u0001\u0004PaRLwN\u001c\u0005\u0006}\"\u0001\ra`\u0001\u000eCV$\bn\u001c:ju\u0006$\u0018n\u001c8\u0011\t\u0005\u0005\u0011q\u0002\b\u0005\u0003\u0007\tY\u0001E\u0002\u0002\u0006ak!!a\u0002\u000b\u0007\u0005%a&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001bA\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0012\u0005M!AB*ue&twMC\u0002\u0002\u000ea\u000b\u0001\u0002Z8GS2$XM\u001d\u000b\bS\u0006e\u00111EA\u0017\u0011\u001d\tY\"\u0003a\u0001\u0003;\tqA]3rk\u0016\u001cH\u000fE\u0002:\u0003?I1!!\t;\u00059\u0019VM\u001d<mKR\u0014V-];fgRDq!!\n\n\u0001\u0004\t9#\u0001\u0005sKN\u0004xN\\:f!\rI\u0014\u0011F\u0005\u0004\u0003WQ$aD*feZdW\r\u001e*fgB|gn]3\t\u000f\u0005=\u0012\u00021\u0001\u00022\u0005Ya-\u001b7uKJ\u001c\u0005.Y5o!\rI\u00141G\u0005\u0004\u0003kQ$a\u0003$jYR,'o\u00115bS:$r![A\u001d\u0003w\t9\u0005C\u0004\u00020)\u0001\r!!\r\t\u000f\u0005m!\u00021\u0001\u0002>A!\u0011qHA\"\u001b\t\t\tE\u0003\u0002&u%!\u0011QIA!\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\t\u000f\u0005\u0015\"\u00021\u0001\u0002JA!\u0011qHA&\u0013\u0011\ti%!\u0011\u0003'!#H\u000f]*feZdW\r\u001e*fgB|gn]3)\u000b)\t\t&!\u0018\u0011\u000b)\f\u0019&a\u0016\n\u0007\u0005U\u0003L\u0001\u0004uQJ|wo\u001d\t\u0004s\u0005e\u0013bAA.u\t\u00012+\u001a:wY\u0016$X\t_2faRLwN\\\u0019\u0007=}\fy&!%2\u0013\r\n\t'!\u001b\u0002\b\u0006-T\u0003BA2\u0003K*\u0012a \u0003\b\u0003Or#\u0019AA9\u0005\u0005!\u0016\u0002BA6\u0003[\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA81\u00061A\u000f\u001b:poN\fB!a\u001d\u0002zA\u0019!.!\u001e\n\u0007\u0005]\u0004LA\u0004O_RD\u0017N\\4\u0011\t\u0005m\u0014\u0011\u0011\b\u0004U\u0006u\u0014bAA@1\u00069\u0001/Y2lC\u001e,\u0017\u0002BAB\u0003\u000b\u0013\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005}\u0004,M\u0005$\u0003\u0013\u000bY)!$\u0002p9\u0019!.a#\n\u0007\u0005=\u0004,M\u0003#Ub\u000byIA\u0003tG\u0006d\u0017-M\u0002'\u0003/BSACAK\u0003G\u0003RA[A*\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004\u0003;#\u0014AA5p\u0013\u0011\t\t+a'\u0003\u0017%{U\t_2faRLwN\\\u0019\u0007=}\f)+a+2\u0013\r\n\t'!\u001b\u0002(\u0006-\u0014'C\u0012\u0002\n\u0006-\u0015\u0011VA8c\u0015\u0011#\u000eWAHc\r1\u0013qS\u0001\bI\u0016\u001cHO]8z\u0003Q\tU\u000f\u001e5f]RL7-\u0019;j_:4\u0015\u000e\u001c;feB\u0011a*D\n\u0004\u001b\u0005U\u0006c\u00016\u00028&\u0019\u0011\u0011\u0018-\u0003\r\u0005s\u0017PU3g)\t\t\t,\u0001\fI)R\u0003vl\u0011'J\u000b:#v,\u0013)`\u0003\u0012#%+R*T+\t\t\t\r\u0005\u00032\u0003\u0007|\u0018bAAce\tYA\u000b\u001b:fC\u0012dunY1m\u0003]AE\u000b\u0016)`\u00072KUI\u0014+`\u0013B{\u0016\t\u0012#S\u000bN\u001b\u0006%A\u0012I)R\u0003v\f\u0015*P1f{\u0006*R!E\u000bJ{6\tT%F\u001dR{\u0016\nU0B\t\u0012\u0013ViU*\u0002I!#F\u000bU0Q%>C\u0016l\u0018%F\u0003\u0012+%kX\"M\u0013\u0016sEkX%Q?\u0006#EIU#T'\u0002\nQ\u0003\u0013+U!~\u001bE*S#O)~+6+\u0012*`\u001d\u0006kU)\u0001\fI)R\u0003vl\u0011'J\u000b:#v,V*F%~s\u0015)T#!\u00039AE\u000b\u0016)`\u0003V#\u0006j\u0018+Z!\u0016\u000bq\u0002\u0013+U!~\u000bU\u000b\u0016%`)f\u0003V\tI\u0001\u001c\u0011R#\u0006kX\"M\u0013\u0016sEk\u0018)S\u001fbKv,V*F%~s\u0015)T#\u00029!#F\u000bU0D\u0019&+e\nV0Q%>C\u0016lX+T\u000bJ{f*Q'FA\u0005A\u0002\n\u0016+Q?\u001a{%kV!S\t\u0016#u,\u0011#E%\u0016\u001b6+R*\u0016\u0005\u0005u\u0007#B\u0019\u0002D\u0006}\u0007#BAq\u0003O|h\u0002BAr\u0003{rA!!\u0002\u0002f&\t\u0011,\u0003\u0003\u0002j\u0006\u0015%\u0001\u0002'jgR\f\u0011\u0004\u0013+U!~3uJU,B%\u0012+EiX!E\tJ+5kU#TA\u0005\u0001r-\u001a;Vg\u0016\u0014\u0018\n]!eIJ,7o]\u0001\u001cO\u0016$Xk]3s!J|\u00070\u001f%fC\u0012,'/\u00139BI\u0012\u0014Xm]:\u0002+\u001d,GOR8so\u0006\u0014H-\u001a3BI\u0012\u0014Xm]:fgV\u0011\u0011q\\\u0001\fO\u0016$Xk]3s\u001d\u0006lW-\u0001\thKR\u0004&o\u001c=z+N,'OT1nK\u0006Yq-\u001a;BkRDG+\u001f9f\u0001")
public class AuthenticationFilter
implements Filter,
Logging {
    private final KyuubiConf conf;
    private final HashMap<Enumeration.Value, AuthenticationHandler> authSchemeHandlers;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static String getAuthType() {
        return AuthenticationFilter$.MODULE$.getAuthType();
    }

    public static String getProxyUserName() {
        return AuthenticationFilter$.MODULE$.getProxyUserName();
    }

    public static String getUserName() {
        return AuthenticationFilter$.MODULE$.getUserName();
    }

    public static List<String> getForwardedAddresses() {
        return AuthenticationFilter$.MODULE$.getForwardedAddresses();
    }

    public static String getUserProxyHeaderIpAddress() {
        return AuthenticationFilter$.MODULE$.getUserProxyHeaderIpAddress();
    }

    public static String getUserIpAddress() {
        return AuthenticationFilter$.MODULE$.getUserIpAddress();
    }

    public static ThreadLocal<List<String>> HTTP_FORWARDED_ADDRESSES() {
        return AuthenticationFilter$.MODULE$.HTTP_FORWARDED_ADDRESSES();
    }

    public static ThreadLocal<String> HTTP_CLIENT_PROXY_USER_NAME() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_PROXY_USER_NAME();
    }

    public static ThreadLocal<String> HTTP_AUTH_TYPE() {
        return AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE();
    }

    public static ThreadLocal<String> HTTP_CLIENT_USER_NAME() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME();
    }

    public static ThreadLocal<String> HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS() {
        return AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS();
    }

    public static ThreadLocal<String> HTTP_CLIENT_IP_ADDRESS() {
        return AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public HashMap<Enumeration.Value, AuthenticationHandler> authSchemeHandlers() {
        return this.authSchemeHandlers;
    }

    public void addAuthHandler(AuthenticationHandler authHandler) {
        authHandler.init(this.conf);
        if (authHandler.authenticationSupported()) {
            if (this.authSchemeHandlers().contains((Object)authHandler.authScheme())) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Authentication handler has been defined for scheme ").append(authHandler.authScheme()).toString());
                return;
            }
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Add authentication handler ").append(authHandler.getClass().getSimpleName()).append(" for scheme ").append(authHandler.authScheme()).toString());
            this.authSchemeHandlers().put((Object)authHandler.authScheme(), (Object)authHandler);
            return;
        }
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("The authentication handler ").append(authHandler.getClass().getSimpleName()).append(" for scheme ").append(authHandler.authScheme()).append(" is not supported").toString());
    }

    public void initAuthHandlers() {
        Option basicAuthTypeOpt;
        Seq authTypes = (Seq)((TraversableLike)this.conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName(s), Seq$.MODULE$.canBuildFrom());
        boolean spnegoKerberosEnabled = authTypes.contains((Object)AuthTypes$.MODULE$.KERBEROS());
        Set set = authTypes.toSet();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{AuthTypes$.MODULE$.NOSASL()}));
        Option option = !(set != null ? !set.equals(genTraversable) : genTraversable != null) ? authTypes.headOption() : (basicAuthTypeOpt = ((TraversableLike)((TraversableLike)authTypes.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals((Object)AuthTypes$.MODULE$.KERBEROS())))).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals((Object)AuthTypes$.MODULE$.NOSASL())))).headOption());
        if (spnegoKerberosEnabled) {
            KerberosAuthenticationHandler kerberosHandler = new KerberosAuthenticationHandler();
            this.addAuthHandler(kerberosHandler);
        }
        basicAuthTypeOpt.foreach((Function1 & Serializable & scala.Serializable)basicAuthType -> {
            AuthenticationFilter.$anonfun$initAuthHandlers$4(this, basicAuthType);
            return BoxedUnit.UNIT;
        });
        if (InternalSecurityAccessor$.MODULE$.get() != null) {
            KyuubiInternalAuthenticationHandler internalHandler = new KyuubiInternalAuthenticationHandler();
            this.addAuthHandler(internalHandler);
            return;
        }
    }

    public void init(FilterConfig filterConfig) {
        this.initAuthHandlers();
    }

    public Option<AuthenticationHandler> getMatchedHandler(String authorization) {
        return this.authSchemeHandlers().values().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.matchAuthScheme(authorization)));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authorization = httpRequest.getHeader(HttpAuthUtils$.MODULE$.AUTHORIZATION_HEADER());
        AuthenticationHandler matchedHandler = (AuthenticationHandler)this.getMatchedHandler(authorization).orNull(Predef$.MODULE$.$conforms());
        AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().set(httpRequest.getRemoteAddr());
        AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().set(httpRequest.getHeader((String)this.conf.get(KyuubiConf$.MODULE$.FRONTEND_PROXY_HTTP_CLIENT_IP_HEADER())));
        try {
            try {
                if (matchedHandler == null) {
                    this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("No auth scheme matched for url: ").append(httpRequest.getRequestURL()).toString());
                    httpResponse.setStatus(401);
                    httpResponse.sendError(401, new StringBuilder(27).append("No auth scheme matched for ").append(authorization).toString());
                } else {
                    AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE().set(matchedHandler.authScheme().toString());
                    String authUser = matchedHandler.authenticate(httpRequest, httpResponse);
                    if (authUser != null) {
                        AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME().set(authUser);
                        this.doFilter(filterChain, httpRequest, httpResponse);
                    }
                }
            }
            catch (AuthenticationException e) {
                httpResponse.setStatus(403);
                AuthenticationFilter$.MODULE$.HTTP_CLIENT_USER_NAME().remove();
                AuthenticationFilter$.MODULE$.HTTP_CLIENT_IP_ADDRESS().remove();
                AuthenticationFilter$.MODULE$.HTTP_PROXY_HEADER_CLIENT_IP_ADDRESS().remove();
                AuthenticationFilter$.MODULE$.HTTP_AUTH_TYPE().remove();
                AuthenticationFilter$.MODULE$.HTTP_CLIENT_PROXY_USER_NAME().remove();
                AuthenticationFilter$.MODULE$.HTTP_FORWARDED_ADDRESSES().remove();
                httpResponse.sendError(403, e.getMessage());
            }
        }
        finally {
            AuthenticationAuditLogger$.MODULE$.audit(httpRequest, httpResponse);
        }
    }

    public void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        if (this.authSchemeHandlers().nonEmpty()) {
            this.authSchemeHandlers().values().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.destroy();
                return BoxedUnit.UNIT;
            });
            this.authSchemeHandlers().clear();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$initAuthHandlers$5(AuthenticationFilter $this, String x$3) {
        BasicAuthenticationHandler basicHandler = new BasicAuthenticationHandler(AuthTypes$.MODULE$.CUSTOM());
        $this.addAuthHandler(basicHandler);
    }

    public static final /* synthetic */ void $anonfun$initAuthHandlers$6(AuthenticationFilter $this, String bearerClassName) {
        BearerAuthenticationHandler bearerHandler = new BearerAuthenticationHandler(bearerClassName);
        $this.addAuthHandler(bearerHandler);
    }

    public static final /* synthetic */ void $anonfun$initAuthHandlers$4(AuthenticationFilter $this, Enumeration.Value basicAuthType) {
        if (basicAuthType.equals((Object)AuthTypes$.MODULE$.CUSTOM())) {
            ((Option)$this.conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_CUSTOM_BASIC_CLASS())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                AuthenticationFilter.$anonfun$initAuthHandlers$5($this, x$3);
                return BoxedUnit.UNIT;
            });
            ((Option)$this.conf.get((ConfigEntry)KyuubiConf$.MODULE$.AUTHENTICATION_CUSTOM_BEARER_CLASS())).foreach((Function1 & Serializable & scala.Serializable)bearerClassName -> {
                AuthenticationFilter.$anonfun$initAuthHandlers$6($this, bearerClassName);
                return BoxedUnit.UNIT;
            });
            return;
        }
        BasicAuthenticationHandler basicHandler = new BasicAuthenticationHandler(basicAuthType);
        $this.addAuthHandler(basicHandler);
    }

    public AuthenticationFilter(KyuubiConf conf) {
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.authSchemeHandlers = new HashMap();
    }
}

