/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe;

import java.time.Duration;
import org.apache.kyuubi.shade.dev.failsafe.Policy;
import org.apache.kyuubi.shade.dev.failsafe.TimeoutBuilder;
import org.apache.kyuubi.shade.dev.failsafe.TimeoutConfig;
import org.apache.kyuubi.shade.dev.failsafe.internal.TimeoutImpl;
import org.apache.kyuubi.shade.dev.failsafe.internal.util.Assert;

public interface Timeout<R>
extends Policy<R> {
    public static <R> TimeoutBuilder<R> builder(Duration timeout) {
        Assert.notNull(timeout, "timeout");
        Assert.isTrue(timeout.toNanos() > 0L, "timeout must be > 0", new Object[0]);
        return new TimeoutBuilder(timeout);
    }

    public static <R> TimeoutBuilder<R> builder(TimeoutConfig<R> config) {
        return new TimeoutBuilder<R>(config);
    }

    public static <R> Timeout<R> of(Duration timeout) {
        return new TimeoutImpl(new TimeoutConfig(timeout, false));
    }

    @Override
    public TimeoutConfig<R> getConfig();
}

