/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.kyuubi.jdbc.hive.common.FastHiveDecimal;

public final class HiveDecimal
extends FastHiveDecimal
implements Comparable<HiveDecimal> {
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 38;
    public static final int USER_DEFAULT_PRECISION = 10;
    public static final int USER_DEFAULT_SCALE = 0;
    public static final int SYSTEM_DEFAULT_PRECISION = 38;
    public static final int SYSTEM_DEFAULT_SCALE = 18;
    public static final HiveDecimal ZERO = HiveDecimal.create(0);
    public static final HiveDecimal ONE = HiveDecimal.create(1);
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int SCRATCH_BUFFER_LEN_SERIALIZATION_UTILS_READ = 24;
    public static final int SCRATCH_LONGS_LEN = 6;
    public static final int SCRATCH_BUFFER_LEN_BIG_INTEGER_BYTES = 49;
    public static final int SCRATCH_BUFFER_LEN_TO_BYTES = 79;

    private HiveDecimal() {
    }

    private HiveDecimal(HiveDecimal dec) {
        super(dec);
    }

    private HiveDecimal(FastHiveDecimal fastDec) {
        super(fastDec);
    }

    private HiveDecimal(int fastSignum, FastHiveDecimal fastDec) {
        super(fastSignum, fastDec);
    }

    private HiveDecimal(int fastSignum, long fast0, long fast1, long fast2, int fastIntegerDigitCount, int fastScale) {
        super(fastSignum, fast0, fast1, fast2, fastIntegerDigitCount, fastScale);
    }

    public static HiveDecimal createFromFast(FastHiveDecimal fastDec) {
        return new HiveDecimal(fastDec);
    }

    public static HiveDecimal create(BigDecimal bigDecimal) {
        return HiveDecimal.create(bigDecimal, true);
    }

    public static HiveDecimal create(BigDecimal bigDecimal, boolean allowRounding) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBigDecimal(bigDecimal, allowRounding)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(BigInteger bigInteger) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBigInteger(bigInteger)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(BigInteger bigInteger, int scale) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBigIntegerAndScale(bigInteger, scale)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(String string) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromString(string, true)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(String string, boolean trimBlanks) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromString(string, trimBlanks)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(byte[] bytes) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBytes(bytes, 0, bytes.length, false)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(byte[] bytes, boolean trimBlanks) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBytes(bytes, 0, bytes.length, trimBlanks)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(boolean isNegative, byte[] bytes, int scale) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromDigitsOnlyBytesAndScale(isNegative, bytes, 0, bytes.length, scale)) {
            return null;
        }
        if (isNegative) {
            result.fastNegate();
        }
        return result;
    }

    public static HiveDecimal create(boolean isNegative, byte[] bytes, int offset, int length, int scale) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromDigitsOnlyBytesAndScale(isNegative, bytes, offset, length, scale)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(byte[] bytes, int offset, int length) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBytes(bytes, offset, length, false)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(byte[] bytes, int offset, int length, boolean trimBlanks) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBytes(bytes, offset, length, trimBlanks)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(int intValue) {
        HiveDecimal result = new HiveDecimal();
        result.fastSetFromInt(intValue);
        return result;
    }

    public static HiveDecimal create(long longValue) {
        HiveDecimal result = new HiveDecimal();
        result.fastSetFromLong(longValue);
        return result;
    }

    public static HiveDecimal create(long longValue, int scale) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromLongAndScale(longValue, scale)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(float floatValue) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromFloat(floatValue)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal create(double doubleValue) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromDouble(doubleValue)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal serializationUtilsRead(InputStream inputStream, int scale, byte[] scratchBytes) throws IOException {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSerializationUtilsRead(inputStream, scale, scratchBytes)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal createFromBigIntegerBytesAndScale(byte[] bytes, int scale) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBigIntegerBytesAndScale(bytes, 0, bytes.length, scale)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal createFromBigIntegerBytesAndScale(byte[] bytes, int offset, int length, int scale) {
        HiveDecimal result = new HiveDecimal();
        if (!result.fastSetFromBigIntegerBytesAndScale(bytes, offset, length, scale)) {
            return null;
        }
        return result;
    }

    public boolean serializationUtilsWrite(OutputStream outputStream, long[] scratchLongs) throws IOException {
        return this.fastSerializationUtilsWrite(outputStream, scratchLongs);
    }

    public int bigIntegerBytes(long[] scratchLongs, byte[] buffer) {
        return this.fastBigIntegerBytes(scratchLongs, buffer);
    }

    public byte[] bigIntegerBytes() {
        long[] scratchLongs = new long[6];
        byte[] buffer = new byte[49];
        int byteLength = this.fastBigIntegerBytes(scratchLongs, buffer);
        return Arrays.copyOfRange(buffer, 0, byteLength);
    }

    public int bigIntegerBytesScaled(int serializeScale, long[] scratchLongs, byte[] buffer) {
        return this.fastBigIntegerBytesScaled(serializeScale, scratchLongs, buffer);
    }

    public byte[] bigIntegerBytesScaled(int serializeScale) {
        long[] scratchLongs = new long[6];
        byte[] buffer = new byte[49];
        int byteLength = this.fastBigIntegerBytesScaled(serializeScale, scratchLongs, buffer);
        return Arrays.copyOfRange(buffer, 0, byteLength);
    }

    @Override
    public String toString() {
        if (this.fastSerializationScale() != -1) {
            return this.fastToFormatString(this.fastSerializationScale());
        }
        return this.fastToString();
    }

    public String toString(byte[] scratchBuffer) {
        if (this.fastSerializationScale() != -1) {
            return this.fastToFormatString(this.fastSerializationScale(), scratchBuffer);
        }
        return this.fastToString(scratchBuffer);
    }

    public String toFormatString(int formatScale) {
        return this.fastToFormatString(formatScale);
    }

    public String toFormatString(int formatScale, byte[] scratchBuffer) {
        return this.fastToFormatString(formatScale, scratchBuffer);
    }

    public String toDigitsOnlyString() {
        return this.fastToDigitsOnlyString();
    }

    public int toBytes(byte[] scratchBuffer) {
        return this.fastToBytes(scratchBuffer);
    }

    public int toFormatBytes(int formatScale, byte[] scratchBuffer) {
        return this.fastToFormatBytes(formatScale, scratchBuffer);
    }

    public int toDigitsOnlyBytes(byte[] scratchBuffer) {
        return this.fastToDigitsOnlyBytes(scratchBuffer);
    }

    @Override
    public int compareTo(HiveDecimal dec) {
        return this.fastCompareTo(dec);
    }

    public int newFasterHashCode() {
        return this.fastNewFasterHashCode();
    }

    public int hashCode() {
        return this.fastHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.fastEquals((HiveDecimal)obj);
    }

    public int scale() {
        return this.fastScale();
    }

    public int integerDigitCount() {
        return this.fastIntegerDigitCount();
    }

    public int precision() {
        return this.fastSqlPrecision();
    }

    public int rawPrecision() {
        return this.fastRawPrecision();
    }

    public int signum() {
        return this.fastSignum();
    }

    public boolean isByte() {
        return this.fastIsByte();
    }

    public byte byteValue() {
        return this.fastByteValueClip();
    }

    public boolean isShort() {
        return this.fastIsShort();
    }

    public short shortValue() {
        return this.fastShortValueClip();
    }

    public boolean isInt() {
        return this.fastIsInt();
    }

    public int intValue() {
        return this.fastIntValueClip();
    }

    public boolean isLong() {
        return this.fastIsLong();
    }

    public long longValue() {
        return this.fastLongValueClip();
    }

    public long longValueExact() {
        if (!this.isLong()) {
            throw new ArithmeticException();
        }
        return this.fastLongValueClip();
    }

    public float floatValue() {
        return this.fastFloatValue();
    }

    public double doubleValue() {
        return this.fastDoubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.fastBigDecimalValue();
    }

    public BigInteger unscaledValue() {
        return this.fastBigIntegerValue();
    }

    public HiveDecimal fractionPortion() {
        HiveDecimal result = new HiveDecimal();
        result.fastFractionPortion();
        return result;
    }

    public HiveDecimal integerPortion() {
        HiveDecimal result = new HiveDecimal();
        result.fastIntegerPortion();
        return result;
    }

    public HiveDecimal add(HiveDecimal dec) {
        HiveDecimal result = new HiveDecimal();
        if (!this.fastAdd(dec, result)) {
            return null;
        }
        return result;
    }

    public HiveDecimal subtract(HiveDecimal dec) {
        HiveDecimal result = new HiveDecimal();
        if (!this.fastSubtract(dec, result)) {
            return null;
        }
        return result;
    }

    public HiveDecimal multiply(HiveDecimal dec) {
        HiveDecimal result = new HiveDecimal();
        if (!this.fastMultiply(dec, result)) {
            return null;
        }
        return result;
    }

    public HiveDecimal scaleByPowerOfTen(int power) {
        if (power == 0 || this.fastSignum() == 0) {
            return this;
        }
        HiveDecimal result = new HiveDecimal();
        if (!this.fastScaleByPowerOfTen(power, result)) {
            return null;
        }
        return result;
    }

    public HiveDecimal abs() {
        if (this.fastSignum() != -1) {
            return this;
        }
        HiveDecimal result = new HiveDecimal(this);
        result.fastAbs();
        return result;
    }

    public HiveDecimal negate() {
        if (this.fastSignum() == 0) {
            return this;
        }
        HiveDecimal result = new HiveDecimal(this);
        result.fastNegate();
        return result;
    }

    @Deprecated
    public HiveDecimal setScale(int serializationScale) {
        HiveDecimal result = new HiveDecimal(this);
        result.fastSetSerializationScale(serializationScale);
        return result;
    }

    public HiveDecimal setScale(int roundingPoint, int roundingMode) {
        if (this.fastScale() == roundingPoint) {
            return this;
        }
        HiveDecimal result = new HiveDecimal();
        if (!this.fastRound(roundingPoint, roundingMode, result)) {
            return null;
        }
        return result;
    }

    public HiveDecimal pow(int exponent) {
        HiveDecimal result = new HiveDecimal(this);
        if (!this.fastPow(exponent, result)) {
            return null;
        }
        return result;
    }

    public HiveDecimal divide(HiveDecimal divisor) {
        HiveDecimal result = new HiveDecimal();
        if (!this.fastDivide(divisor, result)) {
            return null;
        }
        return result;
    }

    public HiveDecimal remainder(HiveDecimal divisor) {
        HiveDecimal result = new HiveDecimal();
        if (!this.fastRemainder(divisor, result)) {
            return null;
        }
        return result;
    }

    public static HiveDecimal enforcePrecisionScale(HiveDecimal dec, int maxPrecision, int maxScale) {
        if (maxPrecision < 1 || maxPrecision > 38) {
            throw new IllegalArgumentException("Decimal precision out of allowed range [1,38]");
        }
        if (maxScale < 0 || maxScale > 38) {
            throw new IllegalArgumentException("Decimal scale out of allowed range [0,38]");
        }
        if (maxPrecision < maxScale) {
            throw new IllegalArgumentException("Decimal scale must be less than or equal to precision");
        }
        if (dec == null) {
            return null;
        }
        FastHiveDecimal.FastCheckPrecisionScaleStatus status = dec.fastCheckPrecisionScale(maxPrecision, maxScale);
        switch (status) {
            case NO_CHANGE: {
                return dec;
            }
            case OVERFLOW: {
                return null;
            }
            case UPDATE_SCALE_DOWN: {
                HiveDecimal result = new HiveDecimal();
                if (!dec.fastUpdatePrecisionScale(maxPrecision, maxScale, status, result)) {
                    return null;
                }
                return result;
            }
        }
        throw new RuntimeException("Unknown fast decimal check precision and scale status " + (Object)((Object)status));
    }

    public void validate() {
        if (!this.fastIsValid()) {
            this.fastRaiseInvalidException();
        }
    }
}

