/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HdfsLocatedFileStatus
extends LocatedFileStatus
implements HdfsFileStatus {
    private static final long serialVersionUID = 309245994L;
    private byte[] uPath;
    private byte[] uSymlink;
    private final long fileId;
    private final FileEncryptionInfo feInfo;
    private final ErasureCodingPolicy ecPolicy;
    private final int childrenNum;
    private final byte storagePolicy;
    private transient LocatedBlocks hdfsloc;

    HdfsLocatedFileStatus(long length, boolean isdir, int replication, long blocksize, long mtime, long atime, FsPermission permission, EnumSet<HdfsFileStatus.Flags> flags, String owner, String group, byte[] symlink, byte[] path, long fileId, int childrenNum, FileEncryptionInfo feInfo, byte storagePolicy, ErasureCodingPolicy ecPolicy, LocatedBlocks hdfsloc) {
        super(length, isdir, replication, blocksize, mtime, atime, HdfsFileStatus.convert(isdir, symlink != null, permission, flags), owner, group, null, null, HdfsFileStatus.convert(flags), null);
        this.uSymlink = symlink;
        this.uPath = path;
        this.fileId = fileId;
        this.childrenNum = childrenNum;
        this.feInfo = feInfo;
        this.storagePolicy = storagePolicy;
        this.ecPolicy = ecPolicy;
        this.hdfsloc = hdfsloc;
    }

    @Override
    public void setOwner(String owner) {
        super.setOwner(owner);
    }

    @Override
    public void setGroup(String group) {
        super.setOwner(group);
    }

    @Override
    public boolean isSymlink() {
        return this.uSymlink != null && this.uSymlink.length > 0;
    }

    @Override
    public Path getSymlink() throws IOException {
        if (this.isSymlink()) {
            return new Path(DFSUtilClient.bytes2String(this.getSymlinkInBytes()));
        }
        throw new IOException("Path " + this.getPath() + " is not a symbolic link");
    }

    @Override
    public void setPermission(FsPermission permission) {
        super.setPermission(permission);
    }

    @Override
    public byte[] getLocalNameInBytes() {
        return this.uPath;
    }

    @Override
    public void setSymlink(Path sym) {
        this.uSymlink = DFSUtilClient.string2Bytes(sym.toString());
    }

    @Override
    public byte[] getSymlinkInBytes() {
        return this.uSymlink;
    }

    @Override
    public long getFileId() {
        return this.fileId;
    }

    @Override
    public FileEncryptionInfo getFileEncryptionInfo() {
        return this.feInfo;
    }

    @Override
    public ErasureCodingPolicy getErasureCodingPolicy() {
        return this.ecPolicy;
    }

    @Override
    public int getChildrenNum() {
        return this.childrenNum;
    }

    @Override
    public byte getStoragePolicy() {
        return this.storagePolicy;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public LocatedBlocks getLocatedBlocks() {
        return this.hdfsloc;
    }

    public LocatedFileStatus makeQualifiedLocated(URI defaultUri, Path path) {
        this.makeQualified(defaultUri, path);
        this.setBlockLocations(DFSUtilClient.locatedBlocks2Locations(this.getLocatedBlocks()));
        return this;
    }
}

