/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.project.ui.groups.DirectoryGroup;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.GroupEditPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DirectoryGroupEditPanel
extends GroupEditPanel {
    private final DirectoryGroup g;
    private JButton directoryButton;
    private JTextField folderField;
    private JLabel folderLabel;
    private JTextField nameField;
    private JLabel nameLabel;

    public DirectoryGroupEditPanel(DirectoryGroup g) {
        File d;
        this.g = g;
        this.initComponents();
        DocumentListener l = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DirectoryGroupEditPanel.this.firePropertyChange("ready", null, null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DirectoryGroupEditPanel.this.firePropertyChange("ready", null, null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.nameField.setText(g.getName());
        this.nameField.getDocument().addDocumentListener(l);
        FileObject dir = g.getDirectory();
        if (dir != null && (d = FileUtil.toFile(dir)) != null) {
            this.folderField.setText(d.getAbsolutePath());
        }
        this.folderField.getDocument().addDocumentListener(l);
    }

    @Override
    public void applyChanges() {
        this.g.setName(this.nameField.getText().trim());
        this.updateDirectory();
    }

    private void updateDirectory() {
        String s = this.folderField.getText();
        if (s != null && s.length() > 0) {
            FileObject dir = FileUtil.toFileObject(FileUtil.normalizeFile(new File(s)));
            String path = dir.toURL().toExternalForm();
            Preferences pref = Group.NODE.node(this.g.id);
            pref.put("path", path);
            if (Group.getActiveGroup().equals(this.g)) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        Group.open(DirectoryGroupEditPanel.this.g, null, false, null);
                    }
                });
            }
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.folderLabel = new JLabel();
        this.folderField = new JTextField();
        this.directoryButton = new JButton();
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText(this.nameLabel, NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.nameLabel.text"));
        this.folderLabel.setLabelFor(this.folderField);
        Mnemonics.setLocalizedText(this.folderLabel, NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.folderLabel.text"));
        Mnemonics.setLocalizedText(this.directoryButton, NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.directoryButton.text_2"));
        this.directoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectoryGroupEditPanel.this.directoryButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.folderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameField, -1, 337, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.folderField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderLabel).addComponent(this.folderField, -2, -1, -2).addComponent(this.directoryButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.nameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.nameField.AccessibleContext.accessibleName"));
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.nameField.AccessibleContext.accessibleDescription"));
        this.folderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.folderLabel.AccessibleContext.accessibleDescription"));
        this.folderField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.folderField.AccessibleContext.accessibleName"));
        this.folderField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.folderField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectoryGroupEditPanel.class, "DirectoryGroupEditPanel.AccessibleContext.accessibleDescription"));
    }

    private void directoryButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        File start = ProjectChooser.getProjectsFolder();
        if (this.folderField.getText() != null && this.folderField.getText().trim().length() > 0) {
            start = new File(this.folderField.getText().trim());
        }
        chooser.setCurrentDirectory(start);
        if (chooser.showOpenDialog(this) == 0 && (f = chooser.getSelectedFile()) != null) {
            this.folderField.setText(f.getAbsolutePath());
        }
    }

    @Override
    public boolean isReady() {
        if (!this.doCheckExistingGroups(this.nameField, this.g)) {
            return false;
        }
        String s = this.folderField.getText();
        if (s != null) {
            return new File(s.trim()).isDirectory();
        }
        return false;
    }
}

