// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

use std::sync::Arc;

use http::StatusCode;

use super::core::VercelArtifactsCore;
use super::error::parse_error;
use crate::raw::*;
use crate::*;

pub struct VercelArtifactsWriter {
    core: Arc<VercelArtifactsCore>,
    _op: OpWrite,

    path: String,
}

impl VercelArtifactsWriter {
    pub fn new(core: Arc<VercelArtifactsCore>, op: OpWrite, path: String) -> Self {
        VercelArtifactsWriter {
            core,
            _op: op,
            path,
        }
    }
}

impl oio::OneShotWrite for VercelArtifactsWriter {
    async fn write_once(&self, bs: Buffer) -> Result<Metadata> {
        let response = self
            .core
            .vercel_artifacts_put(self.path.as_str(), bs.len() as u64, bs)
            .await?;

        let status = response.status();

        match status {
            StatusCode::OK | StatusCode::ACCEPTED => Ok(Metadata::default()),
            _ => Err(parse_error(response)),
        }
    }
}
