# Predefined Directives (alphabetically)

|Directive                                                                                                            | Description                                                                                                                                                                                               |
|---------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|@ref[alwaysCache](caching-directives/alwaysCache.md)                                                                 | Wraps its inner Route with caching support using the given @apidoc[Cache] implementation and the in-scope keyer function.                                                                                 |
|@ref[attribute](attribute-directives/attribute.md) | Extracts the value of the request attribute with a given key |
|@ref[authenticateBasic](security-directives/authenticateBasic.md)                                                    | Wraps the inner route with Http Basic authentication support using a given @scala[`Authenticator[T]`]@java[`Authenticator<T>`]                                                                            |
|@ref[authenticateBasicAsync](security-directives/authenticateBasicAsync.md)                                          | Wraps the inner route with Http Basic authentication support using a given @scala[`AsyncAuthenticator[T]`]@java[`AsyncAuthenticator<T>`]                                                                  |
|@ref[authenticateBasicPF](security-directives/authenticateBasicPF.md)                                                | Wraps the inner route with Http Basic authentication support using a given @scala[`AuthenticatorPF[T]`]@java[`AuthenticatorPF<T>`]                                                                        |
|@ref[authenticateBasicPFAsync](security-directives/authenticateBasicPFAsync.md)                                      | Wraps the inner route with Http Basic authentication support using a given @scala[`AsyncAuthenticatorPF[T]`]@java[`AsyncAuthenticatorPF<T>`]                                                              |
|@ref[authenticateOAuth2](security-directives/authenticateOAuth2.md)                                                  | Wraps the inner route with OAuth Bearer Token authentication support using a given @scala[`AuthenticatorPF[T]`]@java[`AuthenticatorPF<T>`]                                                                                                   |
|@ref[authenticateOAuth2Async](security-directives/authenticateOAuth2Async.md)                                        | Wraps the inner route with OAuth Bearer Token authentication support using a given @scala[`AsyncAuthenticator[T]`]@java[`AsyncAuthenticator<T>`]                                                                                                |
|@ref[authenticateOAuth2PF](security-directives/authenticateOAuth2PF.md)                                              | Wraps the inner route with OAuth Bearer Token authentication support using a given @scala[`AuthenticatorPF[T]`]@java[`AuthenticatorPF<T>`]                                                                                                   |
|@ref[authenticateOAuth2PFAsync](security-directives/authenticateOAuth2PFAsync.md)                                    | Wraps the inner route with OAuth Bearer Token authentication support using a given @scala[`AsyncAuthenticatorPF[T]`]@java[`AsyncAuthenticatorPF<T>`]                                                                                              |
|@ref[authenticateOrRejectWithChallenge](security-directives/authenticateOrRejectWithChallenge.md)                    | Lifts an authenticator function into a directive                                                                                                                                                          |
|@ref[authorize](security-directives/authorize.md)                                                                    | Applies the given authorization check to the request                                                                                                                                                      |
|@ref[authorizeAsync](security-directives/authorizeAsync.md)                                                          | Applies the given asynchronous authorization check to the request                                                                                                                                         |
|@ref[cache](caching-directives/cache.md)                                                                             | Wraps its inner Route with caching support using the given @apidoc[Cache] implementation and the in-scope keyer function.                                                             |
|@ref[cachingProhibited](caching-directives/cachingProhibited.md)                                                     | Passes only requests that explicitly forbid caching with a `Cache-Control` header with either a `no-cache` or `max-age=0` setting.                                                                        |
|@ref[cancelRejection](basic-directives/cancelRejection.md)                                                           | Adds a @apidoc[TransformationRejection] cancelling all rejections equal to the given one to the rejections potentially coming back from the inner route.                                                         |
|@ref[cancelRejections](basic-directives/cancelRejections.md)                                                         | Adds a @apidoc[TransformationRejection] cancelling all matching rejections to the rejections potentially coming back from the inner route                                                                        |
|@ref[checkSameOrigin](header-directives/checkSameOrigin.md)                                                          | Checks that the request comes from the same origin                                                                                                                                                        |
|@ref[complete](route-directives/complete.md)                                                                         | Completes the request using the given arguments                                                                                                                                                           |
|@ref[completeOrRecoverWith](future-directives/completeOrRecoverWith.md)                                              | "Unwraps" a @scala[`Future[T]`]@java[`CompletionStage<T>`] and runs the inner route when the future has failed with the error as an extraction of type `Throwable`                                                                           |
|@ref[completeWith](marshalling-directives/completeWith.md)                                                           | Uses the marshaller for a given type to extract a completion function                                                                                                                                     |
|@ref[conditional](cache-condition-directives/conditional.md)                                                         | Wraps its inner route with support for conditional requests as defined by [RFC 7232](https://tools.ietf.org/html/rfc7232)                                                        |
|@ref[cookie](cookie-directives/cookie.md)                                                                            | Extracts the @apidoc[HttpCookie] with the given name                                                                                                                                                             |
|@ref[decodeRequest](coding-directives/decodeRequest.md)                                                              | Decompresses the  request if it is `gzip` or `deflate` compressed                                                                                                                                         |
|@ref[decodeRequestWith](coding-directives/decodeRequestWith.md)                                                      | Decodes the incoming request using one of the given decoders                                                                                                                                              |
|@ref[delete](method-directives/delete.md)                                                                            | Rejects all non-DELETE requests                                                                                                                                                                           |
|@ref[deleteCookie](cookie-directives/deleteCookie.md)                                                                | Adds a `Set-Cookie` response header expiring the given cookies                                                                                                                                            |
|@ref[encodeResponse](coding-directives/encodeResponse.md)                                                            | Encodes the response with the encoding that is requested by the client via the `Accept-Encoding` header (`NoCoding`, `Gzip` and `Deflate`)                                                                |
|@ref[encodeResponseWith](coding-directives/encodeResponseWith.md)                                                    | Encodes the response with the encoding that is requested by the client via the `Accept-Encoding` header (from a user-defined set)                                                                         |
|@ref[entity](marshalling-directives/entity.md)                                                                       | Extracts the request entity unmarshalled to a given type                                                                                                                                                  |
|@ref[extract](basic-directives/extract.md)                                                                           | Extracts a single value using a @scala[`RequestContext => T`]@java[`Function<RequestContext, T>`] function                                                                                                                                             |
|@scala[@ref[extractDataBytes](basic-directives/extractDataBytes.md)]                                                         | @scala[Extracts the entities data bytes as a stream @apidoc[Source[ByteString, \_]]]                                                                                                                                   |
|@ref[extractClientIP](misc-directives/extractClientIP.md)                                                            | Extracts the client's IP from either the `X-Forwarded-` or `X-Real-IP` header                                                                                                           |
|@ref[extractCredentials](security-directives/extractCredentials.md)                                                  | Extracts the potentially present @apidoc[HttpCredentials] provided with the request's @apidoc[Authorization] header                                                                                                     |
|@ref[extractExecutionContext](basic-directives/extractExecutionContext.md)                                           | Extracts the `ExecutionContext` from the @apidoc[RequestContext]                                                                                                                                                 |
|@ref[extractMatchedPath](basic-directives/extractMatchedPath.md)                                                     | Extracts the already matched path from the @apidoc[RequestContext]                                                                                                                                               |
|@ref[extractMaterializer](basic-directives/extractMaterializer.md)                                                   | Extracts the @apidoc[Materializer] from the @apidoc[RequestContext]                                                                                                                                                     |
|@ref[extractHost](host-directives/extractHost.md)                                                                    | Extracts the hostname part of the Host request header value                                                                                                                                               |
|@ref[extractLog](basic-directives/extractLog.md)                                                                     | Extracts the @apidoc[LoggingAdapter] from the @apidoc[RequestContext]                                                                                                                                                   |
|@ref[extractMethod](method-directives/extractMethod.md)                                                              | Extracts the request method                                                                                                                                                                               |
|@ref[extractOfferedWsProtocols](websocket-directives/extractOfferedWsProtocols.md)                                   | Extract the list of websocket subprotocols offered by the client in the `Sec-WebSocket-Protocol` header if this is a websocket request and otherwise rejects with an @apidoc[ExpectedWebSocketRequestRejection$]  |
|@ref[extractParserSettings](basic-directives/extractParserSettings.md)                                               | Extracts the @apidoc[ParserSettings] from the @apidoc[RequestContext]                                                                                                                                                   |
|@ref[extractRequest](basic-directives/extractRequest.md)                                                             | Extracts the current @apidoc[HttpRequest] instance                                                                                                                                                               |
|@ref[extractRequestContext](basic-directives/extractRequestContext.md)                                               | Extracts the @apidoc[RequestContext] itself                                                                                                                                                                      |
|@scala[@ref[extractRequestEntity](basic-directives/extractRequestEntity.md)]                                                 | @scala[Extracts the @apidoc[RequestEntity] from the @apidoc[RequestContext]]                                                                                                                                                    |
|@ref[extractScheme](scheme-directives/extractScheme.md)                                                              | Extracts the URI scheme from the request                                                                                                                                                                  |
|@ref[extractSettings](basic-directives/extractSettings.md)                                                           | Extracts the @apidoc[RoutingSettings] from the @apidoc[RequestContext]                                                                                                                                                  |
|@ref[extractUnmatchedPath](basic-directives/extractUnmatchedPath.md)                                                 | Extracts the yet unmatched path from the @apidoc[RequestContext]                                                                                                                                                 |                                                                                   |
|@ref[extractUri](basic-directives/extractUri.md)                                                                     | Extracts the complete request URI                                                                                                                                                                         |
|@ref[failWith](route-directives/failWith.md)                                                                         | Bubbles the given error up the response chain where it is dealt with by the closest @ref[handleExceptions](execution-directives/handleExceptions.md) directive and its @apidoc[ExceptionHandler]                 |
|@ref[fileUpload](file-upload-directives/fileUpload.md)                                                               | Provides a stream of an uploaded file from a multipart request                                                                                                                                            |
|@ref[fileUploadAll](file-upload-directives/fileUploadAll.md)                                                         | Provides streams of all uploaded files from a multipart request                                                                                                                                           |
|@ref[formField](form-field-directives/formField.md)                                                                  | Extracts an HTTP form field (of Content-Type `application/x-www-form-urlencoded` or `multipart/form-data`) from the request                                                                                                                                |
|@ref[formFieldMap](form-field-directives/formFieldMap.md)                                                            | Extracts a number of HTTP form field (of Content-Type `application/x-www-form-urlencoded` or `multipart/form-data`) from the request as a @scala[`Map[String, String]`]@java[`Map<String, String>`]                                                                                                                          |
|@ref[formFieldMultiMap](form-field-directives/formFieldMultiMap.md)                                                  | Extracts a number of HTTP form field (of Content-Type `application/x-www-form-urlencoded` or `multipart/form-data`) from the request as a @scala[`Map[String, List[String]]`]@java[`Map<String, List<String>>`]                                                                                                                     |
|@scala[@ref[formFields](form-field-directives/formFields.md)]                                                                | @scala[Extracts a number of HTTP form field (of Content-Type `application/x-www-form-urlencoded` or `multipart/form-data`) from the request]                                                                                                                                                     |
|@ref[formFieldSeq](form-field-directives/formFieldSeq.md)                                                            | Extracts a number of HTTP form field (of Content-Type `application/x-www-form-urlencoded` or `multipart/form-data`) from the request as a @scala[`Seq[(String, String)]`]@java[`List<Map.Entry<String, String>>`]                                                                                                                        |
|@ref[get](method-directives/get.md)                                                                                  | Rejects all non-GET requests                                                                                                                                                                              |
|@ref[getFromBrowseableDirectories](file-and-resource-directives/getFromBrowseableDirectories.md)                     | Serves the content of the given directories as a file-system browser, i.e. files are sent and directories served as browseable listings                                                                   |
|@ref[getFromBrowseableDirectory](file-and-resource-directives/getFromBrowseableDirectory.md)                         | Serves the content of the given directory as a file-system browser, i.e. files are sent and directories served as browseable listings                                                                     |
|@ref[getFromDirectory](file-and-resource-directives/getFromDirectory.md)                                             | Completes GET requests with the content of a file underneath a given file-system directory                                                                                                                |
|@ref[getFromFile](file-and-resource-directives/getFromFile.md)                                                       | Completes GET requests with the content of a given file                                                                                                                                                   |
|@ref[getFromResource](file-and-resource-directives/getFromResource.md)                                               | Completes GET requests with the content of a given class-path resource                                                                                                                                    |
|@ref[getFromResourceDirectory](file-and-resource-directives/getFromResourceDirectory.md)                             | Completes GET requests with the content of a file underneath a given "class-path resource directory"                                                                                                      |
|@ref[handleExceptions](execution-directives/handleExceptions.md)                                                     | Transforms exceptions thrown during evaluation of the inner route using the given @apidoc[ExceptionHandler]                                                                                                      |
|@ref[handleRejections](execution-directives/handleRejections.md)                                                     | Transforms rejections produced by the inner route using the given `RejectionHandler`                                                                                                                      |
|@ref[handleWebSocketMessages](websocket-directives/handleWebSocketMessages.md)                                       | Handles websocket requests with the given handler and rejects other requests with an @apidoc[ExpectedWebSocketRequestRejection$]                                                                                  |
|@ref[handleWebSocketMessagesForOptionalProtocol](websocket-directives/handleWebSocketMessagesForOptionalProtocol.md) | Handles websocket requests with the given handler if the subprotocol matches and rejects other requests. If the subprotocol parameter is @scala[`None`]@java[empty] any WebSocket request is accepted..                       |
|@ref[handleWebSocketMessagesForProtocol](websocket-directives/handleWebSocketMessagesForProtocol.md)                 | Handles websocket requests with the given handler if the subprotocol matches and rejects other requests with an @apidoc[ExpectedWebSocketRequestRejection$] or an @apidoc[UnsupportedWebSocketSubprotocolRejection].     |
|@ref[handleWith](marshalling-directives/handleWith.md)                                                               | Completes the request using a given function                                                                                                                                                              |
|@ref[head](method-directives/head.md)                                                                                | Rejects all non-HEAD requests                                                                                                                                                                             |
|@ref[headerValue](header-directives/headerValue.md)                                                                  | Extracts an HTTP header value using a given @scala[`HttpHeader => Option[T]`]@java[`Function<HttpHeader, Optional<T>>`] function                                                                                                                             |
|@ref[headerValueByName](header-directives/headerValueByName.md)                                                      | Extracts the value of the first HTTP request header with a given name                                                                                                                                     |
|@ref[headerValueByType](header-directives/headerValueByType.md)                                                      | Extracts the first HTTP request header of the given type                                                                                                                                                  |
|@ref[headerValuePF](header-directives/headerValuePF.md)                                                              | Extracts an HTTP header value using a given @scala[`PartialFunction[HttpHeader, T]]`]@java[`PartialFunction<HttpHeader, T>`]                                                                                                                             |
|@ref[host](host-directives/host.md)                                                                                  | Rejects all requests with a non-matching host name                                                                                                                                                        |
|@ref[ignoreTrailingSlash](path-directives/ignoreTrailingSlash.md)                                                    | Retries the inner route adding (or removing) the trailing slash in case of empty rejections                                                                                                               |
|@ref[listDirectoryContents](file-and-resource-directives/listDirectoryContents.md)                                   | Completes GET requests with a unified listing of the contents of all given file-system directories                                                                                                        |
|@ref[logRequest](debugging-directives/logRequest.md)                                                                 | Produces a log entry for every incoming request                                                                                                                                                           |
|@ref[logRequestResult](debugging-directives/logRequestResult.md)                                                     | Produces a log entry for every incoming request and @apidoc[RouteResult]                                                                                                                                         |
|@ref[logResult](debugging-directives/logResult.md)                                                                   | Produces a log entry for every @apidoc[RouteResult]                                                                                                                                                              |
|@ref[mapInnerRoute](basic-directives/mapInnerRoute.md)                                                               | Transforms its inner @scala[@scaladoc[Route](org.apache.pekko.http.scaladsl.server.index#Route=org.apache.pekko.http.scaladsl.server.RequestContext=%3Escala.concurrent.Future[org.apache.pekko.http.scaladsl.server.RouteResult])]@java[@javadoc[Route](org.apache.pekko.http.javadsl.server.Route)] with a @scala[`Route => Route`]@java[`UnaryOperator<Route>`] function                                                                                                                                             |
|@ref[mapRejections](basic-directives/mapRejections.md)                                                               | Transforms rejections from a previous route with an @scala[`immutable.Seq[Rejection] => immutable.Seq[Rejection]`]@java[`UnaryOperator<List<Rejection>>`] function                                                                                        |
|@ref[mapRequest](basic-directives/mapRequest.md)                                                                     | Transforms the request with an @scala[`HttpRequest => HttpRequest`]@java[`UnaryOperator<HttpRequest>`] function                                                                                                                                      |
|@ref[mapRequestContext](basic-directives/mapRequestContext.md)                                                       | Transforms the @apidoc[RequestContext] with a @scala[`RequestContext => RequestContext`]@java[`UnaryOperator<RequestContext>`] function                                                                                                                        |
|@ref[mapResponse](basic-directives/mapResponse.md)                                                                   | Transforms the response with an @scala[`HttpResponse => HttpResponse`]@java[`UnaryOperator<HttpResponse>`] function                                                                                                                                   |
|@ref[mapResponseEntity](basic-directives/mapResponseEntity.md)                                                       | Transforms the response entity with an @scala[`ResponseEntity => ResponseEntity`]@java[`UnaryOperator<ResponseEntity>`] function                                                                                                                         |
|@ref[mapResponseHeaders](basic-directives/mapResponseHeaders.md)                                                     | Transforms the response headers with an @scala[`immutable.Seq[HttpHeader] => immutable.Seq[HttpHeader]`]@java[`UnaryOperator<List<HttpHeader>>`] function                                                                                                  |
|@ref[mapRouteResult](basic-directives/mapRouteResult.md)                                                             | Transforms the @apidoc[RouteResult] with a @scala[`RouteResult => RouteResult`]@java[`UnaryOperator<RouteResult>`] function                                                                                                                                  |
|@ref[mapRouteResultFuture](basic-directives/mapRouteResultFuture.md)                                                 | Transforms the @apidoc[RouteResult] future with a @scala[`Future[RouteResult] => Future[RouteResult]`]@java[`UnaryOperator<CompletionStage<RouteResult>>`] function                                                                                                           |
|@ref[mapRouteResultPF](basic-directives/mapRouteResultPF.md)                                                         | Transforms the @apidoc[RouteResult] with a @scala[`PartialFunction[RouteResult, RouteResult]`]@java[`PartialFunction<RouteResult, RouteResult>`]                                                                                                                           |
|@ref[mapRouteResultWith](basic-directives/mapRouteResultWith.md)                                                     | Transforms the @apidoc[RouteResult] with a @scala[`RouteResult => Future[RouteResult]`]@java[`Function<RouteResult, CompletionStage<RouteResult>>`] function                                                                                                                          |
|@ref[mapRouteResultWithPF](basic-directives/mapRouteResultWithPF.md)                                                 | Transforms the @apidoc[RouteResult] with a @scala[`PartialFunction[RouteResult, Future[RouteResult]]`]@java[`PartialFunction<RouteResult, CompletionStage<RouteResult>>`]                                                                                                                   |
|@ref[mapSettings](basic-directives/mapSettings.md)                                                                   | Transforms the @apidoc[RoutingSettings] with a @scala[`RoutingSettings => RoutingSettings`]@java[`UnaryOperator<RoutingSettings>`] function                                                                                                                      |
|@ref[mapUnmatchedPath](basic-directives/mapUnmatchedPath.md)                                                         | Transforms the `unmatchedPath` of the @apidoc[RequestContext] using a @scala[`Uri.Path => Uri.Path`]@java[`UnaryOperator<Uri.Path>`] function                                                                                                             |
|@ref[method](method-directives/method.md)                                                                            | Rejects all requests whose HTTP method does not match the given one                                                                                                                                       |
|@ref[onComplete](future-directives/onComplete.md)                                                                    | "Unwraps" a @scala[`Future[T]`]@java[`CompletionStage<T>`] and runs the inner route after future completion with the future's value as an extraction of type @scala[`Try[T]`]@java[`Try<T>`]                                                                        |
|@ref[onCompleteWithBreaker](future-directives/onCompleteWithBreaker.md)                                              | "Unwraps" a @scala[`Future[T]`]@java[`CompletionStage<T>`] inside a @apidoc[CircuitBreaker] and runs the inner route after future completion with the future's value as an extraction of type @scala[`Try[T]`]@java[`Try<T>`]                                              |
|@ref[onSuccess](future-directives/onSuccess.md)                                                                      | "Unwraps" a @scala[`Future[T]`]@java[`CompletionStage<T>`] and runs the inner route after future completion with the future's value as an extraction of type `T`                                                                             |
|@ref[optionalAttribute](attribute-directives/optionalAttribute.md) | Extracts the value of an optional request attribute with a given key |
|@ref[optionalCookie](cookie-directives/optionalCookie.md)                                                            | Extracts the @apidoc[HttpCookiePair] with the given name as an @scala[`Option[HttpCookiePair]`]@java[`Optional<HttpCookiePair>`]                                                                                                                          |
|@ref[optionalHeaderValue](header-directives/optionalHeaderValue.md)                                                  | Extracts an optional HTTP header value using a given @scala[`HttpHeader => Option[T]`]@java[`Function<HttpHeader, Optional<T>>`] function                                                                                                                    |
|@ref[optionalHeaderValueByName](header-directives/optionalHeaderValueByName.md)                                      | Extracts the value of the first optional HTTP request header with a given name                                                                                                                            |
|@ref[optionalHeaderValueByType](header-directives/optionalHeaderValueByType.md)                                      | Extracts the first optional HTTP request header of the given type                                                                                                                                         |
|@ref[optionalHeaderValuePF](header-directives/optionalHeaderValuePF.md)                                              | Extracts an optional HTTP header value using a given @scala[`PartialFunction[HttpHeader, T]`]@java[`PartialFunction<HttpHeader, T>`]                                                                                                                     |
|@ref[options](method-directives/options.md)                                                                          | Rejects all non-OPTIONS requests                                                                                                                                                                          |
|@ref[overrideMethodWithParameter](method-directives/overrideMethodWithParameter.md)                                  | Changes the request method to the value of the specified query parameter                                                                                                                                  |
|@ref[parameter](parameter-directives/parameter.md)                                                                   | Extracts a query parameter value from the request                                                                                                                                                         |
|@ref[parameterMap](parameter-directives/parameterMap.md)                                                             | Extracts the request's query parameters as a @scala[`Map[String, String]`]@java[`Map<String, String>`]                                                                                                                                        |
|@ref[parameterMultiMap](parameter-directives/parameterMultiMap.md)                                                   | Extracts the request's query parameters as a @scala[`Map[String, List[String]]`]@java[`Map<String, List<String>>`]                                                                                                                                  |
|@scala[@ref[parameters](parameter-directives/parameters.md)]                                                                 | @scala[Extracts a number of query parameter values from the request]                                                                                                                                              |
|@ref[parameterSeq](parameter-directives/parameterSeq.md)                                                             | Extracts the request's query parameters as a @scala[`Seq[(String, String)]`]@java[`List<Map.Entry<String, String>>`]                                                                                                                                      |
|@ref[pass](basic-directives/pass.md)                                                                                 | Always simply passes the request on to its inner route, i.e. doesn't do anything, neither with the request nor the response                                                                               |
|@ref[patch](method-directives/patch.md)                                                                              | Rejects all non-PATCH requests                                                                                                                                                                            |
|@ref[path](path-directives/path.md)                                                                                  | Applies the given `PathMatcher` to the remaining unmatched path after consuming a leading slash                                                                                                           |
|@ref[pathEnd](path-directives/pathEnd.md)                                                                            | Only passes on the request to its inner route if the request path has been matched completely                                                                                                             |
|@ref[pathEndOrSingleSlash](path-directives/pathEndOrSingleSlash.md)                                                  | Only passes on the request to its inner route if the request path has been matched completely or only consists of exactly one remaining slash                                                             |
|@ref[pathPrefix](path-directives/pathPrefix.md)                                                                      | Applies the given `PathMatcher` to a prefix of the remaining unmatched path after consuming a leading slash                                                                                               |
|@ref[pathPrefixTest](path-directives/pathPrefixTest.md)                                                              | Checks whether the unmatchedPath has a prefix matched by the given `PathMatcher` after implicitly consuming a leading slash                                                                               |
|@ref[pathSingleSlash](path-directives/pathSingleSlash.md)                                                            | Only passes on the request to its inner route if the request path consists of exactly one remaining slash                                                                                                 |
|@ref[pathSuffix](path-directives/pathSuffix.md)                                                                      | Applies the given `PathMatcher` to a suffix of the remaining unmatched path (Caution: check @scala[scaladoc]@java[java]!)                                                                                                    |
|@ref[pathSuffixTest](path-directives/pathSuffixTest.md)                                                              | Checks whether the unmatched path has a suffix matched by the given `PathMatcher` (Caution: check @scala[scaladoc]@java[java]!)                                                                                              |
|@ref[post](method-directives/post.md)                                                                                | Rejects all non-POST requests                                                                                                                                                                             |
|@ref[provide](basic-directives/provide.md)                                                                           | Injects a given value into a directive                                                                                                                                                                    |
|@ref[put](method-directives/put.md)                                                                                  | Rejects all non-PUT requests                                                                                                                                                                              |
|@ref[rawPathPrefix](path-directives/rawPathPrefix.md)                                                                | Applies the given matcher directly to a prefix of the unmatched path of the @apidoc[RequestContext], without implicitly consuming a leading slash                                                                |
|@ref[rawPathPrefixTest](path-directives/rawPathPrefixTest.md)                                                        | Checks whether the unmatchedPath has a prefix matched by the given `PathMatcher`                                                                                                                          |
|@ref[recoverRejections](basic-directives/recoverRejections.md)                                                       | Transforms rejections from the inner route with an @scala[`immutable.Seq[Rejection] => RouteResult`]@java[`Function<List<Rejection>, RouteResult>`] function                                                                                                      |
|@ref[recoverRejectionsWith](basic-directives/recoverRejectionsWith.md)                                               | Transforms rejections from the inner route with an @scala[`immutable.Seq[Rejection] => Future[RouteResult]`]@java[`Function<List<Rejection], CompletionStage<RouteResult>>`] function                                                                                              |
|@ref[redirect](route-directives/redirect.md)                                                                         | Completes the request with redirection response of the given type to the given URI                                                                                                                        |
|@ref[redirectToNoTrailingSlashIfPresent](path-directives/redirectToNoTrailingSlashIfPresent.md)                      | If the request path ends with a slash, redirects to the same URI without trailing slash in the path                                                                                                       |
|@ref[redirectToTrailingSlashIfMissing](path-directives/redirectToTrailingSlashIfMissing.md)                          | If the request path doesn't end with a slash, redirects to the same URI with trailing slash in the path                                                                                                   |
|@ref[reject](route-directives/reject.md)                                                                             | Rejects the request with the given rejections                                                                                                                                                             |
|@ref[rejectEmptyResponse](misc-directives/rejectEmptyResponse.md)                                                    | Converts responses with an empty entity into (empty) rejections                                                                                                                                           |
|@ref[requestEncodedWith](coding-directives/requestEncodedWith.md)                                                    | Rejects the request with an @apidoc[UnsupportedRequestEncodingRejection] if its encoding doesn't match the given one                                                                                             |
|@ref[requestEntityEmpty](misc-directives/requestEntityEmpty.md)                                                      | Rejects if the request entity is non-empty                                                                                                                                                                |
|@ref[requestEntityPresent](misc-directives/requestEntityPresent.md)                                                  | Rejects with a @apidoc[RequestEntityExpectedRejection$] if the request entity is empty                                                                                                                            |
|@ref[respondWithDefaultHeader](respond-with-directives/respondWithDefaultHeader.md)                                  | Adds a given response header if the response doesn't already contain a header with the same name                                                                                                          |
|@ref[respondWithDefaultHeaders](respond-with-directives/respondWithDefaultHeaders.md)                                | Adds the subset of the given headers to the response which doesn't already have a header with the respective name present in the response                                                                 |
|@ref[respondWithHeader](respond-with-directives/respondWithHeader.md)                                                | Unconditionally adds a given header to the outgoing response                                                                                                                                              |
|@ref[respondWithHeaders](respond-with-directives/respondWithHeaders.md)                                              | Unconditionally adds the given headers to the outgoing response                                                                                                                                           |
|@ref[responseEncodingAccepted](coding-directives/responseEncodingAccepted.md)                                        | Rejects the request with an @apidoc[UnacceptedResponseEncodingRejection] if the given response encoding is not accepted by the client                                                                            |
|@ref[scheme](scheme-directives/scheme.md)                                                                            | Rejects all requests whose URI scheme doesn't match the given one                                                                                                                                         |
|@ref[selectPreferredLanguage](misc-directives/selectPreferredLanguage.md)                                            | Inspects the request's `Accept-Language` header and determines, which of a given set of language alternatives is preferred by the client                                                                  |
|@ref[setCookie](cookie-directives/setCookie.md)                                                                      | Adds a `Set-Cookie` response header with the given cookies                                                                                                                                                |
|@ref[storeUploadedFile](file-upload-directives/storeUploadedFile.md)                                                 | Streams one uploaded file from a multipart request to a file on disk                                                                                                                                      |
|@ref[storeUploadedFiles](file-upload-directives/storeUploadedFiles.md)                                               | Streams all uploaded files from a multipart request to files on disk                                                                                                                                      |
|@scala[@ref[textract](basic-directives/textract.md)]                                                                         | @scala[Extracts a number of values using a `RequestContext => Tuple` function]                                                                                                                                     |
|@scala[@ref[tprovide](basic-directives/tprovide.md)]                                                                         | @scala[Injects a given tuple of values into a directive]                                                                                                                                                          |
|@ref[validate](misc-directives/validate.md)                                                                          | Checks a given condition before running its inner route                                                                                                                                                   |
|@ref[withoutRequestTimeout](timeout-directives/withoutRequestTimeout.md)                                             | Disables @ref[request timeouts](../../common/timeouts.md#request-timeout) for a given route.                                                                                                              |
|@ref[withoutSizeLimit](misc-directives/withoutSizeLimit.md)                                                          | Skips request entity size check                                                                                                                                                                           |
|@ref[withExecutionContext](basic-directives/withExecutionContext.md)                                                 | Runs its inner route with the given alternative `ExecutionContext`                                                                                                                                        |
|@ref[withLog](basic-directives/withLog.md)                                                                           | Runs its inner route with the given alternative @apidoc[LoggingAdapter]                                                                                                                                          |
|@ref[withMaterializer](basic-directives/withMaterializer.md)                                                         | Runs its inner route with the given alternative @apidoc[Materializer]                                                                                                                                            |
|@ref[withPrecompressedMediaTypeSupport](coding-directives/withPrecompressedMediaTypeSupport.md)                      | Adds a `Content-Encoding: gzip` response header if the entity's media-type is precompressed with gzip header                                                                                              |
|@ref[withRangeSupport](range-directives/withRangeSupport.md)                                                         | Adds `Accept-Ranges: bytes` to responses to GET requests, produces partial responses if the initial request contained a valid `Range` header                                                              |
|@ref[withRequestTimeout](timeout-directives/withRequestTimeout.md)                                                   | Configures the @ref[request timeouts](../../common/timeouts.md#request-timeout) for a given route.                                                                                                        |
|@ref[withRequestTimeoutResponse](timeout-directives/withRequestTimeoutResponse.md)                                   | Prepares the @apidoc[HttpResponse] that is emitted if a request timeout is triggered. `RequestContext => RequestContext` function                                                                                |
|@ref[withSettings](basic-directives/withSettings.md)                                                                 | Runs its inner route with the given alternative @apidoc[RoutingSettings]                                                                                                                                         |
|@ref[withSizeLimit](misc-directives/withSizeLimit.md)                                                                | Applies request entity size check                                                                                                                                                                         |
