/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;

final class AwsDates {
    private static final String X_AMZ_DATE_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    private static final String HTTP_DATE_FORMAT = "E, dd MMM yyyy HH:mm:ss z";
    private final String xAmzDate;
    private final String originalDate;

    private AwsDates(String amzDate) {
        this.xAmzDate = Preconditions.checkNotNull(amzDate);
        this.originalDate = amzDate;
    }

    private AwsDates(String xAmzDate, String originalDate) {
        this.xAmzDate = Preconditions.checkNotNull(xAmzDate);
        this.originalDate = Preconditions.checkNotNull(originalDate);
    }

    String getOriginalDate() {
        return this.originalDate;
    }

    String getXAmzDate() {
        return this.xAmzDate;
    }

    String getFormattedDate() {
        return this.xAmzDate.substring(0, 8);
    }

    static AwsDates fromXAmzDate(String xAmzDate) throws ParseException {
        new SimpleDateFormat(X_AMZ_DATE_FORMAT).parse(xAmzDate);
        return new AwsDates(xAmzDate);
    }

    static AwsDates fromDateHeader(String date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(X_AMZ_DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date inputDate = new SimpleDateFormat(HTTP_DATE_FORMAT).parse(date);
        String xAmzDate = dateFormat.format(inputDate);
        return new AwsDates(xAmzDate, date);
    }

    static AwsDates generateXAmzDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(X_AMZ_DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String xAmzDate = dateFormat.format(new Date(System.currentTimeMillis()));
        return new AwsDates(xAmzDate);
    }
}

