/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.m3ql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pinot.shaded.com.google.common.base.Preconditions;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.tsdb.m3ql.PlanIdGenerator;
import org.apache.pinot.tsdb.m3ql.parser.Tokenizer;
import org.apache.pinot.tsdb.m3ql.plan.KeepLastValuePlanNode;
import org.apache.pinot.tsdb.m3ql.plan.TransformNullPlanNode;
import org.apache.pinot.tsdb.m3ql.time.TimeBucketComputer;
import org.apache.pinot.tsdb.spi.AggInfo;
import org.apache.pinot.tsdb.spi.RangeTimeSeriesRequest;
import org.apache.pinot.tsdb.spi.TimeBuckets;
import org.apache.pinot.tsdb.spi.TimeSeriesLogicalPlanResult;
import org.apache.pinot.tsdb.spi.TimeSeriesLogicalPlanner;
import org.apache.pinot.tsdb.spi.TimeSeriesMetadata;
import org.apache.pinot.tsdb.spi.plan.BaseTimeSeriesPlanNode;
import org.apache.pinot.tsdb.spi.plan.LeafTimeSeriesPlanNode;

public class M3TimeSeriesPlanner
implements TimeSeriesLogicalPlanner {
    public void init(PinotConfiguration pinotConfiguration) {
    }

    public TimeSeriesLogicalPlanResult plan(RangeTimeSeriesRequest request, TimeSeriesMetadata metadata) {
        if (!request.getLanguage().equals("m3ql")) {
            throw new IllegalArgumentException(String.format("Invalid engine id: %s. Expected: %s", request.getLanguage(), "m3ql"));
        }
        BaseTimeSeriesPlanNode planNode = this.planQuery(request);
        TimeBuckets timeBuckets = TimeBucketComputer.compute(planNode, request);
        return new TimeSeriesLogicalPlanResult(planNode, timeBuckets);
    }

    public BaseTimeSeriesPlanNode planQuery(RangeTimeSeriesRequest request) {
        PlanIdGenerator planIdGenerator = new PlanIdGenerator();
        Tokenizer tokenizer = new Tokenizer(request.getQuery());
        List<List<String>> commands = tokenizer.tokenize();
        Preconditions.checkState(commands.size() > 1, "At least two commands required. Query should start with a fetch followed by an aggregation.");
        KeepLastValuePlanNode lastNode = null;
        AggInfo aggInfo = null;
        List<String> groupByColumns = new ArrayList<String>();
        KeepLastValuePlanNode rootNode = null;
        for (int commandId = commands.size() - 1; commandId >= 0; --commandId) {
            String command = commands.get(commandId).get(0);
            Preconditions.checkState(command.equals("fetch") && commandId == 0 || !command.equals("fetch") && commandId > 0, "fetch should be the first command");
            ArrayList<BaseTimeSeriesPlanNode> children = new ArrayList<BaseTimeSeriesPlanNode>();
            BaseTimeSeriesPlanNode currentNode = null;
            switch (command) {
                case "fetch": {
                    List<String> tokens = commands.get(commandId).subList(1, commands.get(commandId).size());
                    currentNode = this.handleFetchNode(planIdGenerator.generateId(), tokens, children, aggInfo, groupByColumns, request);
                    break;
                }
                case "sum": 
                case "min": 
                case "max": {
                    Preconditions.checkState(commandId == 1, "Aggregation should be the second command (fetch should be first)");
                    Preconditions.checkState(aggInfo == null, "Aggregation already set. Only single agg allowed.");
                    aggInfo = new AggInfo(command.toUpperCase(Locale.ENGLISH), false, Collections.emptyMap());
                    if (commands.get(commandId).size() <= 1) break;
                    String[] cols = commands.get(commandId).get(1).split(",");
                    groupByColumns = Stream.of(cols).map(String::trim).collect(Collectors.toList());
                    break;
                }
                case "keepLastValue": {
                    currentNode = new KeepLastValuePlanNode(planIdGenerator.generateId(), children);
                    break;
                }
                case "transformNull": {
                    Double defaultValue = TransformNullPlanNode.DEFAULT_VALUE;
                    if (commands.get(commandId).size() > 1) {
                        defaultValue = Double.parseDouble(commands.get(commandId).get(1));
                    }
                    currentNode = new TransformNullPlanNode(planIdGenerator.generateId(), defaultValue, children);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown function: " + command);
                }
            }
            if (currentNode == null) continue;
            if (rootNode == null) {
                rootNode = currentNode;
            }
            if (lastNode != null) {
                lastNode.addInputNode(currentNode);
            }
            lastNode = currentNode;
        }
        return rootNode;
    }

    public BaseTimeSeriesPlanNode handleFetchNode(String planId, List<String> tokens, List<BaseTimeSeriesPlanNode> children, AggInfo aggInfo, List<String> groupByColumns, RangeTimeSeriesRequest request) {
        Preconditions.checkState(tokens.size() % 2 == 0, "Mismatched args");
        String tableName = null;
        String timeColumn = null;
        TimeUnit timeUnit = null;
        String filter = "";
        String valueExpr = null;
        block14: for (int idx = 0; idx < tokens.size(); idx += 2) {
            String key = tokens.get(idx);
            String value = tokens.get(idx + 1);
            switch (key) {
                case "table": {
                    tableName = value.replaceAll("\"", "");
                    continue block14;
                }
                case "ts_column": {
                    timeColumn = value.replaceAll("\"", "");
                    continue block14;
                }
                case "ts_unit": {
                    timeUnit = TimeUnit.valueOf(value.replaceAll("\"", "").toUpperCase(Locale.ENGLISH));
                    continue block14;
                }
                case "filter": {
                    filter = value.replaceAll("\"", "");
                    continue block14;
                }
                case "value": {
                    valueExpr = value.replaceAll("\"", "");
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("Unknown key: " + key);
                }
            }
        }
        Preconditions.checkNotNull(tableName, "Table name not set. Set via table=");
        Preconditions.checkNotNull(timeColumn, "Time column not set. Set via time_col=");
        Preconditions.checkNotNull(timeUnit, "Time unit not set. Set via time_unit=");
        Preconditions.checkNotNull(valueExpr, "Value expression not set. Set via value=");
        HashMap<String, String> queryOptions = new HashMap<String, String>();
        if (request.getNumGroupsLimit() > 0) {
            queryOptions.put("numGroupsLimit", Integer.toString(request.getNumGroupsLimit()));
        }
        return new LeafTimeSeriesPlanNode(planId, children, tableName, timeColumn, timeUnit, Long.valueOf(0L), filter, valueExpr, aggInfo, groupByColumns, request.getLimit(), queryOptions);
    }
}

