/*
 * Decompiled with CFR 0.152.
 */
package com.yscope.clp.compressorfrontend;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class NativeLibraryLoader {
    private static final String LIBRARY_NAME = "libclp-ffi-java";
    private static final DateTimeFormatter logTimestampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxx");

    public static void load() {
        try {
            System.loadLibrary(LIBRARY_NAME.substring("lib".length()));
            return;
        }
        catch (Throwable e) {
            Throwable loadLibraryThrowable = e;
            URL libUrl = NativeLibraryLoader.getLibUrlInJar();
            if (null == libUrl) {
                NativeLibraryLoader.logError("Failed to find native library in JAR.");
                NativeLibraryLoader.logError("System.loadLibrary failed - " + loadLibraryThrowable.getMessage());
                return;
            }
            try {
                File libTempFile = File.createTempFile(LIBRARY_NAME, ".tmp");
                libTempFile.deleteOnExit();
                try (InputStream in = libUrl.openStream();
                     BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(libTempFile.toPath(), new OpenOption[0]));){
                    int numBytesRead;
                    byte[] buf = new byte[4096];
                    while (-1 != (numBytesRead = in.read(buf))) {
                        out.write(buf, 0, numBytesRead);
                    }
                }
                System.load(libTempFile.getAbsolutePath());
            }
            catch (IOException e2) {
                NativeLibraryLoader.logError("Failed to load native library from JAR -");
                e2.printStackTrace();
            }
            return;
        }
    }

    private static URL getLibUrlInJar() {
        Path[] libPaths;
        String osNameWithoutSpaces = System.getProperty("os.name").replace(' ', '-');
        Path libDir = Paths.get("/", "lib", osNameWithoutSpaces, System.getProperty("os.arch"));
        for (Path libPath : libPaths = new Path[]{libDir.resolve("libclp-ffi-java.so"), libDir.resolve("libclp-ffi-java.dylib")}) {
            URL libUrl = NativeLibraryLoader.class.getResource(libPath.toString());
            if (null == libUrl) continue;
            return libUrl;
        }
        return null;
    }

    private static void logError(String message) {
        System.err.println(ZonedDateTime.now().format(logTimestampFormatter) + " clp-ffi: " + message);
    }
}

