/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.internals.generated.TransactionLogKey;
import kafka.internals.generated.TransactionLogValue;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.Record;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;

public final class TransactionLog$ {
    public static TransactionLog$ MODULE$;
    private final int DefaultNumPartitions;
    private final int DefaultSegmentBytes;
    private final short DefaultReplicationFactor;
    private final int DefaultMinInSyncReplicas;
    private final int DefaultLoadBufferSize;
    private final CompressionType EnforcedCompressionType;
    private final short EnforcedRequiredAcks;

    static {
        new TransactionLog$();
    }

    public int DefaultNumPartitions() {
        return this.DefaultNumPartitions;
    }

    public int DefaultSegmentBytes() {
        return this.DefaultSegmentBytes;
    }

    public short DefaultReplicationFactor() {
        return this.DefaultReplicationFactor;
    }

    public int DefaultMinInSyncReplicas() {
        return this.DefaultMinInSyncReplicas;
    }

    public int DefaultLoadBufferSize() {
        return this.DefaultLoadBufferSize;
    }

    public CompressionType EnforcedCompressionType() {
        return this.EnforcedCompressionType;
    }

    public short EnforcedRequiredAcks() {
        return this.EnforcedRequiredAcks;
    }

    public byte[] keyToBytes(String transactionalId) {
        return MessageUtil.toVersionPrefixedBytes((short)0, new TransactionLogKey().setTransactionalId(transactionalId));
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata) {
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (!(transactionState != null ? !transactionState.equals(empty$) : empty$ != null) && txnMetadata.topicPartitions().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(72).append("Transaction is not expected to have any partitions since its state is ").append(txnMetadata.txnState()).append(": ").append(txnMetadata).toString());
        }
        TransactionState transactionState2 = txnMetadata.txnState();
        Empty$ empty$2 = Empty$.MODULE$;
        List<TransactionLogValue.PartitionsSchema> transactionPartitions = !(transactionState2 != null ? !transactionState2.equals(empty$2) : empty$2 != null) ? null : CollectionConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)txnMetadata.topicPartitions().groupBy((Function1<TopicPartition, String> & Serializable & scala.Serializable)x$1 -> x$1.topic()).map((Function1<Tuple2, TransactionLogValue.PartitionsSchema> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String topic = (String)x0$1._1();
            scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)x0$1._2();
            TransactionLogValue.PartitionsSchema partitionsSchema = new TransactionLogValue.PartitionsSchema().setTopic(topic).setPartitionIds(CollectionConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)partitions.map((Function1<TopicPartition, Integer> & Serializable & scala.Serializable)tp -> tp.partition(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toList()).asJava());
            return partitionsSchema;
        }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava();
        return MessageUtil.toVersionPrefixedBytes((short)0, new TransactionLogValue().setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStatus(txnMetadata.txnState().byte()).setTransactionLastUpdateTimestampMs(txnMetadata.txnLastUpdateTimestamp()).setTransactionStartTimestampMs(txnMetadata.txnStartTimestamp()).setTransactionPartitions(transactionPartitions));
    }

    public TxnKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            TransactionLogKey value = new TransactionLogKey(new ByteBufferAccessor(buffer), version);
            return new TxnKey(version, value.transactionalId());
        }
        throw new IllegalStateException(new StringBuilder(49).append("Unknown version ").append(version).append(" from the transaction log message").toString());
    }

    public Option<TransactionMetadata> readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            TransactionLogValue value = new TransactionLogValue(new ByteBufferAccessor(buffer), version);
            TransactionMetadata transactionMetadata = new TransactionMetadata(transactionalId, value.producerId(), -1L, value.producerEpoch(), -1, value.transactionTimeoutMs(), TransactionMetadata$.MODULE$.byteToState(value.transactionStatus()), (Set<TopicPartition>)Set$.MODULE$.empty(), value.transactionStartTimestampMs(), value.transactionLastUpdateTimestampMs());
            if (!transactionMetadata.state().equals(Empty$.MODULE$)) {
                value.transactionPartitions().forEach(partitionsSchema -> transactionMetadata.addPartitions(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionsSchema.partitionIds()).asScala()).map((Function1<Integer, TopicPartition> & Serializable & scala.Serializable)partitionId -> new TopicPartition(partitionsSchema.topic(), Predef$.MODULE$.Integer2int((Integer)partitionId)), Buffer$.MODULE$.canBuildFrom())).toSet()));
            }
            return new Some<TransactionMetadata>(transactionMetadata);
        }
        throw new IllegalStateException(new StringBuilder(55).append("Unknown version ").append(version).append(" from the transaction log message value").toString());
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        String string;
        TxnKey txnKey = this.readTxnRecordKey(record.key());
        String keyString = new StringBuilder(38).append("transaction_metadata::transactionalId=").append(txnKey.transactionalId()).toString();
        Option<TransactionMetadata> option = this.readTxnRecordValue(txnKey.transactionalId(), record.value());
        if (None$.MODULE$.equals(option)) {
            string = "<DELETE>";
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            string = new StringBuilder(83).append("producerId:").append(txnMetadata.producerId()).append(",").append("producerEpoch:").append(txnMetadata.producerEpoch()).append(",").append("state=").append(txnMetadata.state()).append(",").append("partitions=").append(txnMetadata.topicPartitions().mkString("[", ",", "]")).append(",").append("txnLastUpdateTimestamp=").append(txnMetadata.txnLastUpdateTimestamp()).append(",").append("txnTimeoutMs=").append(txnMetadata.txnTimeoutMs()).toString();
        } else {
            throw new MatchError(option);
        }
        return new Tuple2<Option<String>, Option<String>>(new Some<String>(keyString), new Some<String>(string));
    }

    private TransactionLog$() {
        MODULE$ = this;
        this.DefaultNumPartitions = 50;
        this.DefaultSegmentBytes = 0x6400000;
        this.DefaultReplicationFactor = (short)3;
        this.DefaultMinInSyncReplicas = 2;
        this.DefaultLoadBufferSize = 0x500000;
        this.EnforcedCompressionType = CompressionType.NONE;
        this.EnforcedRequiredAcks = (short)-1;
    }
}

