/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

public final class JmxTool$
implements Logging {
    public static JmxTool$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new JmxTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        Map<Object, Object> numExpectedAttributes;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> objectNameOpt = parser.accepts("object-name", "A JMX object name to use as a query. This can contain wild cards, and this option can be given multiple times to specify more than one query. If no objects are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> attributesOpt = parser.accepts("attributes", "The list of attributes to include in the query. This is a comma-separated list. If no attributes are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> reportingIntervalOpt = parser.accepts("reporting-interval", "Interval in MS with which to poll jmx stats; default value is 2 seconds. Value of -1 equivalent to setting one-time to true").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(2000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Boolean> oneTimeOpt = parser.accepts("one-time", "Flag to indicate run once only.").withRequiredArg().describedAs("one-time").ofType(Boolean.class).defaultsTo(Predef$.MODULE$.boolean2Boolean(false), (Boolean[])((Object[])new Boolean[0]));
        ArgumentAcceptingOptionSpec<String> dateFormatOpt = parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("format").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> jmxServiceUrlOpt = parser.accepts("jmx-url", "The url to connect to poll JMX data. See Oracle javadoc for JMXServiceURL for details.").withRequiredArg().describedAs("service-url").ofType(String.class).defaultsTo("service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> reportFormatOpt = parser.accepts("report-format", "output format name: either 'original', 'properties', 'csv', 'tsv' ").withRequiredArg().describedAs("report-format").ofType(String.class).defaultsTo("original", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<String> jmxAuthPropOpt = parser.accepts("jmx-auth-prop", "A mechanism to pass property in the form 'username=password' when enabling remote JMX with password authentication.").withRequiredArg().describedAs("jmx-auth-prop").ofType(String.class);
        ArgumentAcceptingOptionSpec<Boolean> jmxSslEnableOpt = parser.accepts("jmx-ssl-enable", "Flag to enable remote JMX with SSL.").withRequiredArg().describedAs("ssl-enable").ofType(Boolean.class).defaultsTo(Predef$.MODULE$.boolean2Boolean(false), (Boolean[])((Object[])new Boolean[0]));
        OptionSpecBuilder waitOpt = parser.accepts("wait", "Wait for requested JMX objects to become available before starting output. Only supported when the list of objects is non-empty and contains no object name patterns.");
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Dump JMX values to standard output.");
        }
        OptionSet options = parser.parse(args);
        if (options.has(helpOpt)) {
            parser.printHelpOn(System.out);
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
        JMXServiceURL url = new JMXServiceURL(options.valueOf(jmxServiceUrlOpt));
        int interval = options.valueOf(reportingIntervalOpt);
        boolean oneTime = interval < 0 || options.has(oneTimeOpt);
        boolean attributesIncludeExists = options.has(attributesOpt);
        Option attributesInclude = attributesIncludeExists ? new Some<Object>(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])options.valueOf(attributesOpt).split(","))).filterNot((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.equals("")))) : None$.MODULE$;
        Option dateFormat = options.has(dateFormatOpt) ? new Some<SimpleDateFormat>(new SimpleDateFormat(options.valueOf(dateFormatOpt))) : None$.MODULE$;
        boolean wait = options.has(waitOpt);
        String reportFormat = this.parseFormat(options.valueOf(reportFormatOpt).toLowerCase());
        boolean reportFormatOriginal = reportFormat.equals("original");
        boolean enablePasswordAuth = options.has(jmxAuthPropOpt);
        boolean enableSsl = options.has(jmxSslEnableOpt);
        ObjectRef<Object> mbsc = ObjectRef.create(null);
        boolean connected = false;
        int connectTimeoutMs = 10000;
        long connectTestStarted = System.currentTimeMillis();
        do {
            try {
                System.err.println(new StringBuilder(31).append("Trying to connect to JMX url: ").append(url).append(".").toString());
                HashMap<String, Object> env = new HashMap<String, Object>();
                if (enableSsl) {
                    SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                    env.put("com.sun.jndi.rmi.factory.socket", csf);
                }
                if (enablePasswordAuth) {
                    String[] credentials = options.valueOf(jmxAuthPropOpt).split("=", 2);
                    env.put("jmx.remote.credentials", credentials);
                }
                JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
                mbsc.elem = jmxc.getMBeanServerConnection();
                connected = true;
            }
            catch (Exception e) {
                System.err.println(new StringBuilder(43).append("Could not connect to JMX url: ").append(url).append(". Exception ").append(e.getMessage()).append(".").toString());
                e.printStackTrace();
                Thread.sleep(100L);
            }
        } while (System.currentTimeMillis() - connectTestStarted < (long)connectTimeoutMs && !connected);
        if (!connected) {
            System.err.println(new StringBuilder(40).append("Could not connect to JMX url ").append(url).append(" after ").append(connectTimeoutMs).append(" ms.").toString());
            System.err.println("Exiting.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        GenTraversable queries = options.has(objectNameOpt) ? (Iterable)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(options.valuesOf(objectNameOpt)).asScala()).map((Function1<String, ObjectName> & Serializable & scala.Serializable)x$2 -> new ObjectName((String)x$2), Buffer$.MODULE$.canBuildFrom()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Null$[]{null}));
        boolean hasPatternQueries = ((IterableLike)queries.filterNot((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(JmxTool$.$anonfun$main$3(x$1)))).exists((Function1<ObjectName, Object> & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean(name.isPattern()));
        ObjectRef<Object> names = ObjectRef.create(null);
        int waitTimeoutMs = 10000;
        if (!hasPatternQueries) {
            long start = System.currentTimeMillis();
            do {
                if ((Iterable)names.elem != null) {
                    System.err.println("Could not find all object names, retrying");
                    Thread.sleep(100L);
                }
                names.elem = queries.flatMap((Function1<ObjectName, Set> & Serializable & scala.Serializable)name -> CollectionConverters$.MODULE$.asScalaSetConverter(((MBeanServerConnection)mbsc$1.elem).queryNames((ObjectName)name, null)).asScala(), Iterable$.MODULE$.canBuildFrom());
            } while (wait && System.currentTimeMillis() - start < (long)waitTimeoutMs && !JmxTool$.foundAllObjects$1((Iterable)queries, names));
        }
        if (wait && !JmxTool$.foundAllObjects$1((Iterable)queries, names)) {
            String missing = queries.toSet().$minus(JmxTool$.namesSet$1(names)).mkString(", ");
            System.err.println(new StringBuilder(61).append("Could not find all requested object names after ").append(waitTimeoutMs).append(" ms. Missing ").append(missing).toString());
            System.err.println("Exiting.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Map<Object, Object> map = !attributesIncludeExists ? ((TraversableOnce)((Iterable)names.elem).map((Function1<ObjectName, Tuple2> & Serializable & scala.Serializable)name -> {
            MBeanInfo mbean = ((MBeanServerConnection)mbsc$1.elem).getMBeanInfo((ObjectName)name);
            return new Tuple2<ObjectName, Integer>((ObjectName)name, BoxesRunTime.boxToInteger(((MBeanServerConnection)mbsc$1.elem).getAttributes((ObjectName)name, (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())).map((Function1<MBeanAttributeInfo, String> & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).size()));
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : (numExpectedAttributes = !hasPatternQueries ? (Map<Object, Object>)((TraversableOnce)((Iterable)names.elem).map((Function1<ObjectName, Tuple2> & Serializable & scala.Serializable)name -> {
            MBeanInfo mbean = ((MBeanServerConnection)mbsc$1.elem).getMBeanInfo((ObjectName)name);
            AttributeList attributes = ((MBeanServerConnection)mbsc$1.elem).getAttributes((ObjectName)name, (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())).map((Function1<MBeanAttributeInfo, String> & Serializable & scala.Serializable)x$4 -> x$4.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
            Buffer expectedAttributes = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(attributes).asScala().filter((Function1<Attribute, Object> & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean(JmxTool$.$anonfun$main$10(attributesInclude, attr)));
            return new Tuple2<ObjectName, Integer>((ObjectName)name, BoxesRunTime.boxToInteger(expectedAttributes.size()));
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(JmxTool$.$anonfun$main$11(x$5))) : ((TraversableOnce)queries.map((Function1<ObjectName, Tuple2> & Serializable & scala.Serializable)x$6 -> new Tuple2<ObjectName, Integer>((ObjectName)x$6, BoxesRunTime.boxToInteger(((String[])attributesInclude.get()).length)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        if (numExpectedAttributes.isEmpty()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, new StringBuilder(47).append("No matched attributes for the queried objects ").append(queries).append(".").toString());
        }
        List<?> keys = new $colon$colon<Nothing$>((Nothing$)((Object)"time"), Nil$.MODULE$).$plus$plus((GenTraversableOnce<Nothing$>)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable)names.elem, attributesInclude).keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering$String$.MODULE$))), List$.MODULE$.canBuildFrom());
        if (reportFormatOriginal && keys.size() == BoxesRunTime.unboxToInt(numExpectedAttributes.values().sum(Numeric$IntIsIntegral$.MODULE$)) + 1) {
            Predef$.MODULE$.println(((TraversableOnce)keys.map((Function1<String, String> & Serializable & scala.Serializable)x$7 -> new StringBuilder(2).append("\"").append((String)x$7).append("\"").toString(), List$.MODULE$.canBuildFrom())).mkString(","));
        }
        boolean keepGoing = true;
        while (keepGoing) {
            String string;
            long start = System.currentTimeMillis();
            scala.collection.mutable.Map<String, Object> attributes = this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable)names.elem, attributesInclude);
            if (dateFormat instanceof Some) {
                string = ((SimpleDateFormat)((Some)dateFormat).value()).format(new Date());
            } else if (None$.MODULE$.equals(dateFormat)) {
                string = Long.toString(System.currentTimeMillis());
            } else {
                throw new MatchError(dateFormat);
            }
            attributes.update("time", string);
            if (attributes.keySet().size() == BoxesRunTime.unboxToInt(numExpectedAttributes.values().sum(Numeric$IntIsIntegral$.MODULE$)) + 1) {
                if (reportFormatOriginal) {
                    Predef$.MODULE$.println(((TraversableOnce)keys.map((Function1<String, Object> & Serializable & scala.Serializable)x$8 -> attributes.apply((String)x$8), List$.MODULE$.canBuildFrom())).mkString(","));
                } else if (reportFormat.equals("properties")) {
                    keys.foreach((Function1<String, Object> & Serializable & scala.Serializable)k -> {
                        Predef$.MODULE$.println(new StringBuilder(1).append(k).append("=").append(attributes.apply(k)).toString());
                        return BoxedUnit.UNIT;
                    });
                } else if (reportFormat.equals("csv")) {
                    keys.foreach((Function1<String, Object> & Serializable & scala.Serializable)k -> {
                        Predef$.MODULE$.println(new StringBuilder(3).append(k).append(",\"").append(attributes.apply(k)).append("\"").toString());
                        return BoxedUnit.UNIT;
                    });
                } else {
                    keys.foreach((Function1<String, Object> & Serializable & scala.Serializable)k -> {
                        Predef$.MODULE$.println(new StringBuilder(1).append(k).append("\t").append(attributes.apply(k)).toString());
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (oneTime) {
                keepGoing = false;
                continue;
            }
            Thread.sleep(package$.MODULE$.max(0L, (long)interval - (System.currentTimeMillis() - start)));
        }
    }

    public scala.collection.mutable.Map<String, Object> queryAttributes(MBeanServerConnection mbsc, Iterable<ObjectName> names, Option<String[]> attributesInclude) {
        scala.collection.mutable.HashMap<String, Object> attributes = new scala.collection.mutable.HashMap<String, Object>();
        names.foreach((Function1<ObjectName, Object> & Serializable & scala.Serializable)name -> {
            JmxTool$.$anonfun$queryAttributes$1(mbsc, attributesInclude, attributes, name);
            return BoxedUnit.UNIT;
        });
        return attributes;
    }

    public String parseFormat(String reportFormatOpt) {
        String string = "properties".equals(reportFormatOpt) ? "properties" : ("csv".equals(reportFormatOpt) ? "csv" : ("tsv".equals(reportFormatOpt) ? "tsv" : "original"));
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$main$3(Object x$1) {
        return Objects.isNull(x$1);
    }

    private static final scala.collection.immutable.Set namesSet$1(ObjectRef names$1) {
        return (scala.collection.immutable.Set)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Iterable)names$1.elem)).toSet().flatten(Predef$.MODULE$.$conforms());
    }

    private static final boolean foundAllObjects$1(Iterable queries$1, ObjectRef names$1) {
        scala.collection.immutable.Set set = queries$1.toSet();
        scala.collection.immutable.Set set2 = JmxTool$.namesSet$1(names$1);
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$main$10(Option attributesInclude$1, Attribute attr) {
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])attributesInclude$1.get())).contains(attr.getName());
    }

    public static final /* synthetic */ boolean $anonfun$main$11(Tuple2 x$5) {
        return x$5._2$mcI$sp() > 0;
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$3(Option attributesInclude$2, scala.collection.mutable.HashMap attributes$2, ObjectName name$1, Object attrObj) {
        Attribute attr = (Attribute)attrObj;
        if (attributesInclude$2 instanceof Some) {
            String[] allowedAttributes = (String[])((Some)attributesInclude$2).value();
            if (new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])allowedAttributes)).contains(attr.getName())) {
                attributes$2.update(new StringBuilder(1).append(name$1.toString()).append(":").append(attr.getName()).toString(), attr.getValue());
                return;
            }
        } else {
            if (None$.MODULE$.equals(attributesInclude$2)) {
                attributes$2.update(new StringBuilder(1).append(name$1.toString()).append(":").append(attr.getName()).toString(), attr.getValue());
                return;
            }
            throw new MatchError(attributesInclude$2);
        }
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$1(MBeanServerConnection mbsc$2, Option attributesInclude$2, scala.collection.mutable.HashMap attributes$2, ObjectName name) {
        MBeanInfo mbean = mbsc$2.getMBeanInfo(name);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mbsc$2.getAttributes(name, (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())).map((Function1<MBeanAttributeInfo, String> & Serializable & scala.Serializable)x$9 -> x$9.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).asScala()).foreach((Function1<Object, Object> & Serializable & scala.Serializable)attrObj -> {
            JmxTool$.$anonfun$queryAttributes$3(attributesInclude$2, attributes$2, name, attrObj);
            return BoxedUnit.UNIT;
        });
    }

    private JmxTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

