/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055x!\u0002\u00192\u0011\u00031d!\u0002\u001d2\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u0019\u0006\u0001\u000b\u0011\u0002#\t\u000f5\u000b!\u0019!C\u0001\u0007\"1a*\u0001Q\u0001\n\u0011CqaT\u0001C\u0002\u0013\u00051\t\u0003\u0004Q\u0003\u0001\u0006I\u0001\u0012\u0005\b#\u0006\u0011\r\u0011\"\u0001D\u0011\u0019\u0011\u0016\u0001)A\u0005\t\"91+\u0001b\u0001\n\u0003\u0019\u0005B\u0002+\u0002A\u0003%A\tC\u0004V\u0003\t\u0007I\u0011A\"\t\rY\u000b\u0001\u0015!\u0003E\u0011\u001d9\u0016A1A\u0005\u0002\rCa\u0001W\u0001!\u0002\u0013!\u0005bB-\u0002\u0005\u0004%\ta\u0011\u0005\u00075\u0006\u0001\u000b\u0011\u0002#\u0007\ta\n\u0004a\u0017\u0005\t?N\u0011\t\u0011)A\u0005A\"Aqn\u0005B\u0001B\u0003%\u0001\u000f\u0003\u0005~'\t\u0005\t\u0015!\u0003t\u0011!q8C!A!\u0002\u0013y\b\"CA\u0003'\t\u0005\t\u0015!\u0003\u0000\u0011\u0019\u00015\u0003\"\u0001\u0002\b!I\u0011QC\nC\u0002\u0013%\u0011q\u0003\u0005\t\u0003K\u0019\u0002\u0015!\u0003\u0002\u001a!I\u0011qE\nC\u0002\u0013%\u0011\u0011\u0006\u0005\t\u0003C\u001a\u0002\u0015!\u0003\u0002,!9\u00111M\n\u0005\u0002\u0005\u0015\u0004bBA6'\u0011\u0005\u0011Q\u000e\u0005\b\u0003g\u001aB\u0011BA;\u0011\u001d\tYi\u0005C\u0005\u0003\u001bCq!!.\u0014\t\u0013\t9\f\u0003\u0005\u0002>N!\t!MA`\u0011\u001d\t)m\u0005C\u0005\u0003\u000f4\u0011\"a\f\u0014!\u0003\rJ!!\r\t\u000f\u0005MRE\"\u0001\u00026!9\u0011QJ\u0013\u0007\u0002\u0005=cABAf'\u0011\ti\r\u0003\u0004AQ\u0011\u0005\u0011q\u001a\u0005\b\u0003gAC\u0011AAj\u0011\u001d\ti\u0005\u000bC\u0001\u000334a!!8\u0014\t\u0005}\u0007B\u0002!-\t\u0003\t\t\u000fC\u0004\u000241\"\t!!:\t\u000f\u00055C\u0006\"\u0001\u0002j\u0006y\u0001+Y:to>\u0014H-\u00128d_\u0012,'O\u0003\u00023g\u0005)Q\u000f^5mg*\tA'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005]\nQ\"A\u0019\u0003\u001fA\u000b7o]<pe\u0012,enY8eKJ\u001c\"!\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta'A\fLKf4\u0015m\u0019;pef\fEnZ8sSRDW\u000e\u0015:paV\tA\t\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\rM#(/\u001b8h\u0003aYU-\u001f$bGR|'/_!mO>\u0014\u0018\u000e\u001e5n!J|\u0007\u000fI\u0001\u0014\u0007&\u0004\b.\u001a:BY\u001e|'/\u001b;i[B\u0013x\u000e]\u0001\u0015\u0007&\u0004\b.\u001a:BY\u001e|'/\u001b;i[B\u0013x\u000e\u001d\u0011\u00021%s\u0017\u000e^5bY&T\u0018\r^5p]Z+7\r^8s!J|\u0007/A\rJ]&$\u0018.\u00197ju\u0006$\u0018n\u001c8WK\u000e$xN\u001d)s_B\u0004\u0013!D&fs2+gn\u001a;i!J|\u0007/\u0001\bLKfdUM\\4uQB\u0013x\u000e\u001d\u0011\u0002\u0011M\u000bG\u000e\u001e)s_B\f\u0011bU1miB\u0013x\u000e\u001d\u0011\u0002\u001d%#XM]1uS>t7\u000f\u0015:pa\u0006y\u0011\n^3sCRLwN\\:Qe>\u0004\b%A\u000bF]\u000eL(\u000f\u001d;fIB\u000b7o]<pe\u0012\u0004&o\u001c9\u0002-\u0015s7-\u001f:qi\u0016$\u0007+Y:to>\u0014H\r\u0015:pa\u0002\n!\u0003U1tg^|'\u000f\u001a'f]\u001e$\b\u000e\u0015:pa\u0006\u0019\u0002+Y:to>\u0014H\rT3oORD\u0007K]8qAM\u00191C\u000f/\u0011\u0005]j\u0016B\u000102\u0005\u001daunZ4j]\u001e\faa]3de\u0016$\bCA1n\u001b\u0005\u0011'BA2e\u0003\u0015!\u0018\u0010]3t\u0015\t)g-\u0001\u0004d_:4\u0017n\u001a\u0006\u0003O\"\faaY8n[>t'B\u0001\u001bj\u0015\tQ7.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0006\u0019qN]4\n\u00059\u0014'\u0001\u0003)bgN<xN\u001d3\u0002'-,\u0017PR1di>\u0014\u00180\u00117h_JLG\u000f[7\u0011\u0007m\n8/\u0003\u0002sy\t1q\n\u001d;j_:\u0004\"\u0001^>\u000f\u0005UL\bC\u0001<=\u001b\u00059(B\u0001=6\u0003\u0019a$o\\8u}%\u0011!\u0010P\u0001\u0007!J,G-\u001a4\n\u0005-c(B\u0001>=\u0003=\u0019\u0017\u000e\u001d5fe\u0006cwm\u001c:ji\"l\u0017!C6fs2+gn\u001a;i!\rY\u0014\u0011A\u0005\u0004\u0003\u0007a$aA%oi\u0006Q\u0011\u000e^3sCRLwN\\:\u0015\u0019\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0011\u0005]\u001a\u0002\"B0\u001a\u0001\u0004\u0001\u0007\"B8\u001a\u0001\u0004\u0001\b\"B?\u001a\u0001\u0004\u0019\b\"\u0002@\u001a\u0001\u0004y\bBBA\u00033\u0001\u0007q0\u0001\u0007tK\u000e,(/\u001a*b]\u0012|W.\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 !\u000b\u0001b]3dkJLG/_\u0005\u0005\u0003G\tiB\u0001\u0007TK\u000e,(/\u001a*b]\u0012|W.A\u0007tK\u000e,(/\u001a*b]\u0012|W\u000eI\u0001\u0014G&\u0004\b.\u001a:QCJ\fWn]#oG>$WM]\u000b\u0003\u0003W\u00012!!\f&\u001b\u0005\u0019\"aE\"ja\",'\u000fU1sC6\u001cXI\\2pI\u0016\u00148CA\u0013;\u0003\u0015!x.T1q)\u0011\t9$a\u0011\u0011\r\u0005e\u0012qH:t\u001b\t\tYDC\u0002\u0002>q\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t%a\u000f\u0003\u00075\u000b\u0007\u000fC\u0004\u0002F\u0019\u0002\r!a\u0012\u0002\r\rL\u0007\u000f[3s!\u0011\tY\"!\u0013\n\t\u0005-\u0013Q\u0004\u0002\u0014\u00032<wN]5uQ6\u0004\u0016M]1nKR,'o]\u0001\u0010i>\u0004\u0016M]1nKR,'o\u00159fGR!\u0011\u0011KA/!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#\u0002BA,\u0003;\tAa\u001d9fG&!\u00111LA+\u0005Y\tEnZ8sSRDW\u000eU1sC6,G/\u001a:Ta\u0016\u001c\u0007bBA0O\u0001\u0007\u0011qG\u0001\ta\u0006\u0014\u0018-\\'ba\u0006!2-\u001b9iKJ\u0004\u0016M]1ng\u0016s7m\u001c3fe\u0002\na!\u001a8d_\u0012,GcA:\u0002h!1\u0011\u0011\u000e\u0010A\u0002\u0001\f\u0001\u0002]1tg^|'\u000fZ\u0001\u0007I\u0016\u001cw\u000eZ3\u0015\u0007\u0001\fy\u0007\u0003\u0004\u0002r}\u0001\ra]\u0001\u0010K:\u001cw\u000eZ3e!\u0006\u001c8o^8sI\u0006\u00012/Z2sKR\\U-\u001f$bGR|'/\u001f\u000b\u0005\u0003o\n9\t\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\t\t\t)A\u0003kCZ\f\u00070\u0003\u0003\u0002\u0006\u0006m$\u0001E*fGJ,GoS3z\r\u0006\u001cGo\u001c:z\u0011\u0019\tI\t\ta\u0001a\u0006i1.Z=GC\u000e$xN]=BY\u001e\fQb]3de\u0016$8*Z=Ta\u0016\u001cG\u0003DAH\u00033\u000bi*!)\u0002$\u0006M\u0006\u0003BAI\u0003+k!!a%\u000b\t\u0005]\u00131P\u0005\u0005\u0003/\u000b\u0019JA\u0007TK\u000e\u0014X\r^&fsN\u0003Xm\u0019\u0005\b\u00037\u000b\u0003\u0019AA<\u0003)YW-\u001f$bGR|'/\u001f\u0005\u0007\u0003?\u000b\u0003\u0019A:\u0002\u0013\rL\u0007\u000f[3s\u00032<\u0007\"\u0002@\"\u0001\u0004y\bbBASC\u0001\u0007\u0011qU\u0001\u0005g\u0006dG\u000fE\u0003<\u0003S\u000bi+C\u0002\u0002,r\u0012Q!\u0011:sCf\u00042aOAX\u0013\r\t\t\f\u0010\u0002\u0005\u0005f$X\r\u0003\u0004\u0002\u0006\u0005\u0002\ra`\u0001\rE\u0006\u001cXM\u000e\u001bF]\u000e|G-\u001a\u000b\u0004g\u0006e\u0006bBA^E\u0001\u0007\u0011qU\u0001\u0006Ef$Xm]\u0001\rE\u0006\u001cXM\u000e\u001bEK\u000e|G-\u001a\u000b\u0005\u0003O\u000b\t\r\u0003\u0004\u0002D\u000e\u0002\ra]\u0001\bK:\u001cw\u000eZ3e\u0003Q\u0019\u0017\u000e\u001d5feB\u000b'/Y7t\u0013:\u001cH/\u00198dKR!\u00111FAe\u0011\u0015iH\u00051\u0001t\u0005=Ie\u000fU1sC6\u001cXI\\2pI\u0016\u00148\u0003\u0002\u0015;\u0003W!\"!!5\u0011\u0007\u00055\u0002\u0006\u0006\u0003\u00028\u0005U\u0007bBAlU\u0001\u0007\u0011qI\u0001\rG&\u0004\b.\u001a:QCJ\fWn\u001d\u000b\u0005\u0003#\nY\u000eC\u0004\u0002`-\u0002\r!a\u000e\u0003!\u001d\u001bW\u000eU1sC6\u001cXI\\2pI\u0016\u00148\u0003\u0002\u0017;\u0003W!\"!a9\u0011\u0007\u00055B\u0006\u0006\u0003\u00028\u0005\u001d\bbBAl]\u0001\u0007\u0011q\t\u000b\u0005\u0003#\nY\u000fC\u0004\u0002`=\u0002\r!a\u000e")
public class PasswordEncoder
implements Logging {
    private final Password secret;
    private final Option<String> keyFactoryAlgorithm;
    private final String cipherAlgorithm;
    private final int keyLength;
    private final int iterations;
    private final SecureRandom secureRandom;
    private final CipherParamsEncoder cipherParamsEncoder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String PasswordLengthProp() {
        return PasswordEncoder$.MODULE$.PasswordLengthProp();
    }

    public static String EncyrptedPasswordProp() {
        return PasswordEncoder$.MODULE$.EncyrptedPasswordProp();
    }

    public static String IterationsProp() {
        return PasswordEncoder$.MODULE$.IterationsProp();
    }

    public static String SaltProp() {
        return PasswordEncoder$.MODULE$.SaltProp();
    }

    public static String KeyLengthProp() {
        return PasswordEncoder$.MODULE$.KeyLengthProp();
    }

    public static String InitializationVectorProp() {
        return PasswordEncoder$.MODULE$.InitializationVectorProp();
    }

    public static String CipherAlgorithmProp() {
        return PasswordEncoder$.MODULE$.CipherAlgorithmProp();
    }

    public static String KeyFactoryAlgorithmProp() {
        return PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private SecureRandom secureRandom() {
        return this.secureRandom;
    }

    private CipherParamsEncoder cipherParamsEncoder() {
        return this.cipherParamsEncoder;
    }

    public String encode(Password password) {
        byte[] salt = new byte[256];
        this.secureRandom().nextBytes(salt);
        Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
        SecretKeyFactory keyFactory = this.secretKeyFactory(this.keyFactoryAlgorithm);
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, this.cipherAlgorithm, this.keyLength, salt, this.iterations);
        cipher.init(1, keySpec);
        byte[] encryptedPassword = cipher.doFinal(password.value().getBytes(StandardCharsets.UTF_8));
        return ((TraversableOnce)((MapLike)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()), keyFactory.getAlgorithm()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.CipherAlgorithmProp()), this.cipherAlgorithm), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.KeyLengthProp()), BoxesRunTime.boxToInteger(this.keyLength)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.SaltProp()), this.kafka$utils$PasswordEncoder$$base64Encode(salt)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.IterationsProp()), Integer.toString(this.iterations)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.EncyrptedPasswordProp()), this.kafka$utils$PasswordEncoder$$base64Encode(encryptedPassword)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.PasswordLengthProp()), BoxesRunTime.boxToInteger(password.value().length()))}))).$plus$plus(this.cipherParamsEncoder().toMap(cipher.getParameters())).map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError((Object)null);
            }
            String k = (String)x0$1._1();
            Object v = x0$1._2();
            String string = new StringBuilder(1).append(k).append(":").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public Password decode(String encodedPassword) {
        String string;
        Map<String, String> params = CoreUtils$.MODULE$.parseCsvMap(encodedPassword);
        String keyFactoryAlg = (String)params.apply(PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp());
        String cipherAlg = (String)params.apply(PasswordEncoder$.MODULE$.CipherAlgorithmProp());
        int keyLength = new StringOps(Predef$.MODULE$.augmentString((String)params.apply(PasswordEncoder$.MODULE$.KeyLengthProp()))).toInt();
        byte[] salt = this.base64Decode((String)params.apply(PasswordEncoder$.MODULE$.SaltProp()));
        int iterations = new StringOps(Predef$.MODULE$.augmentString((String)params.apply(PasswordEncoder$.MODULE$.IterationsProp()))).toInt();
        byte[] encryptedPassword = this.base64Decode((String)params.apply(PasswordEncoder$.MODULE$.EncyrptedPasswordProp()));
        int passwordLengthProp = new StringOps(Predef$.MODULE$.augmentString((String)params.apply(PasswordEncoder$.MODULE$.PasswordLengthProp()))).toInt();
        Cipher cipher = Cipher.getInstance(cipherAlg);
        SecretKeyFactory keyFactory = this.secretKeyFactory(new Some<String>(keyFactoryAlg));
        SecretKeySpec keySpec = this.secretKeySpec(keyFactory, cipherAlg, keyLength, salt, iterations);
        cipher.init(2, (Key)keySpec, this.cipherParamsEncoder().toParameterSpec(params));
        try {
            byte[] decrypted = cipher.doFinal(encryptedPassword);
            string = new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ConfigException("Password could not be decoded", (Object)e);
        }
        String password = string;
        if (password.length() != passwordLengthProp) {
            throw new ConfigException("Password could not be decoded, sanity check of length failed");
        }
        return new Password(password);
    }

    private SecretKeyFactory secretKeyFactory(Option<String> keyFactoryAlg) {
        SecretKeyFactory secretKeyFactory;
        if (keyFactoryAlg instanceof Some) {
            secretKeyFactory = SecretKeyFactory.getInstance((String)((Some)keyFactoryAlg).value());
        } else if (None$.MODULE$.equals(keyFactoryAlg)) {
            SecretKeyFactory secretKeyFactory2;
            try {
                secretKeyFactory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                secretKeyFactory2 = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            }
            secretKeyFactory = secretKeyFactory2;
        } else {
            throw new MatchError(keyFactoryAlg);
        }
        return secretKeyFactory;
    }

    private SecretKeySpec secretKeySpec(SecretKeyFactory keyFactory, String cipherAlg, int keyLength, byte[] salt, int iterations) {
        PBEKeySpec keySpec = new PBEKeySpec(this.secret.value().toCharArray(), salt, iterations, keyLength);
        String algorithm = cipherAlg.indexOf(47) > 0 ? cipherAlg.substring(0, cipherAlg.indexOf(47)) : cipherAlg;
        return new SecretKeySpec(keyFactory.generateSecret(keySpec).getEncoded(), algorithm);
    }

    public String kafka$utils$PasswordEncoder$$base64Encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public byte[] base64Decode(String encoded) {
        return Base64.getDecoder().decode(encoded);
    }

    private CipherParamsEncoder cipherParamsInstance(String cipherAlgorithm) {
        String string;
        Option<List<String>> option = new StringOps(Predef$.MODULE$.augmentString("AES/(.*)/.*")).r().unapplySeq(cipherAlgorithm);
        CipherParamsEncoder cipherParamsEncoder = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && "GCM".equals(string = (String)((LinearSeqOptimized)option.get()).apply(0)) ? new GcmParamsEncoder() : new IvParamsEncoder();
        return cipherParamsEncoder;
    }

    public PasswordEncoder(Password secret, Option<String> keyFactoryAlgorithm, String cipherAlgorithm, int keyLength, int iterations) {
        this.secret = secret;
        this.keyFactoryAlgorithm = keyFactoryAlgorithm;
        this.cipherAlgorithm = cipherAlgorithm;
        this.keyLength = keyLength;
        this.iterations = iterations;
        Logging.$init$(this);
        this.secureRandom = new SecureRandom();
        this.cipherParamsEncoder = this.cipherParamsInstance(cipherAlgorithm);
    }

    private interface CipherParamsEncoder {
        public Map<String, String> toMap(AlgorithmParameters var1);

        public AlgorithmParameterSpec toParameterSpec(Map<String, String> var1);
    }

    private class GcmParamsEncoder
    implements CipherParamsEncoder {
        @Override
        public Map<String, String> toMap(AlgorithmParameters cipherParams) {
            if (cipherParams != null) {
                GCMParameterSpec spec = cipherParams.getParameterSpec(GCMParameterSpec.class);
                return (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.InitializationVectorProp()), this.kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer().kafka$utils$PasswordEncoder$$base64Encode(spec.getIV())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("authenticationTagLength"), Integer.toString(spec.getTLen()))}));
            }
            throw new IllegalStateException("Could not determine initialization vector for cipher");
        }

        @Override
        public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
            return new GCMParameterSpec(new StringOps(Predef$.MODULE$.augmentString((String)paramMap.apply("authenticationTagLength"))).toInt(), this.kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer().base64Decode((String)paramMap.apply(PasswordEncoder$.MODULE$.InitializationVectorProp())));
        }

        public /* synthetic */ PasswordEncoder kafka$utils$PasswordEncoder$GcmParamsEncoder$$$outer() {
            return PasswordEncoder.this;
        }

        public GcmParamsEncoder() {
            if (PasswordEncoder.this == null) {
                throw null;
            }
        }
    }

    private class IvParamsEncoder
    implements CipherParamsEncoder {
        @Override
        public Map<String, String> toMap(AlgorithmParameters cipherParams) {
            if (cipherParams != null) {
                IvParameterSpec ivSpec = cipherParams.getParameterSpec(IvParameterSpec.class);
                return (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(PasswordEncoder$.MODULE$.InitializationVectorProp()), this.kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer().kafka$utils$PasswordEncoder$$base64Encode(ivSpec.getIV()))}));
            }
            throw new IllegalStateException("Could not determine initialization vector for cipher");
        }

        @Override
        public AlgorithmParameterSpec toParameterSpec(Map<String, String> paramMap) {
            return new IvParameterSpec(this.kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer().base64Decode((String)paramMap.apply(PasswordEncoder$.MODULE$.InitializationVectorProp())));
        }

        public /* synthetic */ PasswordEncoder kafka$utils$PasswordEncoder$IvParamsEncoder$$$outer() {
            return PasswordEncoder.this;
        }

        public IvParamsEncoder() {
            if (PasswordEncoder.this == null) {
                throw null;
            }
        }
    }
}

