/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Signature;
import java.util.Objects;

public class FunctionMetadata {
    private final FunctionId functionId;
    private final Signature signature;
    private final String canonicalName;
    private final FunctionNullability functionNullability;
    private final boolean hidden;
    private final boolean deterministic;
    private final String description;
    private final FunctionKind kind;
    private final boolean deprecated;

    public FunctionMetadata(Signature signature, FunctionNullability functionNullability, boolean hidden, boolean deterministic, String description, FunctionKind kind) {
        this(FunctionId.toFunctionId(signature), signature, signature.getName(), functionNullability, hidden, deterministic, description, kind, false);
    }

    public FunctionMetadata(Signature signature, String canonicalName, FunctionNullability functionNullability, boolean hidden, boolean deterministic, String description, FunctionKind kind, boolean deprecated) {
        this(FunctionId.toFunctionId(signature), signature, canonicalName, functionNullability, hidden, deterministic, description, kind, deprecated);
    }

    public FunctionMetadata(FunctionId functionId, Signature signature, String canonicalName, FunctionNullability functionNullability, boolean hidden, boolean deterministic, String description, FunctionKind kind, boolean deprecated) {
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.canonicalName = Objects.requireNonNull(canonicalName, "canonicalName is null");
        this.functionNullability = Objects.requireNonNull(functionNullability, "functionNullability is null");
        Preconditions.checkArgument((functionNullability.getArgumentNullable().size() == signature.getArgumentTypes().size() ? 1 : 0) != 0, (Object)"signature and functionNullability must have same argument count");
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.description = Objects.requireNonNull(description, "description is null");
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.deprecated = deprecated;
    }

    public FunctionId getFunctionId() {
        return this.functionId;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public FunctionNullability getFunctionNullability() {
        return this.functionNullability;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getDescription() {
        return this.description;
    }

    public FunctionKind getKind() {
        return this.kind;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        return this.signature.toString();
    }
}

