/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.BooleanToBooleanFunction;
import io.trino.operator.scalar.DoubleToBooleanFunction;
import io.trino.operator.scalar.LongToBooleanFunction;
import io.trino.operator.scalar.ObjectToBooleanFunction;
import io.trino.spi.block.Block;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.spi.type.Type;

@Description(value="Returns true if the array contains one or more elements that match the given predicate")
@ScalarFunction(value="any_match")
public final class ArrayAnyMatchFunction {
    private ArrayAnyMatchFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Object.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean anyMatchObject(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") ObjectToBooleanFunction function) {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Object element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getObject(arrayBlock, i);
            }
            if (Boolean.TRUE.equals(match = function.apply(element))) {
                return true;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean anyMatchLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Long element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getLong(arrayBlock, i);
            }
            if (Boolean.TRUE.equals(match = function.apply(element))) {
                return true;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean anyMatchDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Double element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getDouble(arrayBlock, i);
            }
            if (Boolean.TRUE.equals(match = function.apply(element))) {
                return true;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean anyMatchBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Boolean element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getBoolean(arrayBlock, i);
            }
            if (Boolean.TRUE.equals(match = function.apply(element))) {
                return true;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return false;
    }
}

