/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.annotations;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.TypeSignature;
import java.util.List;

public final class OperatorValidator {
    private OperatorValidator() {
    }

    public static void validateOperator(OperatorType operatorType, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        switch (operatorType) {
            case ADD: 
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                OperatorValidator.validateOperatorSignature(operatorType, returnType, argumentTypes, 2);
                break;
            }
            case NEGATION: {
                OperatorValidator.validateOperatorSignature(operatorType, returnType, argumentTypes, 1);
                break;
            }
            case EQUAL: 
            case COMPARISON_UNORDERED_LAST: 
            case COMPARISON_UNORDERED_FIRST: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                OperatorValidator.validateComparisonOperatorSignature(operatorType, returnType, argumentTypes, 2);
                break;
            }
            case CAST: {
                OperatorValidator.validateOperatorSignature(operatorType, returnType, argumentTypes, 1);
                break;
            }
            case SUBSCRIPT: {
                OperatorValidator.validateOperatorSignature(operatorType, returnType, argumentTypes, 2);
                Preconditions.checkArgument((argumentTypes.get(0).getBase().equals("array") || argumentTypes.get(0).getBase().equals("map") ? 1 : 0) != 0, (Object)"First argument must be an ARRAY or MAP");
                if (argumentTypes.get(0).getBase().equals("array")) {
                    Preconditions.checkArgument((boolean)argumentTypes.get(1).getBase().equals("bigint"), (Object)"Second argument must be a BIGINT");
                    TypeSignature elementType = (TypeSignature)argumentTypes.get(0).getTypeParametersAsTypeSignatures().get(0);
                    Preconditions.checkArgument((boolean)returnType.equals((Object)elementType), (Object)"[] return type does not match ARRAY element type");
                    break;
                }
                TypeSignature valueType = (TypeSignature)argumentTypes.get(0).getTypeParametersAsTypeSignatures().get(1);
                Preconditions.checkArgument((boolean)returnType.equals((Object)valueType), (Object)"[] return type does not match MAP value type");
                break;
            }
            case HASH_CODE: {
                OperatorValidator.validateOperatorSignature(operatorType, returnType, argumentTypes, 1);
                Preconditions.checkArgument((boolean)returnType.getBase().equals("bigint"), (String)"%s operator must return a BIGINT: %s", (Object)operatorType, (Object)OperatorValidator.formatSignature(operatorType, returnType, argumentTypes));
                break;
            }
            case SATURATED_FLOOR_CAST: {
                OperatorValidator.validateOperatorSignature(operatorType, returnType, argumentTypes, 1);
                break;
            }
        }
    }

    private static void validateOperatorSignature(OperatorType operatorType, TypeSignature returnType, List<TypeSignature> argumentTypes, int expectedArgumentCount) {
        String signature = OperatorValidator.formatSignature(operatorType, returnType, argumentTypes);
        Preconditions.checkArgument((!returnType.getBase().equals("unknown") ? 1 : 0) != 0, (String)"%s operator return type cannot be NULL: %s", (Object)operatorType, (Object)signature);
        Preconditions.checkArgument((argumentTypes.size() == expectedArgumentCount ? 1 : 0) != 0, (String)"%s operator must have exactly %s argument: %s", (Object)operatorType, (Object)expectedArgumentCount, (Object)signature);
    }

    private static void validateComparisonOperatorSignature(OperatorType operatorType, TypeSignature returnType, List<TypeSignature> argumentTypes, int expectedArgumentCount) {
        OperatorValidator.validateOperatorSignature(operatorType, returnType, argumentTypes, expectedArgumentCount);
        Preconditions.checkArgument((boolean)returnType.getBase().equals("boolean"), (String)"%s operator must return a BOOLEAN: %s", (Object)operatorType, (Object)OperatorValidator.formatSignature(operatorType, returnType, argumentTypes));
    }

    private static String formatSignature(OperatorType operatorType, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return operatorType + "(" + Joiner.on((String)", ").join(argumentTypes) + ")::" + returnType;
    }
}

