/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.trino.operator.scalar.DateTimeFunctions;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import io.trino.util.DateTimeZoneIndex;

@ScalarFunction
@Description(value="Formats the given timestamp by the given format")
public class DateFormat {
    private DateFormat() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="varchar(x)") Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.unpackChronology(packedEpochMillis), session.getLocale(), DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis), formatString);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        return DateTimeFunctions.dateFormat(DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())), session.getLocale(), DateTimes.roundToEpochMillis(timestamp), formatString);
    }
}

