/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.DateTimes;
import java.time.ZoneId;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToVarcharCast {
    private TimestampWithTimeZoneToVarcharCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        ZoneId zoneId = DateTimeEncoding.unpackZoneKey((long)packedEpochMillis).getZoneId();
        return Slices.utf8Slice((String)DateTimes.formatTimestampWithTimeZone((int)precision, epochMillis, 0, zoneId));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return Slices.utf8Slice((String)DateTimes.formatTimestampWithTimeZone((int)precision, timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()).getZoneId()));
    }
}

