/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.type.Constraint;
import io.trino.type.DateTimes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarFunction(value="to_iso8601")
public final class ToIso8601 {
    private static final DateTimeFormatter ISO8601_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss");
    private static final String RESULT_LENGTH = "1 + 6 + 15 + min(p, 1) + p + 6";

    private ToIso8601() {
    }

    @LiteralParameters(value={"p", "n"})
    @SqlType(value="varchar(n)")
    @Constraint(variable="n", expression="1 + 6 + 15 + min(p, 1) + p + 6")
    public static Slice toIso8601(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        ZoneId zoneId = DateTimeEncoding.unpackZoneKey((long)packedEpochMillis).getZoneId();
        return Slices.utf8Slice((String)ToIso8601.format((int)precision, epochMillis, 0, zoneId));
    }

    @LiteralParameters(value={"p", "n"})
    @SqlType(value="varchar(n)")
    @Constraint(variable="n", expression="1 + 6 + 15 + min(p, 1) + p + 6")
    public static Slice toIso8601(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return Slices.utf8Slice((String)ToIso8601.format((int)precision, timestamp.getEpochMillis(), timestamp.getPicosOfMilli(), TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()).getZoneId()));
    }

    private static String format(int precision, long epochMillis, int picosOfMilli, ZoneId zoneId) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), zoneId);
        long picoFraction = (long)DateTimes.getMillisOfSecond(epochMillis) * 1000000000L + (long)picosOfMilli;
        ZoneOffset offset = zoneId.getRules().getValidOffsets(dateTime).get(0);
        if (offset.getTotalSeconds() % 60 != 0) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Timezone with non-zero seconds offset cannot be rendered as ISO8601: " + offset.getId());
        }
        return DateTimes.formatTimestamp(precision, dateTime, picoFraction, ISO8601_FORMATTER, builder -> builder.append(offset));
    }
}

