/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.security.CertificateAuthenticator;
import io.trino.spi.security.CertificateAuthenticatorFactory;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class CertificateAuthenticatorManager {
    private static final Logger log = Logger.get(CertificateAuthenticatorManager.class);
    private static final File CONFIG_FILE = new File("etc/certificate-authenticator.properties");
    private static final String NAME_PROPERTY = "certificate-authenticator.name";
    private final AtomicBoolean required = new AtomicBoolean();
    private final Map<String, CertificateAuthenticatorFactory> factories = new ConcurrentHashMap<String, CertificateAuthenticatorFactory>();
    private final AtomicReference<CertificateAuthenticator> authenticator = new AtomicReference();

    public void setRequired() {
        this.required.set(true);
    }

    public void addCertificateAuthenticatorFactory(CertificateAuthenticatorFactory factory) {
        Preconditions.checkArgument((this.factories.putIfAbsent(factory.getName(), factory) == null ? 1 : 0) != 0, (String)"Certificate authenticator '%s' is already registered", (Object)factory.getName());
    }

    public void loadCertificateAuthenticator() throws Exception {
        CertificateAuthenticator authenticator;
        if (!this.required.get()) {
            return;
        }
        File configFile = CONFIG_FILE.getAbsoluteFile();
        if (!configFile.exists()) {
            this.useDefaultAuthenticator();
            return;
        }
        HashMap properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath()));
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Certificate authenticator configuration %s does not contain '%s'", (Object)configFile, (Object)NAME_PROPERTY);
        log.info("-- Loading certificate authenticator --");
        CertificateAuthenticatorFactory factory = this.factories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Certificate authenticator '%s' is not registered", (Object)name);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            authenticator = factory.create((Map)ImmutableMap.copyOf(properties));
        }
        this.authenticator.set(Objects.requireNonNull(authenticator, "authenticator is null"));
        log.info("-- Loaded certificate authenticator %s --", new Object[]{name});
    }

    public CertificateAuthenticator getAuthenticator() {
        Preconditions.checkState((this.authenticator.get() != null ? 1 : 0) != 0, (Object)"authenticator was not loaded");
        return this.authenticator.get();
    }

    public void useDefaultAuthenticator() {
        this.authenticator.set(certificates -> ((X509Certificate)certificates.get(0)).getSubjectX500Principal());
    }
}

