/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.type.FunctionType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class InterpretedFunctionInvoker {
    private final Metadata metadata;

    public InterpretedFunctionInvoker(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public Object invoke(ResolvedFunction function, ConnectorSession session, Object ... arguments) {
        return this.invoke(function, session, Arrays.asList(arguments));
    }

    public Object invoke(ResolvedFunction function, ConnectorSession session, List<Object> arguments) {
        FunctionInvoker invoker = this.metadata.getScalarFunctionInvoker(function, InterpretedFunctionInvoker.getInvocationConvention(function.getSignature(), function.getFunctionNullability()));
        MethodHandle method = invoker.getMethodHandle();
        ArrayList<Object> actualArguments = new ArrayList<Object>();
        if (invoker.getInstanceFactory().isPresent()) {
            try {
                actualArguments.add(invoker.getInstanceFactory().get().invoke());
            }
            catch (Throwable throwable) {
                throw InterpretedFunctionInvoker.propagate(throwable);
            }
        }
        if (method.type().parameterCount() > actualArguments.size() && method.type().parameterType(actualArguments.size()) == ConnectorSession.class) {
            actualArguments.add(session);
        }
        int lambdaArgumentIndex = 0;
        for (int i = 0; i < arguments.size(); ++i) {
            Object argument = arguments.get(i);
            if (argument == null && !function.getFunctionNullability().isArgumentNullable(i)) {
                return null;
            }
            if (function.getSignature().getArgumentTypes().get(i) instanceof FunctionType) {
                argument = MethodHandleProxies.asInterfaceInstance(invoker.getLambdaInterfaces().get(lambdaArgumentIndex), (MethodHandle)argument);
                ++lambdaArgumentIndex;
            }
            actualArguments.add(argument);
        }
        try {
            return method.invokeWithArguments(actualArguments);
        }
        catch (Throwable throwable) {
            throw InterpretedFunctionInvoker.propagate(throwable);
        }
    }

    private static InvocationConvention getInvocationConvention(BoundSignature signature, FunctionNullability functionNullability) {
        ImmutableList.Builder argumentConventions = ImmutableList.builder();
        for (int i = 0; i < signature.getArgumentTypes().size(); ++i) {
            Type type = signature.getArgumentTypes().get(i);
            if (type instanceof FunctionType) {
                argumentConventions.add((Object)InvocationConvention.InvocationArgumentConvention.FUNCTION);
                continue;
            }
            if (functionNullability.isArgumentNullable(i)) {
                argumentConventions.add((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
                continue;
            }
            argumentConventions.add((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
        }
        return new InvocationConvention((List)argumentConventions.build(), functionNullability.isReturnNullable() ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, true, true);
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

