/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import lombok.Generated;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericRecordBuilder;
import org.apache.pulsar.client.impl.schema.generic.AbstractMultiVersionGenericReader;
import org.apache.pulsar.client.impl.schema.generic.AvroRecordBuilderImpl;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroWriter;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.client.impl.schema.generic.MultiVersionGenericAvroReader;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericAvroSchema
extends GenericSchemaImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericAvroSchema.class);
    public static final String OFFSET_PROP = "__AVRO_READ_OFFSET__";

    public GenericAvroSchema(SchemaInfo schemaInfo) {
        this(schemaInfo, true);
    }

    GenericAvroSchema(SchemaInfo schemaInfo, boolean useProvidedSchemaAsReaderSchema) {
        super(schemaInfo);
        this.setReader(new MultiVersionGenericAvroReader(useProvidedSchemaAsReaderSchema, this.schema));
        this.setWriter(new GenericAvroWriter(this.schema));
        if (schemaInfo.getProperties().containsKey(OFFSET_PROP)) {
            this.schema.addProp(OFFSET_PROP, (String)schemaInfo.getProperties().get(OFFSET_PROP));
        }
    }

    public GenericRecordBuilder newRecordBuilder() {
        return new AvroRecordBuilderImpl(this);
    }

    public boolean supportSchemaVersioning() {
        return true;
    }

    @Override
    public Schema<GenericRecord> clone() {
        GenericSchemaImpl schema = GenericAvroSchema.of(this.schemaInfo, ((AbstractMultiVersionGenericReader)this.reader).useProvidedSchemaAsReaderSchema);
        if (this.schemaInfoProvider != null) {
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
        }
        return schema;
    }
}

